/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.gradle.api.Action;
import org.gradle.api.internal.artifacts.cache.ArtifactResolutionControl;
import org.gradle.api.internal.artifacts.cache.DependencyResolutionControl;
import org.gradle.api.internal.artifacts.cache.ModuleResolutionControl;
import org.gradle.api.internal.artifacts.configurations.CachePolicy;
import org.gradle.api.internal.artifacts.configurations.MutationValidator;
import org.gradle.api.internal.artifacts.ivyservice.CacheExpirationControl;
import org.gradle.api.internal.artifacts.ivyservice.DefaultCacheExpirationControl;

public class DefaultCachePolicy
implements CachePolicy {
    private static final int SECONDS_IN_DAY = 86400;
    private static final int MILLISECONDS_IN_DAY = 86400000;
    final List<Action<? super DependencyResolutionControl>> dependencyCacheRules;
    final List<Action<? super ModuleResolutionControl>> moduleCacheRules;
    final List<Action<? super ArtifactResolutionControl>> artifactCacheRules;
    private MutationValidator mutationValidator = MutationValidator.IGNORE;
    private long keepDynamicVersionsFor = 86400000L;
    private long keepChangingModulesFor = 86400000L;
    private boolean offline = false;
    private boolean refresh = false;

    public DefaultCachePolicy() {
        this.dependencyCacheRules = new ArrayList<Action<? super DependencyResolutionControl>>(1);
        this.moduleCacheRules = new ArrayList<Action<? super ModuleResolutionControl>>(1);
        this.artifactCacheRules = new ArrayList<Action<? super ArtifactResolutionControl>>(2);
        this.cacheDynamicVersionsFor(86400, TimeUnit.SECONDS);
        this.cacheChangingModulesFor(86400, TimeUnit.SECONDS);
        this.cacheMissingArtifactsFor(86400, TimeUnit.SECONDS);
    }

    private DefaultCachePolicy(DefaultCachePolicy policy) {
        this.dependencyCacheRules = new ArrayList<Action<? super DependencyResolutionControl>>(policy.dependencyCacheRules);
        this.moduleCacheRules = new ArrayList<Action<? super ModuleResolutionControl>>(policy.moduleCacheRules);
        this.artifactCacheRules = new ArrayList<Action<? super ArtifactResolutionControl>>(policy.artifactCacheRules);
        this.keepDynamicVersionsFor = policy.keepDynamicVersionsFor;
        this.keepChangingModulesFor = policy.keepChangingModulesFor;
        this.offline = policy.offline;
        this.refresh = policy.refresh;
    }

    @Override
    public void setMutationValidator(MutationValidator validator) {
        this.mutationValidator = validator;
    }

    @Override
    public void setOffline() {
        this.mutationValidator.validateMutation(MutationValidator.MutationType.STRATEGY);
        this.offline = true;
    }

    @Override
    public void setRefreshDependencies() {
        this.mutationValidator.validateMutation(MutationValidator.MutationType.STRATEGY);
        this.refresh = true;
    }

    @Override
    public void cacheDynamicVersionsFor(int value, TimeUnit unit) {
        this.keepDynamicVersionsFor = unit.toMillis(value);
        this.mutationValidator.validateMutation(MutationValidator.MutationType.STRATEGY);
        this.dependencyCacheRules.add(0, (Action<? super DependencyResolutionControl>)((Action)dependencyResolutionControl -> {
            if (!((Set)dependencyResolutionControl.getCachedResult()).isEmpty()) {
                dependencyResolutionControl.cacheFor(value, unit);
            }
        }));
    }

    @Override
    public void cacheChangingModulesFor(int value, TimeUnit units) {
        this.keepChangingModulesFor = units.toMillis(value);
        this.mutationValidator.validateMutation(MutationValidator.MutationType.STRATEGY);
        this.moduleCacheRules.add(0, (Action<? super ModuleResolutionControl>)((Action)moduleResolutionControl -> {
            if (moduleResolutionControl.isChanging()) {
                moduleResolutionControl.cacheFor(value, units);
            }
        }));
        this.artifactCacheRules.add(0, (Action<? super ArtifactResolutionControl>)((Action)artifactResolutionControl -> {
            if (artifactResolutionControl.belongsToChangingModule()) {
                artifactResolutionControl.cacheFor(value, units);
            }
        }));
    }

    private void cacheMissingArtifactsFor(int value, TimeUnit units) {
        this.mutationValidator.validateMutation(MutationValidator.MutationType.STRATEGY);
        this.artifactCacheRules.add(0, (Action<? super ArtifactResolutionControl>)((Action)artifactResolutionControl -> {
            if (artifactResolutionControl.getCachedResult() == null) {
                artifactResolutionControl.cacheFor(value, units);
            }
        }));
    }

    @Override
    public CachePolicy copy() {
        return new DefaultCachePolicy(this);
    }

    @Override
    public CacheExpirationControl asImmutable() {
        return new DefaultCacheExpirationControl((ImmutableList<Action<? super DependencyResolutionControl>>)ImmutableList.copyOf(this.dependencyCacheRules), (ImmutableList<Action<? super ModuleResolutionControl>>)ImmutableList.copyOf(this.moduleCacheRules), (ImmutableList<Action<? super ArtifactResolutionControl>>)ImmutableList.copyOf(this.artifactCacheRules), this.keepDynamicVersionsFor, this.keepChangingModulesFor, this.offline, this.refresh);
    }
}

