// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

package org.chromium.mojo.bindings;

import org.chromium.build.annotations.NullMarked;
import org.chromium.mojo.system.Handle;

import java.io.Closeable;

/**
 * Describes a class that owns a handle.
 *
 * @param <H> The type of the owned handle.
 */
@NullMarked
public interface HandleOwner<H extends Handle> extends Closeable {

    /** Pass the handle owned by this class. */
    public H passHandle();

    /**
     * @see java.io.Closeable#close()
     */
    @Override
    public void close();
}
