// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/webnn/public/cpp/data_type_limits.h"

namespace webnn {

DataTypeLimits::DataTypeLimits(mojo::DefaultConstruct::Tag) {}

DataTypeLimits::DataTypeLimits(SupportedDataTypes input,
                               SupportedDataTypes constant,
                               SupportedTensors arg_min_max_input,
                               SupportedDataTypes arg_min_max_output,
                               SupportedDataTypes batch_normalization_input,
                               SupportedTensors cast_input,
                               SupportedTensors clamp_input,
                               SupportedDataTypes concat_inputs,
                               SupportedDataTypes conv2d_input,
                               SupportedDataTypes conv_transpose2d_input,
                               SupportedTensors cumulative_sum_input,
                               SupportedDataTypes dequantize_linear_input,
                               SupportedDataTypes dequantize_linear_scale,
                               SupportedTensors add_input,
                               SupportedTensors sub_input,
                               SupportedTensors mul_input,
                               SupportedTensors div_input,
                               SupportedTensors max_input,
                               SupportedTensors min_input,
                               SupportedTensors pow_input,
                               SupportedTensors equal_input,
                               SupportedTensors greater_input,
                               SupportedTensors greater_or_equal_input,
                               SupportedTensors lesser_input,
                               SupportedTensors lesser_or_equal_input,
                               SupportedTensors not_equal_input,
                               SupportedTensors logical_and_input,
                               SupportedTensors logical_or_input,
                               SupportedTensors logical_xor_input,
                               SupportedTensors logical_not_input,
                               SupportedDataTypes logical_output,
                               SupportedTensors abs_input,
                               SupportedTensors ceil_input,
                               SupportedTensors cos_input,
                               SupportedTensors erf_input,
                               SupportedTensors exp_input,
                               SupportedTensors floor_input,
                               SupportedTensors identity_input,
                               SupportedTensors log_input,
                               SupportedTensors neg_input,
                               SupportedTensors reciprocal_input,
                               SupportedTensors sign_input,
                               SupportedTensors sin_input,
                               SupportedTensors sqrt_input,
                               SupportedTensors tan_input,
                               SupportedTensors elu_input,
                               SupportedTensors expand_input,
                               SupportedDataTypes gather_input,
                               SupportedDataTypes gather_indices,
                               SupportedDataTypes gather_elements_input,
                               SupportedDataTypes gather_elements_indices,
                               SupportedDataTypes gather_nd_input,
                               SupportedDataTypes gather_nd_indices,
                               SupportedTensors gelu_input,
                               SupportedDataTypes gemm_input,
                               SupportedDataTypes gru_input,
                               SupportedDataTypes gru_cell_input,
                               SupportedTensors hard_sigmoid_input,
                               SupportedTensors hard_swish_input,
                               SupportedDataTypes instance_normalization_input,
                               SupportedDataTypes layer_normalization_input,
                               SupportedTensors leaky_relu_input,
                               SupportedTensors linear_input,
                               SupportedDataTypes lstm_input,
                               SupportedDataTypes lstm_cell_input,
                               SupportedTensors matmul_input,
                               SupportedTensors pad_input,
                               SupportedTensors average_pool2d_input,
                               SupportedTensors l2_pool2d_input,
                               SupportedTensors max_pool2d_input,
                               SupportedDataTypes prelu_input,
                               SupportedDataTypes quantize_linear_input,
                               SupportedDataTypes quantize_linear_zero_point,
                               SupportedTensors reduce_l1_input,
                               SupportedTensors reduce_l2_input,
                               SupportedTensors reduce_log_sum_input,
                               SupportedTensors reduce_log_sum_exp_input,
                               SupportedTensors reduce_max_input,
                               SupportedTensors reduce_mean_input,
                               SupportedTensors reduce_min_input,
                               SupportedTensors reduce_product_input,
                               SupportedTensors reduce_sum_input,
                               SupportedTensors reduce_sum_square_input,
                               SupportedTensors relu_input,
                               SupportedTensors resample2d_input,
                               SupportedTensors reshape_input,
                               SupportedTensors reverse_input,
                               SupportedDataTypes scatter_elements_input,
                               SupportedDataTypes scatter_elements_indices,
                               SupportedDataTypes scatter_nd_input,
                               SupportedDataTypes scatter_nd_indices,
                               SupportedTensors sigmoid_input,
                               SupportedTensors slice_input,
                               SupportedTensors softmax_input,
                               SupportedTensors softplus_input,
                               SupportedTensors softsign_input,
                               SupportedTensors split_input,
                               SupportedTensors tanh_input,
                               SupportedTensors tile_input,
                               SupportedTensors transpose_input,
                               SupportedTensors triangular_input,
                               SupportedTensors where_condition,
                               SupportedTensors where_value)
    : input(input),
      constant(constant),
      arg_min_max_input(arg_min_max_input),
      arg_min_max_output(arg_min_max_output),
      batch_normalization_input(batch_normalization_input),
      cast_input(cast_input),
      clamp_input(clamp_input),
      concat_inputs(concat_inputs),
      conv2d_input(conv2d_input),
      conv_transpose2d_input(conv_transpose2d_input),
      cumulative_sum_input(cumulative_sum_input),
      dequantize_linear_input(dequantize_linear_input),
      dequantize_linear_scale(dequantize_linear_scale),
      add_input(add_input),
      sub_input(sub_input),
      mul_input(mul_input),
      div_input(div_input),
      max_input(max_input),
      min_input(min_input),
      pow_input(pow_input),
      equal_input(equal_input),
      greater_input(greater_input),
      greater_or_equal_input(greater_or_equal_input),
      lesser_input(lesser_input),
      lesser_or_equal_input(lesser_or_equal_input),
      not_equal_input(not_equal_input),
      logical_and_input(logical_and_input),
      logical_or_input(logical_or_input),
      logical_xor_input(logical_xor_input),
      logical_not_input(logical_not_input),
      logical_output(logical_output),
      abs_input(abs_input),
      ceil_input(ceil_input),
      cos_input(cos_input),
      erf_input(erf_input),
      exp_input(exp_input),
      floor_input(floor_input),
      identity_input(identity_input),
      log_input(log_input),
      neg_input(neg_input),
      reciprocal_input(reciprocal_input),
      sign_input(sign_input),
      sin_input(sin_input),
      sqrt_input(sqrt_input),
      tan_input(tan_input),
      elu_input(elu_input),
      expand_input(expand_input),
      gather_input(gather_input),
      gather_indices(gather_indices),
      gather_elements_input(gather_elements_input),
      gather_elements_indices(gather_elements_indices),
      gather_nd_input(gather_nd_input),
      gather_nd_indices(gather_nd_indices),
      gelu_input(gelu_input),
      gemm_input(gemm_input),
      gru_input(gru_input),
      gru_cell_input(gru_cell_input),
      hard_sigmoid_input(hard_sigmoid_input),
      hard_swish_input(hard_swish_input),
      instance_normalization_input(instance_normalization_input),
      layer_normalization_input(layer_normalization_input),
      leaky_relu_input(leaky_relu_input),
      linear_input(linear_input),
      lstm_input(lstm_input),
      lstm_cell_input(lstm_cell_input),
      matmul_input(matmul_input),
      pad_input(pad_input),
      average_pool2d_input(average_pool2d_input),
      l2_pool2d_input(l2_pool2d_input),
      max_pool2d_input(max_pool2d_input),
      prelu_input(prelu_input),
      quantize_linear_input(quantize_linear_input),
      quantize_linear_zero_point(quantize_linear_zero_point),
      reduce_l1_input(reduce_l1_input),
      reduce_l2_input(reduce_l2_input),
      reduce_log_sum_input(reduce_log_sum_input),
      reduce_log_sum_exp_input(reduce_log_sum_exp_input),
      reduce_max_input(reduce_max_input),
      reduce_mean_input(reduce_mean_input),
      reduce_min_input(reduce_min_input),
      reduce_product_input(reduce_product_input),
      reduce_sum_input(reduce_sum_input),
      reduce_sum_square_input(reduce_sum_square_input),
      relu_input(relu_input),
      resample2d_input(resample2d_input),
      reshape_input(reshape_input),
      reverse_input(reverse_input),
      scatter_elements_input(scatter_elements_input),
      scatter_elements_indices(scatter_elements_indices),
      scatter_nd_input(scatter_nd_input),
      scatter_nd_indices(scatter_nd_indices),
      sigmoid_input(sigmoid_input),
      slice_input(slice_input),
      softmax_input(softmax_input),
      softplus_input(softplus_input),
      softsign_input(softsign_input),
      split_input(split_input),
      tanh_input(tanh_input),
      tile_input(tile_input),
      transpose_input(transpose_input),
      triangular_input(triangular_input),
      where_condition(where_condition),
      where_value(where_value) {}

DataTypeLimits::DataTypeLimits(const DataTypeLimits&) = default;
DataTypeLimits& DataTypeLimits::operator=(const DataTypeLimits&) = default;
DataTypeLimits::DataTypeLimits(DataTypeLimits&&) noexcept = default;
DataTypeLimits& DataTypeLimits::operator=(DataTypeLimits&&) noexcept = default;

DataTypeLimits::~DataTypeLimits() = default;

}  // namespace webnn
