// Copyright (C) 2016 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR GPL-3.0-only WITH Qt-GPL-exception-1.0

#pragma once

#include "icontext.h"

#include <QObject>

QT_BEGIN_NAMESPACE
class QAction;
class QMenu;
class QWidget;
QT_END_NAMESPACE

namespace Core {
namespace Internal {

class WindowList
{
public:
    ~WindowList();

    void addWindow(QWidget *window);
    void removeWindow(QWidget *window);
    void setActiveWindow(QWidget *window);
    void updateVisibility(QWidget *window);

private:
    void activateWindow(QAction *action);
    void updateTitle(QWidget *window, int index = -1);
    void updateVisibility(QWidget *window, int index);

    std::unique_ptr<QMenu> m_dockMenu;
    QList<QWidget *> m_windows;
    QList<QAction *> m_windowActions;
    QList<Utils::Id> m_windowActionIds;
};

class WindowSupport : public QObject
{
    Q_OBJECT
public:
    WindowSupport(QWidget *window, const Context &context, const Context &actionContext = {});
    ~WindowSupport() override;

    void setCloseActionEnabled(bool enabled);

protected:
    bool eventFilter(QObject *obj, QEvent *event) override;

private:
    void toggleFullScreen();
    void updateFullScreenAction();

    QWidget *m_window;
    QAction *m_minimizeAction;
    QAction *m_zoomAction;
    QAction *m_closeAction;
    QAction *m_toggleFullScreenAction;
    Qt::WindowStates m_previousWindowState;
    bool m_shutdown = false;
};

} // Internal
} // Core
