#include "GamePartner.h"

extern u8 nbmoves;
extern Board curboard;

/* chess viewer */
extern	void	computerMove(u8,u8,u8);
extern	void	playerMove(u8);
extern	void	showBoard();
extern	u8		selPos(u8 src);
extern	s16		getClock(u8);

/* chess engine */
extern	void	init(u8,u8);
extern	void	playMove(u8,u8,u8,u8,u8);
extern	u8		getPatMat(Board,u8);
extern	s16		searchMove(u8);

extern	const LEVEL	*level;
extern	u8			cursrc;
extern	u8			curdst;
extern	u8			reset;
extern	u8			lastsrc;
extern	u8			lastdst;

/**
 *
 */

void abortGame()
{
	reset = 1;
}

/**
 *
 */

u8 playChess(u8 col,u8 lvl,u8 usebook)
{
	u8 res;

	init(lvl,usebook);
	showBoard();
	while (1)
	{
		if (col==BLACK)
		{
			playerMove(WHITE);
			if (reset)
				return ABORT;
			if (getClock(WHITE)==0)
				return ITIMEOUT;
			nbmoves++;
			res = getPatMat(curboard,WHITE);
			if (res==PAT)
				return STALEMAT;
			else if (res==MAT)
				return YOUWIN;
			else if (res!=NOPM)
				return res;
		}
		searchMove(col);
		if (cursrc==DEAD)
			return RESIGN;
		playMove(cursrc,curdst,T_QUEEN,1,1);
		computerMove(cursrc,curdst,T_QUEEN);
		if (reset)
			return ABORT;
		if (getClock(col)==0)
			return YTIMEOUT;
		nbmoves++;
		res = getPatMat(curboard,col);
		if (res==MAT)
			return IWIN;
		else if (res==PAT)
			return STALEMAT;
		else if (res!=NOPM)
			return res;
		if (col==WHITE)
		{
			playerMove(BLACK);
			if (reset)
				return ABORT;
			if (getClock(BLACK)==0)
				return ITIMEOUT;
			nbmoves++;
			res = getPatMat(curboard,BLACK);
			if (res!=NOPM)
				return res;
		}
	}
	return PAT;
}
