
in vec2 texCoord;

uniform sampler2D colorMap;
uniform sampler2D stretchMap;
uniform sampler2D displaceMap;

uniform float rnd;
uniform float time;
uniform float power;

uniform float testvalue;
//uniform vec4 glColor;


/*
void main (void)
{
	float time2=time/(0.5+0.5*rnd)/6.0/2.5;
	//float horizontalstretch=pow(texture2D(stretchMap, texCoord+vec2(0.0,rnd+time2)).r*time3*1.25,3.4);
	//float horizontalstretch=pow(texture2D(stretchMap, texCoord+vec2(0.0,rnd)).r*time3*1.25,3.4);
	//float horizontalstretch=pow(texture2D(stretchMap, texCoord).r*time3*1.25,3.4);

	vec4 res=vec4(0.0);
	int divider=0;
	for (float f=0.0; f<5.0; f+=1.0/5.0){
		divider++;
		float time3=clamp((1.0-pow(time,1.2))-f/30.0/2.0,0.0,1.0);
		float f_=f*(1.0/1080.0);
		float xz=texCoord.x/1920.0*f;
		float yz=texCoord.y/1080.0*f;
		vec2 texCoord_=texCoord-vec2(xz,yz);
		float zoom=pow(texture2D(stretchMap, texCoord_).r*(time3)*1.25,1.4);
		//float verticaldisplace=(texture2D(displaceMap, texCoord+vec2(0.0,rnd+time2)).r-0.5)*time3/testvalue;
		//float verticaldisplace=0.0f;

		
		//float xcoo=(texCoord.x-0.5)/(1.0+horizontalstretch)+0.5;
		//float ycoo=(texCoord.y+verticaldisplace);
		
		float xcoo=(texCoord_.x-0.5)/(1.0+zoom)+0.5;
		float ycoo=(texCoord_.y-0.5)/(1.0+zoom)+0.5;
		res+=texture2D(colorMap, vec2(xcoo,ycoo));
	}
	res/=float(divider);
	vec4 col=res;
	

	gl_FragColor = col;
}
*/
void main(void)
{
	vec2 uv = texCoord;
	float xc=1920.0/2.0;
	float yc=1080.0/2.0;

	float w = (xc/1920.0 - (uv.x)) * (1920.0 / 1080.0);
	float h = yc/1080.0 - uv.y;
	float distanceFromCenter = sqrt(w * w + h * h)+time*1.5;

    float time_=time*2.5;
	float sinArg = (distanceFromCenter * 175.0/4.6 - time_/20.0)/4.0;
	//float sinArg = (distanceFromCenter * 175.0 - time_/testvalue)/4.0;
	float slope = cos(sinArg) * 0.015;

	float fade=sin(distanceFromCenter+time*6.28);

slope=slope*fade*texture2D(stretchMap,texCoord).r*power*pow(1.0-time,1.0); //fade with mask  // power -4..5
	vec2 coos=(uv + normalize(vec2(w, h)) * slope);
	/*
	if (coos.x<0.0) coos.x=-coos.x; 
	if (coos.x>1.0) coos.x=2.0-coos.x;
	if (coos.y<0.0) coos.y=-coos.y; 
	if (coos.y>1.0) coos.y=2.0-coos.y;
	*/
	vec4 color;
	if ((coos.x<0.0)||(coos.x>1.0)||(coos.y<0.0)||(coos.y>1.0))
		//color=vec4(0,0,0,1);
		color = texture2D(colorMap, texCoord);
	else
		color = texture2D(colorMap, coos);

	gl_FragColor = color;
}
