varying vec2 texCoord;

uniform sampler2D colorMap;
uniform float iTime;
uniform float testvalue;

float Hash2d(vec2 uv)
{
    float f = uv.x + uv.y * 37.0;
    return fract(sin(f)*104003.9);
}

float mixP(float f0, float f1, float a)
{
    return mix(f0, f1, a*a*(3.0-2.0*a));
}
const vec2 zeroOne = vec2(0.0, 1.0);
float noise2d(vec2 uv)
{
    vec2 fr = fract(uv.xy);
    vec2 fl = floor(uv.xy);
    float h00 = Hash2d(fl);
    float h10 = Hash2d(fl + zeroOne.yx);
    float h01 = Hash2d(fl + zeroOne);
    float h11 = Hash2d(fl + zeroOne.yy);
    return mixP(mixP(h00, h10, fr.x), mixP(h01, h11, fr.x), fr.y);
}

float Hash3d(vec3 uv)
{
    float f = uv.x + uv.y * 37.0 + uv.z * 521.0;
    return fract(sin(f)*110003.9);
}

float noiseValue(vec3 uv)
{
    vec3 fr = fract(uv.xyz);
    vec3 fl = floor(uv.xyz);
    float h000 = Hash3d(fl);
    float h100 = Hash3d(fl + zeroOne.yxx);
    float h010 = Hash3d(fl + zeroOne.xyx);
    float h110 = Hash3d(fl + zeroOne.yyx);
    float h001 = Hash3d(fl + zeroOne.xxy);
    float h101 = Hash3d(fl + zeroOne.yxy);
    float h011 = Hash3d(fl + zeroOne.xyy);
    float h111 = Hash3d(fl + zeroOne.yyy);
    return mixP(
        mixP(mixP(h000, h100, fr.x),
             mixP(h010, h110, fr.x), fr.y),
        mixP(mixP(h001, h101, fr.x),
             mixP(h011, h111, fr.x), fr.y)
        , fr.z);
}

void main (void)
{
    
    

    float scale=0.125*2.75;
    float x=texCoord.x/scale*(1920.0/1080.0);
    float y=texCoord.y/scale;
	float distorttime1=(noiseValue(vec3(x+1000.5,y+1100.5,iTime*1.05)));
	float distorttime2=(noiseValue(vec3(x+2000.3,y+2200.3,iTime*1.12)));
	float distortintensity=(noiseValue(vec3(x/1.5+3000.4,y/1.5+3300.5,iTime*1.145)));
	vec2 distort=vec2(noiseValue(vec3(x,y,iTime+distorttime1)),noiseValue(vec3(x+iTime/100.0,y,iTime+10000.5+distorttime2)));
	vec2 distort2=vec2(noiseValue(vec3(x/1.22,y/1.22,iTime*1.12+distorttime2)),noiseValue(vec3(x+iTime/85.0,y,iTime*1.35+11000.3+distorttime1)));
    
    
    distort+=distort2;
    distort/=1.85;
    distort=((vec2(0.5)-distort)*2.0/4.0);
    distort/=20.0/1.7;
    distort*=distortintensity;
    distort=texCoord+distort;
    distort.x=clamp(distort.x,1.0/1920.0,1.0-1.0/1920.0);
    distort.y=clamp(distort.y,1.0/1080.0,1.0-1.0/1080.0);
    
	vec4 color=texture2D(colorMap, distort);
	

    gl_FragColor = color;
}
