; Nyan Cat for Sinclair QL

	include qlnotes.inc

LOOPPOS	equ	52*6
LOOPTK	equ	160

	org	196608

; Lowres, 1st page, no blank
	move.b	#$8,$18063

; Set interrupt hook
	move.b	#$1c,d0
	lea	huuk,a0
	trap	#1

; Clear screen to black
	move.l	#$20000,a0
	move.l	#32767/4,d0
	moveq	#0,d1

klear	move.l	d1,(a0)+
	dbra	d0,klear

; Wait until music main loop starts

	move.l	#160,d0
blankko	jsr	waitvb
	dbra	d0,blankko

; Clear screen to checkered dark blue
	move.l	#255,d0
	move.l	#$20000,a0

outer 	btst	#0,d0
	beq	odd
	move.l	#$00440044,d1
	bra	onward

odd	move.l	#$00110011,d1

onward	move.l	#31,d2

line	move.l	d1,(a0)+
	dbra	d2,line

	dbra	d0,outer

; The first frame is different
	lea	_frame0,a1
	jsr	drawdiff

	lea	luuppi,a2

; Main loop
jumi
	jsr	waitvb	; Slow down, sailor!
	jsr	waitvb

; There you have it: a busyloop to remove the raster split :/
	move.l	#1500,d0
slowie	dbra	d0,slowie

	move.l	(a2)+,a1
	jsr	drawdiff
	cmp.l	#0,(a2)
	bne	jumi

	lea	luuppi,a2
	bra	jumi

; Draw a frame as a diff
drawdiff
	move.l	#$20000,a0
	move.l	(a1)+,d0
	lsr.l	#1,d0
	lsr.l	#1,d0
	subq	#1,d0

next	add.w	(a1)+,a0
	move.l	(a1)+,(a0)
	add.w	(a1)+,a0
	move.l	(a1)+,(a0)
	dbra	d0,next

	rts

; Waits for the next frame
waitvb	movem	d0,-(sp)
	move.l	vbcount,d0

notyet	cmp.l	vbcount,d0
	beq	notyet

	movem	(sp)+,d0
	rts

; Polling interrupt handler, also known as the player
handler
	movem	d0-d1/d5/d7/a0/a3,-(sp)

	move.l	petteri,a0
	moveq	#0,d0
	move.w	(a0)+,d0
	cmp.l	mycounter,d0
	bne	nuttin

; New row
	move.w	(a0)+,d0
	cmp.w	#NOTE_OFF,d0
	beq	killnote

; New note
	move.w	(a0)+,d0
	move.b	d0,paramblk+6
	moveq	#$11,d0
	lea	paramblk,a3
	trap	#1
	bra	adelante

; Stop sound
killnote
	moveq	#$11,d0
	lea	nosound,a3
	trap	#1
	addq.l	#2,a0

adelante
	move.l	a0,petteri

nuttin
	addq.l	#1,mycounter

; Loop
	move.l	#1440,d0
	cmp.l	mycounter,d0
	bne	skippa
	move.l	#LOOPTK,mycounter
	move.l	#biisi+LOOPPOS,petteri

skippa
	addq.l	#1,vbcount

	movem	(sp)+,d0-d1/d5/d7/a0/a3
	rts

; Animation loop frame pointers
luuppi	dc.l	_frame1
	dc.l	_frame2
	dc.l	_frame3
	dc.l	_frame4
	dc.l	_frame5
	dc.l	_frame6
	dc.l	_frame7
	dc.l	_frame8
	dc.l	_frame9
	dc.l	_frame10
	dc.l	_frame11
	dc.l	_frame12
	dc.l	0

huuk	dc.l	0
	dc.l	handler
vbcount	dc.l	0

mycounter dc.l	0
petteri	dc.l	biisi

; Note params for that sad IPC call
paramblk
	dc.b	$a		; Initiate sound
	dc.b	8		; Number of parameters
	dc.l	$aaaa		; Codes

	dc.b	64		; Pitch 1
	dc.b	64		; Pitch 2
	dc.w	0		; Interval between steps
	dc.w	0		; Duration (0 = inf)
	dc.b	0		; hi nibble: step in pitch, lo: wrap
	dc.b	0		; hi: randomness, lo: fuzziness

	dc.b	1		; Reply code (maybe not used)

	align	2
nosound
	dc.b	$b		; Stop sound
	dc.b	0
	dc.l	0
	dc.b	1

	align	2
	include nyanbiisi.inc

	include 'frames.inc'
