;ST Slideshow demo
;ZX Freeq (c) 2016
;Speccy 2016.1 party

	;informacja, i kod rdowy kompilujemy
	;pod adres 60000
org 60000

init:
	;inicjalizacja playerka AY
	;muzyka z SoundTrackera skompilowana 
	;przez SoundCompiler pod adres 50120
	;odtwarzanie USR 50126 wykonywane
	;jest podczas przerwania IM 2
	call 50120

	;HALT - synchronizacja ramki,
	;czekamy na pocztek ramki
	halt

	;ustawiamy czarny border
	ld a, 0
	out (254), a

	;ustawiamy atrybuty na caym ekranie
	;3x 256 bajtw - 3 tercje ekranu
	ld b, 3
	ld hl, 22528
loop_cls1:
	push bc
	ld b, 0
loop_cls2:
	ld (hl), 0
	inc hl
	djnz loop_cls2
	pop bc
	djnz loop_cls1

	;tu ustawiamy tryb przerwa IM 2
	;w duym skrcie, podczas kadego przerwania
	;procesor wykonuje kod zapisany pod adresem
	;zapisanym w pamici wskazanej przez IX.
	;jednak kontrolowa moemy tylko I, zatem
	;IX moe przyj wartoci od n do n+256.
	;tu ustawimy I = 253, zatem adres, pod ktry
	;skocze procesor musi by zapisany od 64768
	;do 64768+256+1. Aby adres by zawsze
	;identyczny, bajty modszy i starszy musz
	;by takie same, tu 251. Nasz program zatem
	;zapiszemy pod adresem (251*256)+251 = 64507
	ld hl, 64768
	ld b, 0
	
	;wypeniamy 256+1 adresw wartoci 251
loop_im2fill:
	ld (hl), 251;64507
	inc hl
	djnz loop_im2fill
	ld (hl), 251

	;przepisujemy pod adres 64507 kod, ktry
	;ma by wykonywany podczas przerwania
	;rdo w pliku st_im2.asm, a tutaj wystpuje
	;jako cig bajtw w im2_proc:
im2_load:
	ld bc, 42;dlugosc kodu 
	ld hl, im2_proc
	ld de, 64507;(251*256)+251
	ldir

	;przeczamy w tryb IM 2
im2_init:
	ld a, 253
	ld i, a
	im 2

demo:
	;wywoanie procedury pokazujcej skompresowany
	;obrazek
	call 48677
	
	;procedura nic nie robica, czekamy, aby
	;zsynchronizowa si z muzyk
	call longpause
	call pause
	call pause

	;ustawiamy atrybuty pod nastpny obrazek
	;procedura atrloop ustawia atrybut A, B razy
	;poczwszy od adresu HL
	ld hl, 22850
	ld b, 10
	ld a, 72
	call atrloop
	ld hl, 22882
	ld b, 10
	ld a, 72
	call atrloop
	ld hl, 22877
	ld b, 3
	ld a, 72
	call atrloop
	ld hl, 22909
	ld b, 3
	ld a, 72
	call atrloop

	;poka nastpny obrazek
	call 49305
	call longpause
	call longpause
	
	;czyscimy druga tercj, nakladajac pierwsz
	ld bc, 2048
	ld hl, 16384
	ld de, 18432
	ldir
	
	;i ustawiamy atrybuty
	ld a, 120
	ld hl, 22784
	ld b, 128
	call atrloop

	ld a, 48
	ld hl, 22912
	ld b, 32
	call atrloop
	
	ld a, 32
	ld hl, 22944
	ld b, 32
	call atrloop

	ld a, 72
	ld hl, 22976
	ld b, 64
	call atrloop
	

	;teraz pokazujemy logo, przesuwajc je
	;od prawej do lewej. Obrazek zosta wczeniej
	;odpowiednio przygotowany, kolejno danych
	;zmieniona na "pionow", aby byo atwiej
	;wywietla kolejne kolumny obrazka
	;zaczynamy od prawej strony ekranu,
	;wywietlajc kolejne kolumny obrazka i za
	;kadym przebiegiem cofajc si o jeden bajt
	;w lewo
st_logo:
	ld de, 18464
	ld (logo_start), de	

	ld b, 32		;powtrz 32x - tyle razy 
logo_loop1:			;przesuwamy logo
	halt
	halt
	ld hl, 57952		;adres skad kopiujemy logo
	ld de, (logo_start)	;pobierz do DE poczatek rysowania
	dec de			;zmniejsz o 1
	ld (logo_start), de	;zapisz
	push bc

	ld a, 33		;powtrz 33-b razy, 
	sub b			;tyle kolumn do narysowania do 
	ld b, a			;brzegu ekranu
logo_loop2:
	push bc

	ld b, 64		;powtrz 64 razy, tyle wierszy 
logo_loop3:			;kopiujemy
	ld a, (hl)
	ld (de), a
	inc hl

	push hl
	ld h, d
	ld l, e
	ld de, 32
	add hl, de
	ld d, h
	ld e, l
	pop hl

	djnz logo_loop3
	
	push hl			
	ld h, d
	ld l, e
	ld de, 2047
	sbc hl, de
	ld d, h
	ld e, l
	pop hl

	pop bc
	djnz logo_loop2

	pop bc
	djnz logo_loop1

	call longpause

	;teraz wyjedamy z logo w lew stron
	;kopiujc 32 razy kolejne kolumny z prawej
	;do ssiedniej lewej, zaczynajc od pierwszej
	;od lewego brzegu
	ld b, 32
delogo_loop1:
	halt
	halt
	push bc
	ld hl, 18432
	ld b, 31
delogo_loop2:
	push bc
	
	ld b, 64
delogo_loop3:
	inc hl
	ld a, (hl)
	dec hl
	ld (hl), a

	ld de, 32
	add hl, de
	djnz delogo_loop3
	ld de, 2047
	sbc hl, de
	
	pop bc
	djnz delogo_loop2

	;tu zakrywamy ostatnia kolumne, aby "mieci"
	;nie cigney si za nami w lewo
	push hl
	ld hl, 18463
	ld b, 64
delogo_loop4:
	ld (hl), 255
	ld de, 32
	add hl, de
	djnz delogo_loop4
	pop hl

	pop bc
	djnz delogo_loop1

	;teraz bdziemy pokazywa obrazki
	;procedura cls1 czyci ekran, maskujc go
	;atrybutami
	;procedury pause i longpause to oczekiwanie
	;przez odpowiednio 1 i 3 sekundy
	;poszczeglne wartoci to adresy procedur
	;wywietlajcych skompresowane obrazki
	;procedura cls2 "gasi" ekran przez modyfikacj
	;atrybutw
	call cls1
	halt
	call pause
	call 24500
	call longpause
	call longpause
	call longpause
	halt
	call cls2
	halt
	call 26680
	call longpause
	call longpause
	call longpause
	halt
	call cls2
	halt
	call 31218
	call longpause
	call longpause
	call longpause
	halt
	call cls2
	halt
	call 35194
	call longpause
	call longpause
	call longpause
	halt
	call cls2
	halt
	call 40322
	call longpause
	call longpause
	call longpause
	halt
	call cls2
	halt
	call 45994
	
	;ustawiamy atrybuty pod scroller, bo 
	;obrazek wczesniej tego nie przewidywa
	ld a, 1;8
	ld hl, 22977
	ld b, 11
	call atrloop
	ld a, 5;40
	ld hl, 22979
	ld b, 6
	call atrloop
	ld a, 0
	ld hl, 22987
	ld b, 3
	call atrloop

	;scroller - pochodzi z mojego dema
	;"VOD Part 1", usunita cz pogrubiania
	;tekstu, a dodana cz robica italiki

	;pobierz do zmiennej adres poczatek textu scrolla 
	ld hl, text	;pobierz adres textu
	ld (textloc), hl;zapisz adres w textloc

	;gwna ptla scrollujca przez 1250 ramek
	ld de, 1250	;jak dlugo
scroller:
	halt	
	push de
	ld hl,18624+13	;+13 czyli szerokosc
	ld b,8		;8 wierszy, wysokosc scrolla
scrolloop1:
	push hl		;zapamietaj adres ostatniej kolumny
	ld c,13		;scrollujemy 13 kolumn w lewo
scrolloop2:
	ld a,(hl)
	rla 		;przewijamy w lewo
	ld (hl),a
	dec l		;zmiana adresu w lewo
	dec c
	jr nz,scrolloop2		
	pop hl		;przywroc adres kolmny
	inc h		;nastepny wiersz
	djnz scrolloop1
			;wstaw nowy znak, co 8 scrollowa
	ld a, (onceper8);pobieram zmienna do a
	cp 0		;czy zero?
	jr z, putchar	;skocz do wyswietlania znaku
	jr nz, noputchar;przeskocz wyswietlanie znaku
putchar:
	ld hl, (textloc);pobierz adres z textloc, w hl jest adres kolejnego char ze stringa
	ld a, (hl)	;a zawiera char
	cp 0		;czy koniec tekstu
	jr nz, put
	ld hl, text	;wracamy na poczatek tekstu
	ld (textloc), hl;i zapisujemy do zmiennej adres poczatku tekstu (tak samo jak na poczatku)
put:
	push hl		;zapamietaj hl, potem sie przyda
	ld l, a		;oblicz adres UDG znaku znajdujacego sie w A i zapisz do HL
	ld h, 0
	add hl, hl
	add hl, hl
	add hl, hl	;a*8
	ld de, 15360	
	add hl, de	;teraz w hl mamy adres UDG wlasciwego znaku
	ld b, 8		;skopiuj na ekran 8 bajtow tego znaku
	ld de, 18637	;na ekran tam, gdzie sie scrolluje, to pole jest celowo zakryte
charcopy:		
	ld a, (hl)	
	ld (de), a
	inc d
	inc l
	djnz charcopy

	;italiki poprzez przesunicie w prawo poowy znaku
	ld de, 18637
	ld b, 4
italic:
	ld a, (de)
	rra
	ld (de), a
	inc d
	djnz italic
	
	pop hl		;przywroc hl
	inc hl		;zwieksz index o jeden
	ld (textloc), hl;i zapisz w textloc
noputchar:
	ld a, (onceper8)
	inc a		;zwiekszamy licznik o 1
	and 7		;ale maksymalnie do 8
	ld (onceper8), a;i zapisujemy w pamieci	

	pop de
	dec de
	ld a, d
	or e
	;i tu koniec ptli scrollera
	jp nz, scroller

	;terminate!
	;teraz efekt z gry TERMINATOR 2 na NESa,
	;czyli pokazujemy szum w drugiej tercji ekranu
	
	call cls1
	ld a, 2
	ld hl, 22784
	ld b, 0
	call atrloop

	ld b, 3
terminated_outerloop:
	push bc
	ld b, 0
terminated_loop:
	push bc
	ld bc, 2048
	ld de, 18432	
	ld a, (18432)	;tu ustawiamy skd kopiujemy dane
	or b		;dziki uzaleznieniu od zawartoci
	ld l, a		;ekranu, uzyskujemy efekt pseudo-
	ld h, b		;losowoci
	halt
	ldir
	pop bc
	djnz terminated_loop
	pop bc
	djnz terminated_outerloop
	
	xor a		;to samo co ld a, 0 a mniej bajtw
	ld hl, 22784
	ld b, a
	call atrloop

	;tu ustawiamy domylny tryb przerwa na IM 1
	;i wracamy do basica
return2basic:
	im 1
	ret

	
	;poniej znajduj si procedury wykorzystywane powyej
cls1:
	push hl
	ld hl, 22528
	ld de, 768
cls1_loop:
	ld (hl), 0
	inc hl
	dec de
	ld a, d
	or e
	jr nz, cls1_loop
	pop hl
	ret

cls2:
	ld b, 8
fadeloop1:
	push bc
	ld hl, 22528
	ld de, 768
	halt
	halt
	halt
	halt
	halt
fadeloop2:
	ld a, (hl)
	rra
	rra
	rra
	or a
	jr z, $+3		;pomijamy dec a, jeli a = 0
	dec a
	rla
	rla
	rla
	ld (hl), a
	inc hl
	dec de
	ld a, d
	or e
	jr nz, fadeloop2 
	pop bc
	djnz fadeloop1
	ld b, 16
fadeloop3:
	push bc
	ld hl, 22528
	ld de, 768
	halt
	halt
	halt
	halt
	halt
fadeloop4:
	ld a, (hl)
	rra
	ld (hl), a
	inc hl
	dec de
	ld a, d
	or e
	jr nz, fadeloop4
	pop bc
	djnz fadeloop3

	call cls1
	ret

atrloop:
	ld (hl), a
	inc hl
	djnz atrloop
	ret

pause:			;nic nie rob przez 1 sek
	ld b, 50
pause_loop:
	halt
	djnz pause_loop
	ret
	
longpause:		;nic nie rob przez 3 sek
	ld b, 150
longpause_loop:
	halt
	djnz longpause_loop
	ret


im2_proc:;ponizsze to binarka stdemo-im2.asm
	;czyli zachowanie flag, wywolanie procedury odtwarzajacej AY, border, przywrocenie flag i skok do 56
	defb 245, 229, 197, 213, 205, 206, 195, 22, 15, 1, 253, 255, 62, 10, 237, 121, 237, 120, 146, 32, 11, 62, 1, 211, 254, 209, 193, 225, 241, 195, 56, 0, 175, 211, 254, 209, 193, 225, 241, 195, 56, 0

logo_start:
	defw 0

text:
	defb "           No more free RAM left for cool effects, sorry. ;)   Greetings to SPECCY.PL and friends!   (c) 2016 for Speccy2016.1 party by ZX Freeq                                      ",              0

textloc:
	defw 0

onceper8:
	defb 0

