;Założenia ogólne:
; W głównej części dema ekran podzielony jest na 3 części. Górna i dolna zawiera napisy TERMINATOR i vs THE EMPIRE
; i znajduje się w banku nr 0-1. 
; Środkowa część ekranu, z obrazkiem i kulkami, to 8 ekranów: 16-17 do 30-31. 
; Przełączanie ekranów pomiędzy 0 a pozostałymi następuje w przerwaniach linii w odpowiednich liniach ekranu.


clut:          	EQU  248			; mniej znaczący bajt portu służącego do definiowania kolorów
vmpr:          	EQU  252			; port służący do ustawiania ekranu w konkretnym banku
lmpr:          	EQU  250			; port do ustawiania dolnej połówki RAM w przestrzeni adresowej procesora
hmpr:          	EQU  251			; port do ustawiania górnej połówki RAM w przestrzeni adresowej procesora
lineint:	    EQU  249			; zapis - linia, w której wywołać przerwanie linii. odczyt - typ wywołanego przerwania

linia_g:		EQU  24				; linia na ekranie, od której zaczyna się okno z efektem
linia_start:	EQU  linia_g+61		; linia na środku, od której okno zaczyna się otwierać
kolor_tla:		EQU  1				; kolor tła, ciemny niebieski
obszar_roboczy:	EQU  16384			; adres, pod który dekompresowane są obrazki i różne inne rzeczy
start_szumy:	EQU  32768+24*128	; adres na ekranie, od którego zaczyna się obszar tła z szumem
start_muza:		EQU  8000			; adres, pod który zostały skompilowane muzyczki
adr_march		EQU  32768+8*2048			; adresy muzyczek na stronie z danymi
adr_terminator:	EQU  adr_march+2528
adr_cantina:	EQU  adr_terminator+1885
adr_starwars:	EQU  adr_cantina+2420

bank_p1			EQU 5				; bank, adres startowy i długość obrazka z pierwszej części
start_p1		EQU 32768
dlugosc_p1		EQU 5693
bank_p2			EQU bank_p1			; bank, adres startowy i długość obrazka z drugiej części
start_p2		EQU start_p1+dlugosc_p1
dlugosc_p2		EQU 4920
bank_p3			EQU bank_p2			; itd. itd.
start_p3		EQU start_p2+dlugosc_p2
dlugosc_p3		EQU 7405
bank_p4			EQU bank_p3
start_p4		EQU start_p3+dlugosc_p3
dlugosc_p4		EQU 2995

bank_p5			EQU bank_p4+1
start_p5		EQU start_p4+dlugosc_p4-16384
dlugosc_p5		EQU 8336
bank_p6			EQU bank_p5
start_p6		EQU start_p5+dlugosc_p5
dlugosc_p6		EQU 2657
bank_p7			EQU bank_p6
start_p7		EQU start_p6+dlugosc_p6
dlugosc_p7		EQU 4245
bank_p8			EQU bank_p7
start_p8		EQU start_p7+dlugosc_p7
dlugosc_p8		EQU 8944

bank_p9			EQU bank_p8+1
start_p9		EQU start_p8+dlugosc_p8-16384
dlugosc_p9		EQU 5167
bank_p10		EQU bank_p9
start_p10		EQU start_p9+dlugosc_p9
dlugosc_p10		EQU 2838
bank_p11		EQU bank_p10
start_p11		EQU start_p10+dlugosc_p10
dlugosc_p11		EQU 3181
bank_p12		EQU bank_p11
start_p12		EQU start_p11+dlugosc_p11
dlugosc_p12		EQU 2465
bank_p13		EQU bank_p12
start_p13		EQU start_p12+dlugosc_p12
dlugosc_p13		EQU 4695


	; w momencie startu organizacja pamięci, czyli banki w przestrzeni adresowej wyglądają następująco:
	; ROM0,RAM0,RAM1,RAM2   - każdy bank po 16384 bajty

				ORG 0			; kompilacja całego kodu odbywa się dla adresu startowego 0
								; choć na początku strona pamięci z kodem będzie się znajdować pod adresem 32768
				DI				; wyłączenie przerwań maskowalnych
; na początek tworzenie obrazka z szumem (tłem) z wykorzystaniem zawartości całego ROM0 jako liczb losowych
				LD HL,0			; skopiowanie zawartości ROM-u do RAM-u w celu dalszej obróbki
				LD DE,49152		; skopiowanie pod adres 49152
				LD BC,16384		; tło zajmuje 16384 bajty
				LDIR
								; szum składa się z dwóch wartości pikseli: 0 - czarny lub 3 - szary
								; należy przerobić zawartość z ROM-u na takie wartości
gen_start:		LD HL,49152		; rozpoczęcie tworzenie tła (szumu) od adresu 49152
								; najpierw górna połówka bajtu
gen1:			LD B,0			; najpierw zakładamy, że mamy czarny pixel, czyli 0. wynik tymczasowo w rejestrze B
				LD A,(HL)		; pobieramy wartość z pamięci
				AND 240			; kasujemy dolną połówkę bajtu, zostawiając tylko górną
				CP 16			; jeżeli górna połówka ma wartość większą od 1 (wybrane arbitralnie)
				JR NC,szum0		; to wtedy idziemy dalej
				LD B,32			; jeżeli ma wartość 0 lub 1, to ustawiamy ją na 2, czyli 32 w górnej połówce (wybrane arbitralnie) 
	szum0:		LD A,(HL)		; ponownie pobieramy wartość z pamięci
				AND 15			; i robimy to samo co wyżej, ale dla dolnej połówki bajtu
				CP 1			; jeżeli dolna połówka ma wartość większą od 1 
				LD A,B			; po porównaniu załaduj do A zapamiętaną w B górną połówkę
				JR NC,szum1		; jeżeli ma być czarny, skocz dalej
				OR 2			; a jeżeli szary, do ustawiamy w dolnej połówce wartość 2 
	szum1:
				LD (HL),A		; przeliczone wrzucamy z powrotem w to samo miejsce 
				INC HL			; przechodzimy do następnego bajtu
				LD A,H			; i wykonujemy całą operację ponownie
				OR L			; aż do momentu, gdy HL=0
				JR NZ,gen1		; bo 49152+16384=65536=0
				JP start_main_prog+32768
								; na ciąg dalszy nie ma tu miejsca, bo od adresu 56 są procedury obsługi przerwań w trybie IM 1
								; należy więc skoczyć za te procedury
								; +32768 dlatego, że na razie ten kod jest w pamięci od adresu 32768, a kompilowany jest jakby był od 0
				
				INCLUDE "source/przerwania.asm"

kolory_niebieskie:
				DEFB 1,16,17,25,25,17,16,1		; kolejne kolory przy "niebieskim błysku" na samym początku
kolory_p1:		DEFB 0,8,7,15,112,120,119,127,10,37,11,52,115,60,113,127		; definicje kolorów dla kolejnych części
kolory_p2:		DEFB 0,8,7,15,112,120,119,127,10,37,2,32,34,40,113,127
kolory_p3:		DEFB 0,8,7,15,112,120,119,127,10,36,14,100,118,108,113,127
kolory_p4:		DEFB 0,8,7,15,112,120,119,127,4,64,6,14,126,118,113,127
kolory_p5:		DEFB 0,8,7,15,112,120,119,127,10,37,2,10,107,99,113,127
kolory_p6:		DEFB 0,8,7,15,112,120,119,127,4,64,5,13,125,117,113,127
kolory_p7:		DEFB 0,8,7,15,112,120,119,127,10,37,2,32,47,47,113,127
kolory_p8:		DEFB 0,8,7,15,112,120,119,127,1,16,3,11,123,115,113,127
kolory_p9:		DEFB 0,8,7,15,112,120,119,127,67,86,94,45,114,122,100,127
				
; --------------------------   GLOWNY PROGRAM  -----------------------------------
start_main_prog:
				LD A,3+32		; na początek ustawiamy w dolnej połówce adresowej banki 3 i 4. +32 żeby wyłączyć ROM (all ram)
				OUT (lmpr),A
				LD SP,55		; i ustawiamy stos tuż poniżej procedur obsługi przerwań
				LD HL,32768		; przenosimy cały ten kod do banku 3, który jest teraz pod adresem 0
				LD DE,0			
				LD BC,16384
				LDIR
				JP $+3			; i skaczemy tutaj, ale w banku 3, czyli do bieżącego adresu -32768
				
				IM 1			; włączamy tryb przerwań IM 1, tylko taki będzie używany
				EI				; i włączamy przerwania		
				XOR A			; ustawiamy bank 0 do górnej połówki przestrzeni adresowej
	     		OUT (hmpr),A	; z ekranu =0 będą wyświetlane napisy na górze i dole ekranu, a także greetingsy
				LD HL,32768		; czyścimy ten ekran ldir-em
				LD DE,32769
				LD BC,24575		; pamięć ekranu ma 24576 bajtów
				LD (HL),0
				LDIR
				LD A,96			; ustawiamy jako ekran bank 0 w MODE 4, czyl podstawowym trybie graficznym SAMa
				LD (ekran_gora+1),A	; wstawiamy tą wartość do procedury obsługi przerwania ramki
				
				LD HL,kolory_p9+15	; definiujemy kolory dla tego ekranu
				LD BC,16*256+clut
				OTDR
				
				LD B,8			; następnie robimy "błyśnięcie" niebieskim ekranem
				LD HL,kolory_niebieskie ; kolorami zdefiniowanymi pod wskazanym adresem
	nieb1:		HALT			; kolory zmieniamy do 2 ramki
				HALT

				LD A,(HL)		; pobieramy kolor tła z pamięci
				LD (frame_int+1),A	; i wstawiamy do kodu obsługi przerwania ramki
				INC HL
				DJNZ nieb1		; i tak powtarzamy 8 razy
				
				LD B,50			; czekamy 50 ramek, czyli sekundę
				CALL czekaj
; w dalszej części pokazujemy napisy na górze i dole ekranu, włączając przy okazji odpowiednią muzykę				
				LD HL,adr_terminator	; kopiujemy muzykę z Terminatora pod adres 8000, gdzie wszystkie muzyki są odtwarzane
				CALL kopiuj_muze
				CALL wlacz_muzyke	; włączamy wybraną muzykę
				LD B,20				; czekamy 20 ramek
				CALL czekaj
						; w dalszej części ciekawostka - napis TERMINATOR pokazuje się inaczej niż THE EMPIRE
						; mimo, że jest pokazywany tą samą procedurą 
						; różni się tylko rodzajem skoków wewnątrz procedury, który w tym miejscu jest ustawiany
				LD A,32				; 32 to wartość dla rozkazu JR NZ
				LD (askoki+1),A
				CALL alfa_terminator	; wywołanie procdurki pokazującej napis TERMINATOR
				LD B,60				; czekamy 60 ramek
				CALL czekaj
				CALL wylacz_muzyke	; i wyłączamy muzykę

				LD B,50				; czekamy sekundę
				CALL czekaj
				
				LD HL,adr_march		; to samo co powyżej, ale dla napisu vs THE EMPIRE
				CALL kopiuj_muze
				CALL wlacz_muzyke
				LD B,20
				CALL czekaj
				LD A,40				; tym razem ustawiamy skok JR Z i tak już zostanie do końca dema
				LD (askoki+1),A
				CALL alfa_empire
				LD B,50
				CALL czekaj
				CALL wylacz_muzyke
				LD B,50
				CALL czekaj

				CALL narysuj_kreske	; dalszy etap - rysowanie poziomej kreski na środku ekranu				
				LD A,linia_start	; w tym miejcu przedłużamy narysowaną już kreskę o ramkę, czyli na całą szerokość ekranu
				LD (linia_gora+1),A	; od tego momentu będzie wywoływane przerwanie linii rysujące kreskę na ramce
				
; ciąg dalszy dema działa w pętli - gdy dojdzie do końca, zaczynane jest ponownie od tego miejsca
; w głównej pętli dla każdego obrazka wywoływana jest procedura "dekompresuj_i_pokaz" wraz z parametrami w różnych rejestrach
glowna_petla:		
				LD A,bank_p1			; położenie skompresowanego obrazka w pamięci - bank
				LD DE,start_p1			; położenie skompresowanego obrazka w pamięci - adres 
				LD HL,pokaz1			; adres odpowiedniej procedury pokazywania obrazka
				LD BC,kolory_p1+15		; adres tablicy kolorów kulek w tej części
				LD IY,alfa_terminator	; adres efektu na napisie, ta sama procedura co pokazująca napis na początku
				LD IX,32768+2048*0		; adres ścieżki dla kulek. każda ścieżka ma 2048 bajtów długości
				CALL dekompresuj_i_pokaz	; skok do procedury dla obrazka nr 1

				LD A,bank_p2			; położenie skompresowanego obrazka w pamięci - bank
				LD DE,start_p2			; położenie skompresowanego obrazka w pamięci - adres 
				LD HL,pokaz3			; adres odpowiedniej procedury pokazywania obrazka
				; LD BC,kolory_p2+15		; adres tablicy kolorów kulek w tej części dla dłuższej wersji dema
				LD BC,kolory_p6+15		; adres tablicy kolorów kulek w tej części
				LD IY,alfa_empire		; adres efektu na napisie, ta sama procedura co pokazująca napis na początku	
				LD IX,32768+2048*1		; adres ścieżki dla kulek
				CALL dekompresuj_i_pokaz	; skok do procedury dla obrazka nr 2

				LD A,bank_p7
				LD DE,start_p7
				LD HL,pokaz1
				LD BC,kolory_p7+15
				LD IY,alfa_terminator
				LD IX,32768+2048*6
				CALL dekompresuj_i_pokaz	; skok do procedury dla obrazka nr 3

				; LD A,bank_p3			; do dłuższej wersji dema
				; LD DE,start_p3
				; LD HL,pokaz2
				; LD BC,kolory_p3+15
				; LD IY,alfa_terminator
				; LD IX,32768+2048*2
				; CALL dekompresuj_i_pokaz
				
				LD A,bank_p4
				LD DE,start_p4
				LD HL,pokaz3
				LD BC,kolory_p4+15
				LD IY,alfa_empire
				LD IX,32768+2048*3
				CALL dekompresuj_i_pokaz	; skok do procedury dla obrazka nr 4
				
				LD A,bank_p5
				LD DE,start_p5
				LD HL,pokaz1
				LD BC,kolory_p5+15
				LD IY,alfa_empty
				LD IX,32768+2048*4
				CALL dekompresuj_i_pokaz	; skok do procedury dla obrazka nr 5
				
				; LD A,bank_p6
				; LD DE,start_p6
				; LD HL,pokaz3
				; LD BC,kolory_p6+15
				; LD IY,alfa_empire
				; LD IX,32768+2048*5
				; CALL dekompresuj_i_pokaz

				; LD A,bank_p7
				; LD DE,start_p7
				; LD HL,pokaz2
				; LD BC,kolory_p7+15
				; LD IY,alfa_terminator
				; LD IX,32768+2048*6
				; CALL dekompresuj_i_pokaz

				LD A,bank_p8
				LD DE,start_p8
				LD HL,pokaz3
				; LD BC,kolory_p8+15
				LD BC,kolory_p3+15
				LD IY,alfa_empire
				LD IX,32768+2048*1
				CALL dekompresuj_i_pokaz	; skok do procedury dla obrazka nr 6

				LD A,bank_p9
				LD DE,start_p9
				LD HL,pokaz1
				LD BC,kolory_p5+15
				LD IY,alfa_terminator
				LD IX,32768+2048*7
				CALL dekompresuj_i_pokaz	; skok do procedury dla obrazka nr 7

				; część z creditsami i greetingsami jest pokazywana inaczej
				LD HL,adr_starwars	; skopiowanie odpowiedniej muzyki do miejsca odtwarzania
				CALL kopiuj_muze
				CALL wyczysc_ekrany	; procedura czyszczenia wszystkich używanych przez kulki ekranów
				LD HL,kolory_p9+15
				CALL ustaw_kolory	; ustawienie odpowiednich kolorów
				CALL wlacz_muzyke	; włączenie muzyki
				CALL otworz_okno	; procedura rozsuwająca poziomą linię, czyli otwierająca okno na środku
				LD B,100
				CALL czekaj			; czekamy 2 sekundy
				CALL pokaz5			; pokazujemy obrazek metodą 5, czyli pokazujemy creditsy
				LD B,0				; po ich pokazaniu czekamy w sumie ponad 600 ramek (dobrane eksperymentalnie)
				CALL czekaj			  
				CALL czekaj
				LD B,100
				CALL czekaj
				LD A,bank_p13		; następnie dekompresujemy greetingsy
				OUT (hmpr),A		; ustawiamy bank, gdzie jest skompresowany obrazek z nimi, do górnej połówki pamięci
				LD A,128			; parametry dla procedury dekompresji, czyli górny bajt adresu końca (=32768)
				LD C,255			; klucz do dekompresji
				LD HL,obszar_roboczy	; adres do którego dekompresujemy
				LD DE,start_p13		; adres skompresowanego obrazka z greetingsami
				CALL dekompresja	; wywołanie procedury dekompresji
									; po jej wykonaniu pod adresem 16384 jest zdekompresowany obrazek o długości 16384
				XOR a				; do górnej połówki pamięci ustawiamy bank 0, czyli ekran z napisami
				OUT (hmpr),A
				LD HL,obszar_roboczy	; i przenosimy tam ten obrazek
				LD DE,start_szumy	; w tym momencie tej części ekranu nie widać
				LD BC,16384
				LDIR
				CALL zamknij_okno	; zaykamy okno poziomymi kreskami 
				LD B,0				; i czekamy ponad 900 ramek, aż skończy się muzyka
				CALL czekaj
				CALL czekaj
				CALL czekaj
				LD B,150
				CALL czekaj
				CALL wylacz_muzyke	; wyłączamy muzykę
				JP glowna_petla		; i zaczynamy wszystko od nowa, od obrazka z T-800.
				
; -------------------------- czekaj -----------------------------------
; procedura czekająca wskazaną w B ilość ramek (a dokładniej B-1 ramek)
czekaj:
				DJNZ czek1		; dla wartości 1 nie czeka wcale
				RET	
	czek1:		HALT			; oczekiwanie na przewanie
				LD A,(int_type)	; sprawdzenie typu przerwania
				BIT 3,A
				JR NZ,czek1		; jeżeli to nie jest przerwanie ramki to znów czekamy
				DJNZ czek1		; jeżeli to jest przerwanie ramki, to zmniejszamy licznik o 1 i znów czekamy
				RET				
; -------------------------- narysuj kreske -----------------------------------
; procedura rysująca poziomą kreskę na ekranie
narysuj_kreske:
				LD IX,32768+128*linia_start+256+64	; adresy w IX idą od środka ekranu w prawo
				LD IY,32768+128*linia_start+256+63	; adresy w IY idą od środka ekranu w lewo
				LD A,255			; dwa piksele o kolorze 15, czyl białe
				LD B,32				; 32 przebiegi pętli
	jump3:		
				CALL punkt_kreski	; w jednej ramce dorysowujemy po 2 razy
				CALL punkt_kreski
				HALT
				DJNZ jump3
				RET

punkt_kreski:	LD (IX+0),A			; na obu końcach kreski dorysowujemy po kwadraciku 2x2 punkty
				LD (IX-128),A
				LD (IY+0),A
				LD (IY-128),A
				INC IX				; następny adres z obu stron kreski
				DEC IY
				RET
				
				
; -------------------------- wyczysc_ekrany -----------------------------------
; procedura czyszcząca wszystkie ekrany z centralnej części ekranu, czyl z obrazkiem i kulkami
wyczysc_ekrany:
				LD A,1			; najpierw do obszaru roboczego pod adresem 16384 przenosimy zapamiętany szum
				OUT (hmpr),A	; z banku nr 1
				LD HL,49152		
				LD DE,obszar_roboczy
				LD BC,16384
				LDIR

				LD A,16			; potem kopiujemy go na każdy z 8 ekranów, po 2 kolejne ekrany mają tą samą kopię
				CALL kopiuj12
				CALL kopiuj12
				CALL kopiuj34
				CALL kopiuj34
				CALL kopiuj56
				CALL kopiuj56
				CALL kopiuj78
				CALL kopiuj78
				RET
				
kopiuj12:						; na pierwsze 2 ekrany kopiujemy normalnie
				OUT (hmpr),A
				LD HL,16384
				LD DE,start_szumy
				LD BC,16384
				LDIR
				ADD A,2
				RET
kopiuj34:						; na następne 2 górna połówka szumu idzie na dolną część ekranu i na odwrót	
				OUT (hmpr),A
				LD HL,16384+8192
				LD DE,start_szumy
				LD BC,8192
				LDIR
				LD HL,16384
				LD DE,start_szumy+8192
				LD BC,8192
				LDIR
				ADD A,2
				RET				
kopiuj56:						; na kolejne 2 ekrany, górne 3/4 szumów idzie na dolną część ekranu i na odwrót
				OUT (hmpr),A
				LD HL,16384+4096
				LD DE,start_szumy
				LD BC,8192+4096
				LDIR
				LD HL,16384
				LD DE,start_szumy+12288
				LD BC,4096
				LDIR
				ADD A,2
				RET						
kopiuj78:						; na ostatnich dwóch w odwrotnych proporcjach, 1/4 góry idzie na sam dół i na odwrót
				OUT (hmpr),A
				LD HL,16384+4096+8192
				LD DE,start_szumy
				LD BC,4096
				LDIR
				LD HL,16384
				LD DE,start_szumy+4096
				LD BC,4096+8192
				LDIR
				ADD A,2
				RET			
; -------------------------- otworz i zamknij okno -----------------------------------
; proceruda otwierająca okno przez rozsunięcie poziomej kreski
; kreska rysowana jest w przerwaniu linii, w tym miejscu zmieniane są tylko numery linii
; gdy kreska jest na środku, jest rysowana procedurą w line_int0
; na początek zmieniamy procedurę na line_int1
otworz_okno:
				LD HL,line_int1
				LD (skok_int+1),HL
				LD B,31				; pętla rozsuwająca kreski zadziała 31 razy
	jump_o:		HALT				; jest synchronizowana przerwaniami ramki
				LD A,(int_type)		; sprawdzenie, czy to bylo przerwanie ramki
				BIT 3,A
				JR NZ,jump_o		; jeżeli nie, to czekamy dalej
				LD A,(linia_gora+1)	; pobieramy nr linii górnej z procedury obsługi przewania linii
				SUB 2				; zmniejszamy o 2
				LD (linia_gora+1),A	; i wrzucamy z powrotem
				LD A,(linia_dol+1)	; pobieramy nr linii dolnej z procedury obsługi przewania linii
				ADD A,2				; zwiększamy o 2
				LD (linia_dol+1),A	; i wrzucamy z powrotem
				DJNZ jump_o
				RET
zamknij_okno:
; zamknięcie okna działa identycznie, tylko zmiany numerów linii idą w drugą stronę
				LD B,31
	jump_z:		HALT
				LD A,(int_type)
				BIT 3,A
				JR NZ,jump_z
				LD A,(linia_gora+1)
				ADD A,2
				LD (linia_gora+1),A
				LD A,(linia_dol+1)
				SUB 2
				LD (linia_dol+1),A
				DJNZ jump_z
				LD HL,line_int0			; na koniec ustawiamy procedurę line_int0 jako przerwanie linii
				LD (skok_int+1),HL		; aby rysować jedną, grubą kreskę na środku
				RET
				
; -------------------------- generuj maske -----------------------------------
; procedura wywoływana po skopiowaniu obrazka na wszystkie 8 ekranów
; mająca na celu konwersję obrazka w obszarze roboczym do współrzędnych Z każdego punktu w przestrzeni 3D
; obrazki są przygotowane w taki sposób, że mają kolor "przeźroczysty" o numerze 14 (wybrane arbitralnie)
; kolor przeźroczysty dostaje współrzędną Z=0, a każdy punkt obrazka współrzędną 8, czyli środek 
generuj_maske:
				LD HL,obszar_roboczy	; początek obrazka w obszarze roboczym
	genm3:		LD C,0				; najpierw zakładamy, że współrzędna Z=0
				LD A,(HL)			; pobieramy bajt z obrazka (2 punkty)
				AND 240				; kasujemy dolną połówkę bajtu, czyli zostawiamy 1 punkt
				CP 14*16			; i sprawdzamy, czy =14, czyli czy jest przeźroczysty
				JR Z,genm1			; jeżeli jest, to skok, czyli Z pozostaje =0
				LD C,8*16			; jeżeli nie jest przeźroczysty, to współrzędna Z=8
	genm1:		LD A,(HL)			; ponownie pobieramy ten bajt i dla drugiego punktu robimy to samo 
				AND 15				; czyli tym razem kasujemy starszą połówkę
				CP 14				; sprawdzamy, czy punkt jest przeźroczysty
				JR Z,genm2			; jak jest, to skaczemy, jego Z=0
				SET 3,C				; jak nie jest, to ustawamy jego Z na 8
	genm2:		LD (HL),C			; i wrzucamy współrzędną Z dla tych dwóch punktów z powrotem w miejsce tych punktów
				INC HL				; przechodzimy do następnego bajtu z obrazka
				LD A,H				; sprawdzamy, czy to nie koniec obrazka
				CP 128				; jeżeli H=128, czyli HL=32768, to koniec obrazka
				JR NZ,genm3
				; obliczone współrzędne Z dla wszystkich punktów wrzucamy do wszystkich ekranów
				; dla każdej pary banków z ekranem połowę (16384 bajty) zajmue wyświetlany obraz,
				; a drugą połowę współrzędne Z dla każdego punktu
				; współrzędne Z dla danego punktu są pod adresem punktu+16384

	maska_gora:	EQU linia_g*128		; obraz zaczyna się od poczatku banku, a od linii linia_g
									; maska_gora to przesunięcie adresu startowego od początku banku
				LD A,16				; dla wszystkich ekranów począwszy od banku 16
	genm4:		OUT (hmpr),A
				LD HL,16384			; kopiujemy z obszaru roboczego
				LD DE,maska_gora+49152	; pod adres za wyświetlanym ekranem
				LD BC,16384-maska_gora	; długość zmniejszamy, aby kończyło się na 65536
				LDIR
				LD HL,32768-maska_gora	; resztę przenosimy pod adres 32768, czyli przez wyświetlany obraz
				LD DE,32768
				LD BC,maska_gora
				LDIR
				ADD A,2				; następny ekran zaczyna się 2 banki dalej
				CP 32				; i tak do ekranu w banku 30 (przy 32 wychodzimy)
				JR NZ,genm4
				RET
; -------------------------- dekompresuj i pokaz -----------------------------------
; procedura wykonująca komplet akcji dla każdej części dema
; wszystkie części wykonuje ta sama procedura, ale z różnymi parametrami
; na początek parametry przekazane w rejestrach są umieszczane w odpowiednich miejscach w kodzie (kod jest modyfikowany)
dekompresuj_i_pokaz:
				LD (adr_bank+1),A		; nr banku ze skompresowanym obrazkiem
				LD (adr_pokaz+1),HL		; adres procedury pokazującej obrazek (są 4 różne)
				LD (adr_kolory+1),BC	; adres tablicy kolorów dla tej części
				LD (adr_alfa+1),IY		; adres procedury pokazującej napis (TERMINATOR albo vs THE EMPIRE)
				LD (kulki_start+1),IX	; adres ścieżki dla kulek
				PUSH DE					; adres skompresowanego obrazka będzie potrzebny później
				; żeby nie przekazywać jeszcze więcej parametrów, na podstawie adresu procedury pokazującej napis odczytujemy
				; czy dana część dotyczy filmu TERMINATOR, STAR WARS czy obu na raz i resztę rzeczy ustawiamy na tej podstawie
				LD A,IYl	; rozpoznajemy na podstawie przekazanego adresu procedury pokazującej napis
				CP alfa_empire-((alfa_empire/256)*256)	; sprawdzamy, czy jest to Star Wars
				JR NZ,jmpd1				; jeżeli nie, to skaczemy dalej
				LD A,2					; ustawiamy odpowiednie opóźnienia czasowe dla Star Wars
				LD (adr_pauza1+1),A				
				LD A,10
				LD (adr_pauza2+1),A				
				LD HL,adr_march			; i kopiujemy odpowiednią muzykę
				CALL kopiuj_muze
				JR jmpd3
	jmpd1:			
				CP alfa_terminator-((alfa_terminator/256)*256) ; sprawdzamy, czy jest to Terminator
				JR NZ,jmpd2				; jeżeli nie, to skaczemy dalej
				LD A,130				; ustawiamy odpowiednie opóźnienia czasowe dla Terminatora
				LD (adr_pauza1+1),A				
				LD A,255
				LD (adr_pauza2+1),A
				LD HL,adr_terminator	; i kopiujemy odpowiednią muzykę
				CALL kopiuj_muze
				JR jmpd3
	jmpd2:								; w przeciwnym przypadku jest to część 5, łącząca oba filmy
				LD A,1					; ustawiamy odpowiednie opóźnienia czasowe
				LD (adr_pauza1+1),A				
				LD A,20
				LD (adr_pauza2+1),A
				LD HL,adr_cantina
				CALL kopiuj_muze		; i kopiujemy odpowiednią muzykę
				; parametry są już ustawione, pora na ciąg dalszy
	jmpd3:
				CALL wyczysc_ekrany		; najpierw czyścimy wszystkie ekrany i wypełniamy je czystym szumem
	adr_bank:	LD A,0					; potem dekompresujemy obrazek do obszaru roboczego. 
				OUT (hmpr),A			; wartość 0 została zmodyfikowana na bank zawierający konkretnny obrazek (skompresowany)
				LD A,128				; na jakim adresie zakończyć dekompresję
				LD C,255				; klucz do dekompresji
	adr_docel:	LD HL,obszar_roboczy		; adres startowy obrazka po dekompresji 
				POP DE					; adres startowy obrazka skompresowanego
				CALL dekompresja		; i dekompresjemy
	adr_kolory:	LD HL,0					; adres tablicy kolorów, będzie tutaj odpowiednio zmodyfikowany
				CALL ustaw_kolory		; i ustawiamy kolory dla tej części
				CALL wlacz_muzyke		; włączamy muzykę
				CALL otworz_okno		; zaraz po włączeniu muzyki otwieramy czyste okno z szumem
				XOR A					; przełączamy się na bank z ekranem 0, gdzie są napisy na górze i dole ekranu i greetingsy
				OUT (hmpr),A
				LD HL,start_szumy		; czyszczenie greetingsów
				LD DE,start_szumy+1		; ten fragment nie musiałby się wykonywać przy każdej części, ale tak jest prościej
				LD (HL),L
				LD BC,16383
				LDIR
	adr_pauza1:	LD B,2					; pauza odpowiedniej długości, modyfikowana tutaj przez odpowiednie parametry 
				CALL czekaj
				LD B,200
				CALL czekaj
	adr_pokaz:	CALL pokaz1				; wywołujemy procedurę pokazującą obrazek, czyli kopiującą go na wszystkie ekrany
				CALL generuj_maske		; potem generujemy maskę, czyli współrzędne Z dla całego obrazka
	adr_alfa:	CALL alfa_terminator	; wywołujemy odpowiednią procedurę pokazującą napis z tytułem filmu
				LD B,50					; i znów pauza
				CALL czekaj
				CALL kulki				; wywołujemy procedurę rysującą kulki
				LD B,100
				CALL czekaj				; po jej zakończeniu znów pauza, ustawiana parametrem
	adr_pauza2:	LD B,10
				CALL czekaj
				CALL zamknij_okno		; zamknięcie okna z obrazkiem i kulkami
				CALL wylacz_muzyke		; wyłączenie muzyki
				RET
				
; -------------------------- ustaw kolory -----------------------------------
; procedura ustawiająca tylko zmienne kolory kulek, czyli 8-15. kolory 0-7, czyli szarości, są niezmienne dla całego dema
ustaw_kolory:
				LD BC,16*256+clut
				OUTD
				OUTD
				OUTD
				OUTD
				OUTD
				OUTD
				OUTD
				OUTD
				RET				

; -------------------------- muzyka -----------------------------------
				
kopiuj_muze:					; procedura kopiująca odpowiednią muzykę do obszaru, gdzie jest odgrywana
				LD A,12
				OUT (hmpr),A
				LD DE,start_muza
				LD BC,3500
				LDIR
				RET
				
wlacz_muzyke:					; procedura włączająca muzykę
				CALL start_muza
				LD A,205		; która ustawia też odpowiedni skok w procedurze obsługi przerwania ramki
				LD (muzyka),A
				LD HL,start_muza+6
				LD (muzyka+1),HL
				RET

wylacz_muzyke:					; procedura wyłączająca muzykę
				CALL start_muza
				XOR a			; która usuwa też odpowiedni skok w procedurze obsługi przerwania ramki, aby nic nie grało
				LD (muzyka),A	; zamiast skoku ustawia tam 3 rozkazy NOP
				LD (muzyka+1),A
				LD (muzyka+2),A
				RET
				
				INCLUDE "source/pokazy.asm"
				INCLUDE "source/kulki.asm"
				INCLUDE "source/DEkompresor.asm"
				INCLUDE "source/alfa.asm"
				
; dalej znajdują się obrazki z kulkami o różniej wielkości (od najmniejszej)
; każdy zaczyna się od równego adresu, młodszy bajt =0
; są oddzielne obrazki dla kulek znajdujących się na współrzędnej parzystej i nieparzystej
; dla każdej z nich po 8 obrazków (przy rysowaniu odległość Z jest dzielona przez 2)
				ORG	($/256 +1)*256
kulka_src:		
				INCBIN "data/kul5l"		; obrazki dla kulek parzystych
				ORG	($/256 +1)*256
				INCBIN "data/kul5l"
				ORG	($/256 +1)*256
				INCBIN "data/kul7l"
				ORG	($/256 +1)*256
				INCBIN "data/kul9l"
				ORG	($/256 +1)*256
				INCBIN "data/kul11l"
				ORG	($/256 +1)*256
				INCBIN "data/kul13l"
				ORG	($/256 +1)*256
				INCBIN "data/kul15l"
				ORG	($/256 +1)*256
				INCBIN "data/kul15l"
				ORG	($/256 +1)*256
				INCBIN "data/kul5p"		; obrazki dla kulek nieparzystych
				ORG	($/256 +1)*256
				INCBIN "data/kul5p"
				ORG	($/256 +1)*256
				INCBIN "data/kul7p"
				ORG	($/256 +1)*256
				INCBIN "data/kul9p"
				ORG	($/256 +1)*256
				INCBIN "data/kul11p"
				ORG	($/256 +1)*256
				INCBIN "data/kul13p"
				ORG	($/256 +1)*256
				INCBIN "data/kul15p"
				ORG	($/256 +1)*256
				INCBIN "data/kul15p"
