; Procedurki pokazywania obrazków


; obrazki kopiowane są z obszaru roboczego na wszystkie 8 ekranów na różne sposoby
; różniące się między sobą jedynie kolejnością kopiowania linii
; kopiowane są tylko punkty różne od koloru 14 (czyli przeźroczystego)

; pierwsze 2 pokazują standardowy obrazek (miały być 4 rodzaje, ale nie zdążyłem i zostały 2), czyli oprócz creditsów
pokaz1:			; kopiujemy kolejne linie do kolejnych ekranów, czyli linię 1 do ekranu 16, linię 2 do ekranu 18 itd.
				; do czasu, aż wszystko zostanie skopiowane do wszystkich ekranów
				LD A,16				; ustawienie wartości początkowej dla całej procedury (bo będzie przez nią modyfikowana)
				LD (str_start1+1),A
				LD B,8				; na dany ekran kopiowana będzie co 8-ma linia, więc pętla będzie wykonywana 8 razy
	edc3:		PUSH BC
	str_start1:	LD A,16				; zaczynamy od banku 16
				OUT (hmpr),A
				LD HL,start_szum	; początek obszaru roboczego z obrazkiem
	edc2:		
				CALL przenies_linie	; procedura przeniesienia linii jest taka sama dla obu "pokazów"
				DEC E				; po całej linii może się też zmienić (ale nie musi, zmienia się co drugą) starsza część adresu, czyli rejestry D i H
				INC DE
				DEC L
				INC HL
				
				IN A,(hmpr)			; nie zapamiętujemy numeru banku, więc go pobieramy z portu
				ADD A,2				; i przechodzimy do następnego
				AND 31				; kasujemy niepotrzebne bity
				OR 16				; ale jak wyjedziemy poza bank 32, to zaczynamy od 16-go
				OUT (hmpr),A		; przechodzimy do kolejnego banku
				LD A,H				; sprawdzamy, czy to nie koniec obrazka w obszarze roboczym
				CP 128				; jak w H jest 128, to koniec 
				JP NZ,edc2			; jeżeli nie koniec, to powtarzamy dla kolejnej linii
				LD A,(str_start1+1)	; jeżeli koniec, to modyfikujemy bank startowy na kolejny
				ADD A,2
				LD (str_start1+1),A
				POP BC
				DJNZ edc3			; i całość wykonujemy 8 razy
				RET

pokaz3:			; tym razem kopiujemy do kolejnych ekranów nie kolejne linie, a co 26-tą linię
				; do czasu, aż wszystko zostanie skopiowane do wszystkich ekranów
				LD A,16				; ustawienie wartości początkowej dla całej procedury (bo będzie przez nią modyfikowana)
				LD (str_start3+1),A
				LD B,8				; pętla będzie wykonywana 8 razy
	edcb3:		PUSH BC
	str_start3:	LD A,16				; zaczynamy od banku 16
				OUT (hmpr),A
				LD HL,start_szum	; początek obszaru roboczego z obrazkiem
				LD B,128			; zamiast sprawdzania na końcu, czy to koniec obrazka (tym razem tak się nie da), od razu ustalamy, że jest w nim 128 linii
	edcb2:		
				PUSH BC
				CALL przenies_linie	; procedura przeniesienia linii jest taka sama dla obu "pokazów"
				DEC E				; po całej linii może się też zmienić (ale nie musi, zmienia się co drugą) starsza część adresu, czyli rejestry D i H
				INC DE
				DEC L
				INC HL
				LD A,H				; rysujemy nie co 8, a co 26 linię każdego obrazka (13 * 2 linie)
				ADD A,13
				RES 7,A				; po wyjściu poza obrazek wracamy znów od góry, poruszamy się po obrazku "w kółko" co 26 linii
				SET 6,A				; dlatego kasujemy najstarszy bit i ustawiamy bit 6, adresy na obrazku z obszaru roboczego muszą się mieścić w takim zakresie
				LD H,A
				
				IN A,(hmpr)			; przechodzimy do kolejnego ekranu
				ADD A,2
				AND 31				; kasujemy niepotrzebne bity
				OR 16				; ale jak wyjedziemy poza bank 32, to zaczynamy od 16-go
				OUT (hmpr),A
				POP BC
				DJNZ edcb2			; to robimy 128 razy
				LD A,(str_start3+1)	; dla kolejnego przebiegu modyfikujemy ekran startowy
				ADD A,2
				LD (str_start3+1),A
				POP BC
				DJNZ edcb3			; i powtarzamy 8 razy
				RET				
				
przenies_linie:
				LD A,H				; obliczenie adresu docelowego na podstawie źródłowego i odpowiedniego przesunięcia
				ADD A,64+linia_g/2
				LD D,A				; i załadowanie go do DE
				LD E,L				
				LD B,128			; dla całej linii obrazu, czyli 128 bajtów
	edc1:
				LD A,(DE)			; na początek zakładamy, że kolor będzie przeźroczysty i pobieramy punkt z docelowego ekranu (szum)
				LD C,A				; i zapamiętujemy go w rejestrze C
				LD A,(HL)			; pobieramy bajt z obrazka
				AND 240				; kasujemy młodszą połowę, zostawiając 1 punkt
				CP 16*14			; sprawdzamy, czy jest przeźroczysty
				JR Z,rfv1			; jeżeli jest, to skok dalej, do młodszej połowy
				EX AF,AF'			
				LD A,C				; jeżeli nie jest przeźroczysty
				AND 15				; to kasujemy starszą połowę z szumu 
				LD C,A
				EX AF,AF'
				OR C				; i wrzucamy tam wartość z obrazka
				LD C,A				; i zapamiętujemy wynik w C, na czas operacji na młodszej połówce
	rfv1:		
				LD A,(HL)			; znów pobieramy bajt z obrazka
				AND 15				; kasujemy starszą połowę, zostawiając 1 punkt
				CP 14				; sprawdzamy, czy jest przeźroczysty
				JR Z,rfv2			; jeżeli jest, to skok dalej
				EX AF,AF'
				LD A,C				; jeżeli nie jest przeźroczysty
				AND 240				; to kasujemy młodszą połowę z szumu
				LD C,A
				EX AF,AF'
				OR C				; i wrzucamy tam wartość z obrazka
				LD C,A				; i zapamiętujemy wynik w C
	rfv2:		
				LD A,C				; gotową wartość z C
				LD (DE),A			; wrzucamy pod adres docelowy
				INC E				; przejście do następnego bajtu 
				INC L				; w linii na pewno zmienia się tylko młodsza część adresu (rejestry E i L)
				DJNZ edc1			; i tak 128 razy
				RET
				
; sposób pokazywania greetingsów jest zupełnie inny
; 3 razy wywołujemy tą samą procedurę pokazania jednego napisu
; każdy napis jest na oddzielnym obrazku
; na jednym obrazku są dwie wersje, z przesuniętymi lekko literami
; są umieszczone 8192 bajty od siebie, czyli 64 linie od siebie
pokaz5: 
				LD A,142				; starsza połowa adresu linii, od którego ma się pokazac napis
				LD (adr_start5+4),A		
				LD A,bank_p10			; bank ze skompresowanym obrazkiem
				LD DE,start_p10			; adres skompresowanego obrazka
				CALL pokaz5a			; pokaż ten napis
				
				LD A,182				; starsza połowa adresu linii, od którego ma się pokazac napis
				LD (adr_start5+4),A		
				LD A,bank_p11			; bank ze skompresowanym obrazkiem
				LD DE,start_p11			; adres skompresowanego obrazka
				CALL pokaz5a			; pokaż ten napis

				LD A,162				; starsza połowa adresu linii, od którego ma się pokazac napis
				LD (adr_start5+4),A		
				LD A,bank_p12			; bank ze skompresowanym obrazkiem
				LD DE,start_p12			; adres skompresowanego obrazka
				CALL pokaz5a			; pokaż ten napis
				RET


pokaz5a:
				OUT (hmpr),A			; przechodzimy do banku ze skompresowanym obrazkiem i dekompresujemy go
				LD A,128				; najpierw parametry: starszy bajt adresu końca dekompresji (32768)
				LD C,255				; klucz dekompresji
				LD HL,start_szum		; adres pod jaki dekompresować, czyli 16384
				LD (adr_start5+1),HL
				CALL dekompresja		; i dekompresujemy do obszaru roboczego
	edcd4:			
				LD A,16					; zaczynamy od pierwszego ekranu, czyli 16
										; na wszyskie 8 ekranów kopiujemu to samo, pionową linię z napisu
	edcd2:		
				PUSH AF					; przełączamy się na ten ekran
				OUT (hmpr),A
				CALL pokaz5b			; skok do procedury przeniesienia jednej pionowej linii
				POP AF
				ADD A,2					; kolejny 
				CP 24					; tą część obrazka przenosimy na pierwsze 4 ekrany
				JR NZ,edcd2

				EX AF,AF'				
				LD A,(adr_start5+2)		; zmieniamy adres startowy na dolną połowę obrazka, czyli 64 linie dalej
				ADD A,32				; na napis z lekko przesuniętymi literami
				LD (adr_start5+2),A
				EX AF,AF'
	edcd3:
				PUSH AF					; i kopiujemy to na 4 kolejne ekrany
				OUT (hmpr),A
				CALL pokaz5b
				POP AF
				ADD A,2
				CP 32
				JR NZ,edcd3

				LD A,(adr_start5+2)		; przywracamy adres startowy obrazka na górną połówkę
				SUB 32
				LD (adr_start5+2),A
				
				LD A,(adr_start5+1)		; i przechodzimy do kolejnej kolumny
				INC A
				LD (adr_start5+1),A
				CP 128					; i tak do końca linii
				JR NZ,edcd4

				LD B,110				; po pokazaniu napisu czekamy 110 ramek, czyli nieco ponad 2 sekundy
				CALL czekaj
				RET

	pokaz5b:	; przenosi jedną kolumnę napisu z obszaru źródłowego na ekran
	adr_start5:	LD HL,start_szum		; modyfikowany adres startowy do przeniesienia kolumny
				LD D,150				; modyfikowany wiersz docelowy, od którego pokazuje się napis
				LD E,L					; kolumna ta sama co w źródle

				LD B,35			; kolumna ma wysokość 35 punktów
	edcd1:		PUSH BC
				LD A,(DE)		; napisy, podobnie jak obrazki, mają przeźroczystość pod numerem koloru 14
				LD C,A			; najpierw zapamiętujemy w C wartość z tła (szum)
				LD A,(HL)		; pobieramy wartość z napisu
				AND 240			; kasujemy młodszą połówkę, zostawiamy 1 punkt
				CP 16*14		; sprawdzamy, czy nie jest przeźroczysty
				JR Z,rfvd1		; jeżeli jest, to skaczemy dalej
				EX AF,AF'
				LD A,C			; jeżeli nie jest, to kasujemy z C szum
				AND 15
				LD C,A
				EX AF,AF'
				OR C			; i dodajemy w to miejsce wartość z napisu
				LD C,A			; zapamiętujemy wynik w C
	rfvd1:		
				LD A,(HL)		; to samo dla młodszej połówki, czyli drugiego piksela z bajtu
				AND 15			; kasujemy starszą połówkę, zostawiamy 1 punkt
				CP 14			; sprawdzamy, czy nie jest przeźroczysty
				JR Z,rfvd2		; jeżeli jest, to skaczemy dalej
				EX AF,AF'
				LD A,C			; jeżeli nie jest, to kasujemy z C szum
				AND 240
				LD C,A
				EX AF,AF'
				OR C			; i dodajemy w to miejsce wartość z napisu
				LD C,A			; zapamiętujemy wynik w C
	rfvd2:		
				LD A,C			; wrzucamy wynik z C
				LD (DE),A		; na ekran
				LD BC,128		; przechodzimy do następnego wiersza
				ADD HL,BC		; zwiększając adresy źródłowy i docelowy o 128
				EX DE,HL
				ADD HL,BC
				EX DE,HL
				POP BC
				DJNZ edcd1		; i tak 35 razy
				RET
