"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.getDeepLinkHandler = getDeepLinkHandler;
var _config = require("@expo/config");
var _devServer = require("@expo/dev-server");
var _getDevClientProperties = _interopRequireDefault(require("../../../utils/analytics/getDevClientProperties"));
var _rudderstackClient = require("../../../utils/analytics/rudderstackClient");
var _port = require("../../../utils/port");
var _bundlerDevServer = require("../BundlerDevServer");
var _createFileMiddleware = require("../middleware/CreateFileMiddleware");
var _historyFallbackMiddleware = require("../middleware/HistoryFallbackMiddleware");
var _interstitialPageMiddleware = require("../middleware/InterstitialPageMiddleware");
var _runtimeRedirectMiddleware = require("../middleware/RuntimeRedirectMiddleware");
var _serveStaticMiddleware = require("../middleware/ServeStaticMiddleware");
var _instantiateMetro = require("./instantiateMetro");
function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
/** Default port to use for apps running in Expo Go. */ const EXPO_GO_METRO_PORT = 19000;
/** Default port to use for apps that run in standard React Native projects or Expo Dev Clients. */ const DEV_CLIENT_METRO_PORT = 8081;
class MetroBundlerDevServer extends _bundlerDevServer.BundlerDevServer {
    get name() {
        return "metro";
    }
    async resolvePortAsync(options = {}) {
        var // If the manually defined port is busy then an error should be thrown...
        _port1;
        const port = (_port1 = options.port) != null ? _port1 : // Otherwise use the default port based on the runtime target.
        (options.devClient ? Number(process.env.RCT_METRO_PORT) || DEV_CLIENT_METRO_PORT : await (0, _port).getFreePortAsync(EXPO_GO_METRO_PORT));
        return port;
    }
    async startImplementationAsync(options) {
        options.port = await this.resolvePortAsync(options);
        this.urlCreator = this.getUrlCreator(options);
        const parsedOptions = {
            port: options.port,
            maxWorkers: options.maxWorkers,
            resetCache: options.resetDevServer,
            // Use the unversioned metro config.
            // TODO: Deprecate this property when expo-cli goes away.
            unversioned: false
        };
        const { server , middleware , messageSocket  } = await (0, _instantiateMetro).instantiateMetroAsync(this.projectRoot, parsedOptions);
        const manifestMiddleware = await this.getManifestMiddlewareAsync(options);
        // We need the manifest handler to be the first middleware to run so our
        // routes take precedence over static files. For example, the manifest is
        // served from '/' and if the user has an index.html file in their project
        // then the manifest handler will never run, the static middleware will run
        // and serve index.html instead of the manifest.
        // https://github.com/expo/expo/issues/13114
        (0, _devServer).prependMiddleware(middleware, manifestMiddleware);
        var _scheme;
        middleware.use(new _interstitialPageMiddleware.InterstitialPageMiddleware(this.projectRoot, {
            // TODO: Prevent this from becoming stale.
            scheme: (_scheme = options.location.scheme) != null ? _scheme : null
        }).getHandler());
        const deepLinkMiddleware = new _runtimeRedirectMiddleware.RuntimeRedirectMiddleware(this.projectRoot, {
            onDeepLink: getDeepLinkHandler(this.projectRoot),
            getLocation: ({ runtime  })=>{
                if (runtime === "custom") {
                    var ref;
                    return (ref = this.urlCreator) == null ? void 0 : ref.constructDevClientUrl();
                } else {
                    var ref1;
                    return (ref1 = this.urlCreator) == null ? void 0 : ref1.constructUrl({
                        scheme: "exp"
                    });
                }
            }
        });
        middleware.use(deepLinkMiddleware.getHandler());
        middleware.use(new _createFileMiddleware.CreateFileMiddleware(this.projectRoot).getHandler());
        // Append support for redirecting unhandled requests to the index.html page on web.
        if (this.isTargetingWeb()) {
            // This MUST be after the manifest middleware so it doesn't have a chance to serve the template `public/index.html`.
            middleware.use(new _serveStaticMiddleware.ServeStaticMiddleware(this.projectRoot).getHandler());
            // This MUST run last since it's the fallback.
            middleware.use(new _historyFallbackMiddleware.HistoryFallbackMiddleware(manifestMiddleware.internal).getHandler());
        }
        // Extend the close method to ensure that we clean up the local info.
        const originalClose = server.close.bind(server);
        server.close = (callback)=>{
            return originalClose((err)=>{
                this.instance = null;
                callback == null ? void 0 : callback(err);
            });
        };
        return {
            server,
            location: {
                // The port is the main thing we want to send back.
                port: options.port,
                // localhost isn't always correct.
                host: "localhost",
                // http is the only supported protocol on native.
                url: `http://localhost:${options.port}`,
                protocol: "http"
            },
            middleware,
            messageSocket
        };
    }
    getConfigModuleIds() {
        return [
            "./metro.config.js",
            "./metro.config.json",
            "./rn-cli.config.js"
        ];
    }
}
exports.MetroBundlerDevServer = MetroBundlerDevServer;
function getDeepLinkHandler(projectRoot) {
    return async ({ runtime  })=>{
        if (runtime === "expo") return;
        const { exp  } = (0, _config).getConfig(projectRoot);
        await (0, _rudderstackClient).logEventAsync("dev client start command", {
            status: "started",
            ...(0, _getDevClientProperties).default(projectRoot, exp)
        });
    };
}

//# sourceMappingURL=MetroBundlerDevServer.js.map