"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const path_1 = tslib_1.__importDefault(require("path"));
const fs_1 = require("fs");
const mkdirp_1 = require("mkdirp");
const lodash_1 = require("lodash");
const applicationConfigPath = require("application-config-path");
const eol_1 = tslib_1.__importDefault(require("eol"));
const utils_1 = require("./utils");
exports.VALID_IP = /(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]\d|\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]\d|\d)){3}/;
exports.VALID_DOMAIN = /^(?:[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?\.?)+[a-z0-9][a-z0-9-]{0,61}[a-z0-9]$/i;
// Platform shortcuts
exports.isMac = process.platform === 'darwin';
exports.isLinux = process.platform === 'linux';
exports.isWindows = process.platform === 'win32';
// Common paths
exports.configDir = applicationConfigPath('devcert');
exports.configPath = path_1.default.join.bind(path_1.default, exports.configDir);
exports.domainsDir = exports.configPath('domains');
exports.pathForDomain = path_1.default.join.bind(path_1.default, exports.domainsDir);
exports.caVersionFile = exports.configPath('devcert-ca-version');
exports.opensslSerialFilePath = exports.configPath('certificate-authority', 'serial');
exports.opensslDatabaseFilePath = exports.configPath('certificate-authority', 'index.txt');
exports.caSelfSignConfig = path_1.default.join(__dirname, '../openssl-configurations/certificate-authority-self-signing.conf');
function withDomainSigningRequestConfig(domain, cb) {
    let tmpFile = utils_1.mktmp();
    let source = fs_1.readFileSync(path_1.default.join(__dirname, '../openssl-configurations/domain-certificate-signing-requests.conf'), 'utf-8');
    let template = lodash_1.template(source);
    let result = template({ domain });
    fs_1.writeFileSync(tmpFile, eol_1.default.auto(result));
    cb(tmpFile);
    fs_1.unlinkSync(tmpFile);
}
exports.withDomainSigningRequestConfig = withDomainSigningRequestConfig;
function withDomainCertificateConfig(domain, cb) {
    let tmpFile = utils_1.mktmp();
    let source = fs_1.readFileSync(path_1.default.join(__dirname, '../openssl-configurations/domain-certificates.conf'), 'utf-8');
    let template = lodash_1.template(source);
    let result = template({
        domain,
        serialFile: exports.opensslSerialFilePath,
        databaseFile: exports.opensslDatabaseFilePath,
        domainDir: exports.pathForDomain(domain)
    });
    fs_1.writeFileSync(tmpFile, eol_1.default.auto(result));
    cb(tmpFile);
    fs_1.unlinkSync(tmpFile);
}
exports.withDomainCertificateConfig = withDomainCertificateConfig;
// confTemplate = confTemplate.replace(/DATABASE_PATH/, configPath('index.txt').replace(/\\/g, '\\\\'));
// confTemplate = confTemplate.replace(/SERIAL_PATH/, configPath('serial').replace(/\\/g, '\\\\'));
// confTemplate = eol.auto(confTemplate);
exports.rootCADir = exports.configPath('certificate-authority');
exports.rootCAKeyPath = exports.configPath('certificate-authority', 'private-key.key');
exports.rootCACertPath = exports.configPath('certificate-authority', 'certificate.cert');
// Exposed for uninstallation purposes.
function getLegacyConfigDir() {
    if (exports.isWindows && process.env.LOCALAPPDATA) {
        return path_1.default.join(process.env.LOCALAPPDATA, 'devcert', 'config');
    }
    else {
        let uid = process.getuid && process.getuid();
        let userHome = (exports.isLinux && uid === 0) ? path_1.default.resolve('/usr/local/share') : require('os').homedir();
        return path_1.default.join(userHome, '.config', 'devcert');
    }
}
exports.getLegacyConfigDir = getLegacyConfigDir;
function ensureConfigDirs() {
    mkdirp_1.sync(exports.configDir);
    mkdirp_1.sync(exports.domainsDir);
    mkdirp_1.sync(exports.rootCADir);
}
exports.ensureConfigDirs = ensureConfigDirs;
ensureConfigDirs();
//# sourceMappingURL=data:application/json;base64,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