/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 *
 * @format
 * @oncall react_native
 */

"use strict";

const { isBytecodeModule, wrapModule } = require("./bytecode");
function processBytecodeModules(
  modules,
  {
    filter = () => true,
    createModuleId,
    dev,
    includeAsyncPaths,
    projectRoot,
    serverRoot,
  }
) {
  return [...modules]
    .filter(isBytecodeModule)
    .filter(filter)
    .map((module) => [
      module,
      wrapModule(module, {
        createModuleId,
        dev,
        includeAsyncPaths,
        projectRoot,
        serverRoot,
      }),
    ]);
}
module.exports = processBytecodeModules;
