#version 330 core

in vec2 texCoord;
in vec4 vertexFragColor;
out vec4 fragColor;
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform float time = 1.0;
uniform vec4 color = vec4(1,1,1,1);

uniform float distortionResolutionX = 19.2;
uniform float distortionResolutionY = 10.8;
uniform float distortionX = 0.1;
uniform float distortionY = 0.1;
uniform float noiseAlpha = 0.2;
uniform float shakeSizeY = 0.000;
uniform float glitchSize = 0.00;

uniform float contrast = 0.0;
uniform float brightness = 0.0;
uniform float extraBrightness = 0.0;
uniform float mixShift = 0.0;

uniform float gbDisplacement= 0.05;
uniform float displacementOffset = 0.05;


uniform float farThresHold = 0.2;
uniform float maxBias = 3.0;

uniform float fftHistory = 16.0;

float calculateDepth()
{
    float z = texture(texture1, texCoord).r;
    float near = 1.0;
    float far = 10.0;
    float clipNormZ = (2.0 * near) / (far + near - z * (far - near));
    return clipNormZ;
}

float calculateDofLodBias()
{
    float bias = 0.0;
    float normDepthZ = calculateDepth();
    if (normDepthZ > farThresHold) {
        bias = maxBias*smoothstep(0.0,1.0,((normDepthZ-farThresHold)/(1.0-farThresHold)));
    }

    return bias;
}

float rand(vec2 coord)
{
    return fract(sin(dot(coord.st,vec2(12.9898,78.233)+time)) * 43758.5453);
}

float getDistortionFactor(vec2 coord)
{
    //pixelize distortion
    vec2 d = vec2(1.0,1.0)/vec2(distortionResolutionX, distortionResolutionY);
    coord.s = floor(coord.s/d.s)*d.s+time;
    coord.t = floor(coord.t/d.t)*d.t+time;
    
    return rand(coord);
}

float getRandomNoise(vec2 coord)
{
    return rand(coord);
}

vec4 distortion(vec2 coord)
{
    float mval = 0.0;
    float mvalDecay = 0.0;
    float mavg = 0.0;
    float mcur = texture2D(texture1, vec2(texCoord.x, 1.0)).r;

    for (int i = 0; i < fftHistory; i++) {
        float percent = i/fftHistory;
        vec2 coordHistory = vec2(texCoord.x, percent);

        mavg += texture2D(texture1, coordHistory).r;

        mval = max(texture2D(texture1, coordHistory).r, mval);
        mvalDecay = max(texture2D(texture1, coordHistory).r*smoothstep(0.0,1.0,percent), mvalDecay);
    }
    mavg /= fftHistory;

    float bias = 0.0f;//calculateDofLodBias();


    vec2 pseudoRandomCoord = coord + vec2(1.,2.*tan(time*10))*time;
    float distortion = getDistortionFactor(pseudoRandomCoord);
    float random = getRandomNoise(pseudoRandomCoord);
    
    float noiseDistortionX = texture(texture0,vec2(coord.t+time,0),bias).x*distortion*distortionX;

    if (glitchSize > 0.0) {
    coord.x = fract(coord.x + noiseDistortionX + tan(coord.y + time)*glitchSize*sin(time + 4*sin(time*4))*(1.0 + cos(time*80.)));
    }
    
    float shakeY = shakeSizeY*sin(time*0.1*cos(time*2))*(sin(time)*sin(time*20) + (1.0 + sin(time*20)*cos(time)));
    
    float noiseDistortionY = texture(texture0,vec2(0,coord.s+time),bias).x * distortion * distortionY;
    
    coord.y = fract(coord.y + shakeY + noiseDistortionY);
    
    vec4 result = texture(texture0,coord,bias)*(1.0 - noiseAlpha) + random*noiseAlpha;
    
    return result * color;
}

//
// Description : Array and textureless GLSL 2D simplex noise function.
//      Author : Ian McEwan, Ashima Arts.
//  Maintainer : stegu
//     Lastmod : 20110822 (ijm)
//     License : Copyright (C) 2011 Ashima Arts. All rights reserved.
//               Distributed under the MIT License. See LICENSE file.
//               https://github.com/ashima/webgl-noise
//               https://github.com/stegu/webgl-noise
// 

vec3 mod289(vec3 x) {
  return x - floor(x * (1.0 / 289.0)) * 289.0;
}

vec2 mod289(vec2 x) {
  return x - floor(x * (1.0 / 289.0)) * 289.0;
}

vec3 permute(vec3 x) {
  return mod289(((x*34.0)+1.0)*x);
}

float snoise(vec2 v)
  {
  const vec4 C = vec4(0.211324865405187,  // (3.0-sqrt(3.0))/6.0
                      0.366025403784439,  // 0.5*(sqrt(3.0)-1.0)
                     -0.577350269189626,  // -1.0 + 2.0 * C.x
                      0.024390243902439); // 1.0 / 41.0
// First corner
  vec2 i  = floor(v + dot(v, C.yy) );
  vec2 x0 = v -   i + dot(i, C.xx);

// Other corners
  vec2 i1;
  //i1.x = step( x0.y, x0.x ); // x0.x > x0.y ? 1.0 : 0.0
  //i1.y = 1.0 - i1.x;
  i1 = (x0.x > x0.y) ? vec2(1.0, 0.0) : vec2(0.0, 1.0);
  // x0 = x0 - 0.0 + 0.0 * C.xx ;
  // x1 = x0 - i1 + 1.0 * C.xx ;
  // x2 = x0 - 1.0 + 2.0 * C.xx ;
  vec4 x12 = x0.xyxy + C.xxzz;
  x12.xy -= i1;

// Permutations
  i = mod289(i); // Avoid truncation effects in permutation
  vec3 p = permute( permute( i.y + vec3(0.0, i1.y, 1.0 ))
		+ i.x + vec3(0.0, i1.x, 1.0 ));

  vec3 m = max(0.5 - vec3(dot(x0,x0), dot(x12.xy,x12.xy), dot(x12.zw,x12.zw)), 0.0);
  m = m*m ;
  m = m*m ;

// Gradients: 41 points uniformly over a line, mapped onto a diamond.
// The ring size 17*17 = 289 is close to a multiple of 41 (41*7 = 287)

  vec3 x = 2.0 * fract(p * C.www) - 1.0;
  vec3 h = abs(x) - 0.5;
  vec3 ox = floor(x + 0.5);
  vec3 a0 = x - ox;

// Normalise gradients implicitly by scaling m
// Approximation of: m *= inversesqrt( a0*a0 + h*h );
  m *= 1.79284291400159 - 0.85373472095314 * ( a0*a0 + h*h );

// Compute final noise value at P
  vec3 g;
  g.x  = a0.x  * x0.x  + h.x  * x0.y;
  g.yz = a0.yz * x12.xz + h.yz * x12.yw;
  return 130.0 * dot(m, g);
}

void main()
{

    
    // Create large, incidental noise waves
    float noise = 0.;//max(0.0, snoise(vec2(time, uv.y * 0.3)) - 0.3) * (1.0 / 0.7);
    vec2 coord = texCoord;
    vec2 uv = coord;
    

      

    // Offset by smaller, constant noise waves
    noise = noise + (snoise(vec2(time*10.0, uv.y * 2.4)) - 0.5) * displacementOffset;
    
    // Apply the noise as x displacement for every line

    float xpos = coord.x - noise * noise * 0.25;
    coord = vec2(xpos, uv.y);

	//fragColor = texture(iChannel0, vec2(xpos, uv.y));
    


    vec4 c = distortion(coord);
    //vec4 grayColor = vec4(vec3((c.r+c.g+c.b)/3.0)*0.7, c.a);
    //fragColor = vec4(grayColor.rgb+(c.rgb*0.3), 1.0)*color;
    fragColor = c;
    // Mix in some random interference for lines
    fragColor.rgb = mix(fragColor.rgb, vec3(rand(vec2(uv.y * time))), noise * 0.3).rgb;
    
    // Apply a line pattern every 4 pixels
    if (floor(mod(coord.y * 0.25, 2.0)) == 0.0)
    {
        fragColor.rgb *= 1.0 - (0.15 * noise);
    }

    // Shift green/blue channels (using the red channel)
    //fragColor.g = mix(fragColor.r, texture(texture0, vec2(xpos + noise * 0.00, uv.y)).g, gbDisplacement);
    //fragColor.b = mix(fragColor.r, texture(texture0, vec2(xpos - noise * 0.00, uv.y)).b, gbDisplacement);
	vec4 colors = fragColor;
	colors.rgb /= colors.a;
	colors.rgb += brightness+extraBrightness; 
	colors.rgb = clamp(((colors.rgb - 0.5) * max(contrast + 1.0, 0.0)) + 0.5, vec3(0,0,0), vec3(1,1,1));
	colors.rgb *= colors.a;
	fragColor = mix(colors, fragColor, vec4(mixShift));

}
