#version 330 core

in vec2 texCoord;
out vec4 fragColor;

uniform sampler2D texture0;
uniform vec4 color = vec4(1,1,1,1);
uniform vec2 iResolution = vec2(1920.0, 1080.0);
uniform vec2 parameters = vec2(300.5,0.5);
uniform float time = 0.0;
uniform float seed = 2.0;

/*
float rand (float x) {
    return fract(sin(x)*1e4);
}
*/

float rand(vec2 coord)
{
    return fract(sin(dot(coord.st,vec2(12.9898,78.233)+seed)) * 43758.5453);
}

float pattern(vec2 st, vec2 v, float t) {
    vec2 p = floor(st+v);
    return step(t, rand(100.+p*.000001)+rand(p.xx)*0.5 );
}

void main() {
    vec2 fragCoord = texCoord * iResolution;

    vec2 st = fragCoord/iResolution.xy;
    st.x *= iResolution.x/iResolution.y;

    vec2 grid = vec2(10.0,10.);
    st *= grid;
    st = st.xy;

    vec2 ipos = floor(st);  // integer
    vec2 fpos = fract(st);  // fraction

    vec2 vel = vec2(time*2.*max(grid.x,grid.y)); // time
    vel *= vec2(-1.,-1.0) * rand(vec2(1.0+ipos.y)); // direction

    // Assign a random value base on the integer coord
    vec2 offset = vec2(0.1,0.);

    vec3 color1 = vec3(0.);
    color1 = vec3(pattern(st+offset,vel,0.5+parameters.x/iResolution.x));

/*
    color1.r = pattern(st+offset,vel,0.5+parameters.x/iResolution.x);
    color1.g = pattern(st,vel,0.5+parameters.x/iResolution.x);
    color1.b = pattern(st-offset,vel,0.5+parameters.x/iResolution.x);
    */

    // Margins
    //color1 *= step(0.2,fpos.y);

    fragColor = vec4(1.0-color1,1.0);
    fragColor *= color;
    if (fragColor.r == 0.0) {
        discard;
    }
}
