local logicrunchlogo={}
local logo={image=nil,rotation=0,x=960,y=490,width=0,height=0,visible=false,initialTimeOffset=-math.pi/2}
function logicrunchlogo.load()
logo.image=love.graphics.newImage("logicrunchlogo3.png")
logo.width,logo.height=logo.image:getWidth(),logo.image:getHeight()
logo.visible=false end
function logicrunchlogo.start(t)
logo.visible=true
local tt=t or 0
logo.initialTimeOffset=-math.pi/2-(tt*6.585) end
function logicrunchlogo.stop(t)
logo.visible=false end
function logicrunchlogo.update(dt,timePassed)
if not logo.visible then return end
logo.rotation=logo.rotation+1.1*dt
local toff=logo.initialTimeOffset/6.585
local t=(timePassed+toff)%0.9585332276399064
local v
if t<0.2396333069099766 then v=1
elseif t<0.4792666138199532 then local u=(t-0.2396333069099766)/0.2396333069099766 v=math.cos(math.pi*u)
elseif t<0.7188999207299298 then v=-1
else local u=(t-0.7188999207299298)/0.2396333069099766 v=-math.cos(math.pi*u) end
logo.currentScale=2.0+0.81*v end
function logicrunchlogo.draw()
if not logo.visible then return end
love.graphics.push()
love.graphics.translate(logo.x,logo.y)
love.graphics.rotate(logo.rotation or 0)
love.graphics.scale(logo.currentScale or 1,logo.currentScale or 1)
love.graphics.draw(logo.image,-logo.width/2,-logo.height/2)
love.graphics.pop() end
return logicrunchlogo
