// latest

uniform float iTime;

#define PI 3.14159265359

// Seed variable for flower positioning
float seed = 0.;

// Random function to generate positions based on seed (without time dependence)
float rand(vec2 co) {
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

// Color cycling function
vec3 cycleColors(float t) {
    return 0.5 + 0.5 * vec3(sin(t), sin(t + PI / 3.0), sin(t + 2.0 * PI / 3.0));
}

// Function to create petals in polar coordinates
float petalShape(vec2 uv, vec2 center, float size, int petalCount) {
    vec2 offset = uv - center;
    float r = length(offset);  // Radial distance from the center
    float angle = atan(offset.y, offset.x);  // Angle in polar coordinates
    
    // Create the petal effect by modulating the angle
    float petalAngle = mod(angle * float(petalCount) / PI, 2.0) - 1.0;
    
    // Petal shape using smoothstep
    return smoothstep(size, size - 0.02, r * (1.0 + 0.5 * sin(petalAngle)));
}

// Growth function that oscillates between 0 and 1 for pulsating effect
float pulsatingGrowth(float timeOffset, float growSpeed) {
    return 0.5 + 0.5 * sin(iTime * growSpeed + timeOffset);
}

// Rotation function for UVs (spinning)
vec2 rotateUV(vec2 uv, vec2 center, float angle) {
    vec2 offset = uv - center;
    float cosA = cos(angle);
    float sinA = sin(angle);
    mat2 rotation = mat2(cosA, -sinA, sinA, cosA);
    return center + rotation * offset;
}

void main()
{

    vec2 iResolution = vec2(1920., 1080.);
    vec2 uv = gl_TexCoord[0].xy; // / iResolution.xy;
    uv = uv * 2.0 - 1.0; // Center the UV coordinates        
    
    vec3 finalColor = vec3(0.0);
    
    // Slow down time for a more gradual effect
    float slowTime = iTime * 0.1;  // Reduce time speed by a factor of 10
    
    // Loop to generate multiple flowers
    for (int i = 0; i < 50; i++) {
        // Generate a random position for each flower based only on seed and index (stable over time)
        vec2 seedPos = vec2(seed + float(i), seed + float(i) * 10.0);
        vec2 flowerPos = vec2(rand(seedPos), rand(seedPos + 10.0)) * 2.0 - 1.0;
        
        // Introduce a time offset for each flower to control when it starts growing
        float timeOffset = float(i) * 10.03;
        
        // Pulsating growth stages for the center and petals
        float centerSize = 0.05 * pulsatingGrowth(timeOffset, 0.4);  // Center pulsates
        float petalSize = 0.45 * pulsatingGrowth(timeOffset, 1.0);  // Petals pulsate
        
        // Slow spinning over time (adjust 0.05 to control speed)
        float spinSpeed = 0.01;
        float angle = iTime * spinSpeed + float(i); // Unique spin for each flower
        
        // Rotate UVs around the flower position
        vec2 rotatedUV = rotateUV(uv, flowerPos, angle);
        
        // Create the petals with rotation (6 petals)
        int petalCount = 300;
        float petals = petalShape(rotatedUV, flowerPos, petalSize, petalCount);
        
        // Cycle colors based on slow time
        vec3 color = cycleColors(slowTime + float(i) * 0.5);
        
        finalColor += petals * color;
        
    }
    
    
    gl_FragColor = vec4(finalColor, 1.0);
}
