#define PI 3.14159265359

uniform float iTime;
uniform vec3 color1 = vec3(1, 0, 1);  // First color uniform
uniform vec3 color2 = vec3(0, 0, 0);  // Second color uniform

void main() {
    vec2 iResolution = vec2(1920., 1080.);

    //vec2 uv = fragCoord.xy / iResolution.xy;  // Normalize coordinates
    vec2 uv = gl_FragCoord.xy / iResolution.xy;
    uv.x *= iResolution.x / iResolution.y;    // Adjust for aspect ratio

    // Time-based movement factor
    float timeFactor = iTime * 4;

    // Create radial moiré pattern
    float dist1 = length(uv - vec2(0.5, 0.5));
    float angle1 = atan(uv.y - 0.5, uv.x - 0.5);
    
    float dist2 = length(uv - vec2(0.3, 0.7));
    float angle2 = atan(uv.y - 0.7, uv.x - 0.3);

    // Generate patterns by creating interference between distances and angles
    float pattern1 = sin(30.0 * dist1 - angle1 * 8.0 + timeFactor);
    float pattern2 = sin(30.0 * dist2 + angle2 * 8.0 + timeFactor * 1.5);
    
    // Combine the two patterns
    float combinedPattern = (pattern1 + pattern2) * 0.5;

    // Apply smooth gradient
    combinedPattern = smoothstep(-0.3, 0.3, combinedPattern);

    // Interpolate between two colors based on the pattern
    vec3 color = mix(color1, color2, combinedPattern * 0.5 + 0.5);

    gl_FragColor = vec4(color, 1.0);
}
