// modified from https://www.geeks3d.com/20110316/shader-library-simple-2d-effects-sphere-and-ripple-in-glsl/

#version 130

uniform sampler2D currentTexture;
uniform float time;
uniform float force;
uniform float speed;
uniform float alpha;

void main()
{
    float zerozerothree = 0.02;

    vec2 tc = gl_TexCoord[0].xy;
    vec2 p = -1.0 + 2.0 * tc;
    float len = length(p);
    vec2 uv = tc + (p/len)*cos(len*force-time*speed)*zerozerothree;
    vec4 col = texture2D(currentTexture,uv).rgba;
    gl_FragColor = vec4(col.rgb, col.a * alpha);
}
