/*
 * Decompiled with CFR 0.152.
 */
package org.kd.common;

import com.badlogic.gdx.Gdx;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.kd.common.C64Helper;

public class ConsoleLogger {
    public static void logBannerWithElapsedTime(List<String> bannerLines) {
        bannerLines.forEach(line -> System.out.println((String)line));
        long frame = Gdx.graphics.getFrameId();
        System.out.println("Elapsed time: " + C64Helper.countElapsedTime() + " Frame: " + frame);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static List<String> readTextfile(String resourcePath) {
        try (InputStream is = ConsoleLogger.class.getResourceAsStream(resourcePath);){
            List<String> list;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
                list = reader.lines().collect(Collectors.toList());
            }
            return list;
        }
        catch (Exception e) {
            String emptyEquivalentOfFile = "\n".repeat(50);
            return Arrays.asList(emptyEquivalentOfFile.split(""));
        }
    }
}

