/*
 * Decompiled with CFR 0.152.
 */
package org.kd.tricks.letters;

import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import java.io.PrintStream;
import java.util.Map;
import org.kd.tricks.letters.Field;

public class Letter {
    private int size;
    protected Field[][] pattern;

    public Letter(int size) {
        this.size = size;
        this.pattern = new Field[8][8];
        for (int i = 0; i < this.pattern.length; ++i) {
            for (int j = 0; j < this.pattern[0].length; ++j) {
                Field field = Field.EMPTY;
                field.setSize(size);
                this.pattern[i][j] = Field.EMPTY;
            }
        }
    }

    public void draw(ShapeRenderer shapeRenderer, float letterX, float letterY) {
        shapeRenderer.begin(ShapeRenderer.ShapeType.Line);
        for (Field[] fields : this.pattern) {
            for (int j = 0; j < this.pattern[0].length; ++j) {
                Field field = fields[j];
                field.getPoints().forEach(point -> {
                    float x1 = letterX + (float)(2 * point.getX());
                    float y1 = letterX + (float)(2 * point.getY());
                    shapeRenderer.rect(x1, y1, 1.0f, 1.0f);
                });
            }
        }
        shapeRenderer.end();
    }

    public void print() {
        PrintStream o = System.out;
        Map<Field, Character> map = Map.of(Field.EMPTY, Character.valueOf('.'), Field.FULL, Character.valueOf('#'), Field.BOTTOM_LEFT, Character.valueOf('\\'), Field.TOP_LEFT, Character.valueOf('/'), Field.BOTTOM_RIGHT, Character.valueOf('/'), Field.TOP_RIGHT, Character.valueOf('\\'));
        for (Field[] fields : this.pattern) {
            for (int j = 0; j < this.pattern[0].length; ++j) {
                o.print(map.get((Object)fields[j]));
            }
            o.println();
        }
    }

    public Field[][] getPattern() {
        return this.pattern;
    }
}

