#ifndef LIB_COLOR_GLSL
#define LIB_COLOR_GLSL

// sRGB luma (BT.709)
float luma(vec3 rgb) { return dot(rgb, vec3(0.2126, 0.7152, 0.0722)); }

// Apply saturation and brightness with early-outs.
// - sat: 1.0 = original color, 0.0 = grayscale
// - gain: 1.0 = no brightness change
vec4 color_ops(vec4 rgba, float sat, float gain) {
    // Early-out: nothing to do
    if (sat == 1.0 && gain == 1.0) return rgba;

    vec3 c = rgba.rgb;

    // Saturation: only compute luma if needed
    if (sat != 1.0) {
        float y = luma(c);
        c = mix(vec3(y), c, sat);
    }

    // Brightness
    if (gain != 1.0) {
        c *= gain;
    }

    return vec4(c, rgba.a);
}

#endif // LIB_COLOR_GLSL