#version 410

//#define MAX_LIGHTS 3

#pragma include "p3d/uniform.glsl"
#pragma include "lib/shadow.glsl"
#pragma include "lib/constants.glsl"
#pragma include "lib/color.glsl"
#pragma include "lib/math.glsl"

// Uniform inputs
uniform float u_MaxShininess;
uniform float u_RimLightIntensity;
uniform float u_ShadowSamples;
uniform float u_ShadowSpread;
uniform float u_SpecularBlendStrength;
uniform int u_NumberOfLights;
uniform float u_SpecularPower;
uniform float u_Roughness;
uniform float u_Brightness;
uniform float u_Saturation;
uniform float u_Reflectivity;

//uniform sampler2D u_BaseColorTex;
//uniform sampler2D u_MetallicRoughnessTex;
//uniform sampler2D u_NormalTex;
//uniform bool u_UseBaseColorTex;
//uniform bool u_UseMetallicRoughnessTex;
//uniform bool u_UseNormalTex;

uniform vec3 u_TexOrder;

// Input from vertex shader
in vec4 vertInShadowSpaces[MAX_LIGHTS];
in vec4 vertColor;
in vec4 vertPosition;
//in vec4 domiPosition;
in vec2 vertMultiTexCoord0;
in vec3 vertNormal;
//in vec3 binormal;
in vec3 tangent;
in float neg;

// Output to the screen
//out vec4 fragColor;
//out vec4 reflectivityOut;
layout(location = 0) out vec4 fragColor;
layout(location = 1) out vec4 reflectivityOut;

#define MAX_FRESNEL_POWER 5.0
#define MAX_SHININESS     127.75

// Clamp value to [0,1] (short alias)
float sat(float x) { return clamp(x, 0.0, 1.0); }

//vec3 dir_to_rgb(vec3 v) { return v * 0.5 + 0.5; } // map [-1,1] -> [0,1]

void main() {

    vec4 diffuseColor = texture(p3d_TextureModulate[0], vertMultiTexCoord0) * vertColor;
//    vec4 diffuseColor = texture(p3d_TextureModulate[0], vertMultiTexCoord0);
//    vec4 diffuseColor = vertColor;
//    diffuseColor.rgb = vec3(1.0, 1.0, 0.0);

//    diffuseColor.a = 1.0;  // Test
//    diffuseColor.a = sat(diffuseColor.a);  // Test

//    if (diffuseColor.a < 0.5) discard;
//    if (diffuseColor.a < rand(gl_FragCoord.xy)) discard;


    diffuseColor = color_ops(diffuseColor, u_Saturation, u_Brightness);
//    diffuseColor = color_ops(diffuseColor, u_Saturation, 0.05);

    vec4 roughnessMap = texture(p3d_TextureSelector[0], vertMultiTexCoord0);

    vec4 normalTex = texture(p3d_TextureNormal[0], vertMultiTexCoord0);

//    float roughness = roughnessMap.g;
    float roughness = 0.0;

//
//    float occlusion = roughnessMap.r;  // AO in red
//    float metallic  = roughnessMap.b;  // Metallic in blue
//

    float shininess = (1.0 - roughness) * MAX_SHININESS * u_MaxShininess;

    vec4 diffuse  = vec4(0.0, 0.0, 0.0, diffuseColor.a);
    vec4 specular = vec4(0.0, 0.0, 0.0, diffuseColor.a);
    vec4 rim      = vec4(0.0, 0.0, 0.0, diffuseColor.a);

//
//    vec3 materialSpecularColor = p3d_Material.specular;
//

    vec3 Nv = normalize(vertNormal);
    vec3 Tv = normalize(tangent - Nv * dot(tangent, Nv)); // upewnij T ⟂ N
    vec3 Bv = cross(Nv, Tv);                               // brak sign — prosto i szybko

    vec3 nMap = normalize(texture(p3d_TextureNormal[0], vertMultiTexCoord0).rgb * 2.0 - 1.0);
//    vec3 normal = u_UseNormalTex ? normalize(mat3(Tv, Bv, Nv) * nMap) : Nv;
    vec3 normal = normalize(mat3(Tv, Bv, Nv) * nMap);

    vec3 eyeDirection = normalize(-vertPosition.xyz);

    vec3 test;

    for (int i = 0; i < u_NumberOfLights; ++i) {  // i = 0

        vec3 lightDirection = p3d_LightSource[i].position.xyz - vertPosition.xyz * p3d_LightSource[i].position.w;

        vec3 unitLightDirection = normalize(lightDirection);
        vec3 halfwayDirection   = normalize(unitLightDirection + eyeDirection);

        float lightDistance = length(lightDirection);

        float attenuation = 1 / (
            p3d_LightSource[i].constantAttenuation +
            p3d_LightSource[i].linearAttenuation * lightDistance +
            p3d_LightSource[i].quadraticAttenuation * (lightDistance * lightDistance)
        );

        if (attenuation <= 0.0) { continue; }

        // Diffuse
        float diffuseIntensity  = dot(normal, unitLightDirection);
        if (diffuseIntensity < 0.0) { continue; }
//        vec4 diffuseTemp = vec4(
//            clamp(diffuseColor.rgb * p3d_LightSource[i].diffuse.rgb * diffuseIntensity, 0.0 , 1.0), diffuseColor.a
//        );
//        diffuseTemp = clamp(diffuseTemp, vec4(0), diffuseColor);
        vec4 diffuseTemp = vec4(
            clamp(diffuseColor.rgb * p3d_LightSource[i].diffuse.rgb * diffuseIntensity, 0.0 , 1.0), diffuseColor.a
        );


        // Specular
        float specularIntensity = sat(dot(normal, halfwayDirection));
        vec4 lightSpecularColor = p3d_LightSource[i].specular;
        vec4 materialSpecularColor = vec4(vec3(1.0 - roughness), diffuseColor.a);

//
//        vec4 materialSpecularColor = vec4(mix(vec3(0.04), diffuseColor.rgb, metallic), diffuseColor.a);
//

        float fresnelFactor = dot(halfwayDirection, eyeDirection);
        fresnelFactor = max(fresnelFactor, 0.0);
        fresnelFactor = 1.0 - fresnelFactor;
        fresnelFactor = pow(fresnelFactor, MAX_FRESNEL_POWER);
        materialSpecularColor.rgb = mix(
            materialSpecularColor.rgb,
            vec3(u_SpecularBlendStrength),
            sat(fresnelFactor)
        );

        vec4 specularTemp = vec4(vec3(0.0), diffuseColor.a);
        specularTemp.rgb  = lightSpecularColor.rgb * pow(specularIntensity, shininess);
        specularTemp.rgb *= materialSpecularColor.rgb;
        specularTemp.rgb  = clamp(specularTemp.rgb, 0.0, 1.0);  // Comment to have more specular
        specularTemp.rgb *= u_SpecularPower;

        // Spot
        float unitLightDirectionDelta = dot(normalize(p3d_LightSource[i].spotDirection), -unitLightDirection);
        if (unitLightDirectionDelta < p3d_LightSource[i].spotCosCutoff) { continue; }
        float spotExponent = p3d_LightSource[i].spotExponent;
        diffuseTemp.rgb *= (spotExponent <= 0.0 ? 1.0 : pow(unitLightDirectionDelta, spotExponent));

//        float u_ShadowSpread = 0.0;
//        float u_ShadowSamples = 0.0;
        // Shadow
        float shadow = sh(
            p3d_LightSource[i].shadowMap,
            vertInShadowSpaces[i],
            u_ShadowSpread,
            u_ShadowSamples // float selector: 0..4
        );

//        shadow = 1.0;

        diffuseTemp.rgb  *= shadow;
        specularTemp.rgb *= shadow;

//        test = vec3(diffuseTemp);

        diffuseTemp.rgb  *= attenuation;
        specularTemp.rgb *= attenuation;

        diffuse  += diffuseTemp;
        specular += specularTemp;

        // Rim
        vec4 rimLight = vec4(0.0);
        rimLight.rgb = vec3(1.0 - max(0.0, dot(normalize(-vertPosition.xyz), normalize(normal))));
        rimLight.rgb = pow(rimLight.rgb, vec3(2.0)) * u_RimLightIntensity;
        rimLight.rgb *= diffuse.rgb;
        rim += rimLight;

    }

    vec4 ambient = p3d_Material.ambient * p3d_LightModel.ambient * diffuseColor;

    vec3 color = diffuse.rgb + rim.rgb + specular.rgb + ambient.rgb + p3d_Material.emission.rgb;

//    color.rgb = test;
//    color.rgb = diffuseTemp.rgb;
//    color.rgb = diffuseColor.rgb;
//    color.rgb = Tv;
//    color.rgb = normal;
//    color.rgb = vertNormal;
//    color.rgb = tangent;
//    color.rgb = dir_to_rgb(normalize(tangent));
//    color.rgb = vec3(u_ShadowSamples);
//    color.rgb = vec3(u_ShadowSpread * 100.0);

    fragColor = vec4(color, diffuseColor.a);
    reflectivityOut = vec4(vec3(u_Reflectivity), 1.0);
}
