	;
	VSCR=40000	; SCREEN ADDRESS
	SCOREP=40154	; SCORE	POSITION
	AMMOP=40140	; AMMO POSITION
	MSGLN=44500	; MESSAGES POSITION
	MAPPOS=40000	; MAP POSITION
	MNSPS=57700	; MONSTERS POSITION
	FNT=34200	; FONT ADDRESS
	;
	MNVSC=136000	; MONSTERS VIRTUAL SCREEN
	; NOTE:	NEED TO	BE 256 BYTES BOUND ALIGN
	;
	VIS=135400	; VISIBILITY MAP
	MAP=135000	; RUNTIME MAP
	; NOTE:	DO NOT CHANGE ORDER IN MEMORY
	;
	; FRAME	STRUCTURE: 260.+256.=516. BYTES	1004
	FRBF1=134374	; HEIGHT	65.=130. 202
	FRBF2=134576	; MATERIAL	65.=130. 202
	; NOTE:	DO NOT CHANGE ORDER IN MEMORY
	;
	PSCTAB=132234	; SPRITE PRESCALLERS	1120.(2140)
	;
	; MONSTERS PROCESSING BUFFER (25.)	372(O)
	MNBF=131642	; HUNTERS (5.)		62(O)
	MNBFS=131724	; PROJECTILES (13.)	202(O)
	MNBFX=132126	; AMMOS	(7.)		106(O)
	MNBFE=132234	; END OF ALL ACTORS
	MNRS=10.	; SIZEOF(RECORD)
	;
	WRC=130522	; WALLS	RENDERING CODES
	;
	HITRAD=20.	; HIT RADIUS(ONE CELL EDGE IS 64)
	SCLIM=25.	; SCORE	LIMIT
	;
	; GAME STATES
	GSEXIT=0.	; EXIT
	GSGAME=1.	; GAME RUNNING
	GSPAUS=2.	; PAUSE
	GSPLWN=4.	; PLAYER WON
	GSHTWN=8.	; HUNTERS WON
	;
START:	CALL HWINIT
	CLR BITFLD
	CLR AMAP
	JMP GOTIT
	;
	; VARIABLES
	;
GSTATE:	.WORD 0		; GAME STATE
	;
	; 0=EXIT
	; 1=GAME RUNNING
	; 2=PAUSED
	; 3=THE	PLAYER WON
	; 4=THE	HUNTERS	WON
	;
BITFLD:	.WORD 0		; TAB,KT,ENTER AND SAME	FLAGS
KEYCOD:	.BYTE 0		; KEY SCAN CODE
TKCNTR:	.BYTE 0		; TICK COUNTER
PRCNTR:	.BYTE 0		; PREV.TICK COUNTER
FRCNTR:	.BYTE 0		; FRAME	COUNTER
	.EVEN
	;
	; GAME AMMO&OUTPUT
AMMO:	.BYTE 10.
OLDAM:	.BYTE 1.
	.EVEN
	;
	; GAME SCORE&OUTPUT
SCORE:	.BYTE 0.,0.
OLDSCR:	.BYTE 1.,0.
	.EVEN
	;
	; PLAYER VARS (WILL BE LOADED WITH MAP)
PLX:	.WORD 0
PLY:	.WORD 0
PLA:	.WORD 0
	;
	; CONTROL EVENTS
	; LEFT,RIGHT,SHIFT LEFT,SHIFT RIGHT
	; UP,DOWN,TOGGLE MAP,FIRE,EXIT
	;
CODESJ:	.BYTE 0,0,0,0,0,0,1,1,4,4,10,2,0,40,0,0,20
CODESK:	.BYTE 232,112,106,210,127,231,32,103,33
	.BYTE 131,10,31,211,40,14,3,12
RULES:	.BYTE 372,372,372,372,372,372,372,372,372,372
	.BYTE 372,372,360,372,374,360,363
	.EVEN
	;
PROCS:	.WORD DROT
	.WORD DROT
	.WORD DSL
	.WORD DSL
	.WORD DSR
	.WORD DSR
	.WORD DUP
	.WORD DUP
	.WORD DDWN
	.WORD DDWN
	.WORD DLFT
	.WORD DRGHT
	.WORD DTAB
	.WORD DSPC
	.WORD DPAUS
	.WORD DEXIT
	.WORD DREST
	;
JOYMSK:	.WORD 0
	;
	; SINGLE PRESS CHECK
SCFLG:	MOVB TKCNTR,R0
	MOVB PRCNTR,R1
	MOVB R0,PRCNTR
	INCB R1
	CMPB R1,R0
	RET
	;
	; CONTROLS PROCESSING
JOY:	MOV #CODESK-CODESJ,R1
	MOV JBMP,R2
	CLR JBMP
	CLR R3
	BISB KEYCOD,R3
	BIT #100,@#177716
	BEQ 55$
	COM R3
55$:	; --- REMAP FOR	SLIDE SUPPORT ---
	BIT R2,#100	; MOUSE/JOY RB PRESSED?
	BEQ 1$		; NO->DO NOT REMAP
	BIT R2,#12	; LEFT/RIGHT ACTIVE?
	BEQ 1$		; NO->DO NOT REMAP
	MOV ANGV,SLDV	; CONVERT TURN INTO SLIDE
	BIC #12,R2	; TURN OFF TURN	ON MOUSE/JOY
	TST SLDV	; WHICH	DIRECTION?
	BPL 56$
	MOV #106,R3	; MAKE VIRTUAL PRESS
	BR 1$
56$:	MOV #127,R3	; MAKE VIRTUAL PRESS
	; --- END OF REMAP FOR SLIDE ---
1$:	CLR R0
	TST R3
	BMI 2$
	CMPB CODESK-1(R1),R3
	BEQ 3$
2$:	BITB CODESJ-1(R1),R2
	BEQ 4$
	; -- FIX MOUSE&JOY FIRE	--
	BIT #40,R2
	BEQ 3$
	MOV @#177714,-(SP)
	CLR @#177714
	MOV #140010,@#177714
	BIT #40,(SP)+
	BEQ 4$
	; --- END OF FIRE FIX ---
3$:	MOV R3,-(SP)
	MOV R2,-(SP)
	MOV R1,-(SP)
	MOV R0,-(SP)
	MOV GSTATE,R0
	BICB RULES-1(R1),R0
	BEQ 6$
	ASL R1
	CMP PROCS-2(R1),PROCS-4(R1)
	BNE 5$
	INC (SP)
5$:	CALL @PROCS-2(R1)
6$:	MOV (SP)+,R0
	MOV (SP)+,R1
	MOV (SP)+,R2
	MOV (SP)+,R3
	SUB R0,R1
	BEQ 7$
4$:	SOB R1,1$
7$:	CLR ANGV
	CLR MOVV
	CLR SLDV
	RET
	;
	; LOAD MAP
	; R0=MAP NUMBER	0..N
LMAP:	CLRB FRCNTR	; FRAME	COUNTER
	CALL PREPM	; PREPARE RUNTIME MAP &	PLAYER POSITION
	CALL CLVIS	; CLEAR	VISIBILITY MAP
	CALL MNSET	; SET MONSTERS
	CALL INISCR	; RESET	SCORE
	CALL INIAM	; RESET	AMMO
	RET
	;
	; INC FRAME COUNTER
	; USED IN VISIBILITY MAP
	; SHOULD BE 0,2,4...
IFRC:	MOVB FRCNTR,R0
	INCB R0
	INCB R0
	MOVB R0,FRCNTR
	BNE 1$
	CALL CLVIS	; CLEAR	VISIBILITY MAP
1$:	RET
	;
GO:	CALL NOSND	; NO SOUNDS
	CALL CLPSC	; CALC PRESCALLERS
	CALL CALCD	; CALC DIV TABLE
	CALL DRST2	; RESTART LEVEL
	;
	; MAIN LOOP
ML:	CALL IFRC	; FOR VISIBILITY MAP
	CALL RENDR	; RENDER WALLS
	CALL DRDIFF	; DRAW WALLS
	CALL MNPRC	; RENDER&DRAW MONSTERS
	;
	CALL PRNSCR	; PRINT	SCORE
	CALL PRNAM	; PRINT	AMMO
	CALL DRCRH	; DR.CROSSHAIR
	CALL PRCSEF	; PLAY SOUNDS
	CLR SNDBM	; CLEAR	SOUNDS BITMAP
	;
ML2:	CALL GLOGIC	; GAME LOGIC
	CALL DOMAP	; PROCESS MAP
	CALL DORST	; PROCESS RESTART
	MOV GSTATE,R0	; CHECK	GAME STATE
	BEQ 1$		; 0=EXIT
	ASR R0
	BEQ ML		; 1=GAME RUNNING
	ASR R0
	BEQ ML2		; 2=GAME PAUSED
	ASR R0
	BEQ ML		; 4=PLAYER WON
	ASR R0
	BEQ ML		; 8=HUNTERS WON
	; RESERVED: OTHER CASES
	BR ML		; AND GO BACK TO MAIN LOOP
	;
1$:	RET		; EXIT
	;
	; DO RESTART
DORST:	BIT #4,BITFLD	; CHECK	FOR RESTART PRESSED
	BEQ 1$
	BIC #4,BITFLD	; CLEAR	FLAG
	CALL DRST2
1$:	RET
	; PROCESS MAP
DOMAP:	BIT #1,BITFLD	; CHECK	FOR TAB	PRESSED
	BEQ 2$		; NOT PRESSED
	BIC #1,BITFLD	; CLEAR	PRESSED	FLAG
	BIT #2,BITFLD	; CHECK	STATE
	BNE 1$		; NEED DRAW
	CALL CLMAP	; NEED CLEAR
	RET
1$:	CALL DRMAP
	CALL DRALL
	RET
2$:	BIT #2,BITFLD	; NEED DRAW MAP?
	BEQ 3$
	CMP #GSPAUS,GSTATE
	BEQ 3$
	CALL DRALL	; DRAW ALL
3$:	RET
	;
	; DO KT	(EXIT)
DEXIT:	CLR GSTATE
	RET
	; DO TAB
DTAB:	CALL SCFLG
	BEQ 1$
	MOV #2,R0
	XOR R0,BITFLD	; SWITCH TAB FLAG
	BIS #1,BITFLD	; SET TAB PRESSED FLAG
1$:	RET
	; DO SPACE
DSPC:	CALL SCFLG
	BEQ 1$
	CALL DPROJ1
1$:	RET
	; SET PLAYER
SETPL:	MOV R0,PLX
	MOV R1,PLY
	RET
	; GET PLAYER DIRECTION
	; OUT: R0=VX,R1=VY
GETDIR:	MOV PLA,R0
	CALL GSNCS
	RET
	; DO DOWN
DDWN:	CALL GETDIR
	MOV MOVV,R2
	CALL SHIFT
DDWN2:	MOV R0,R2
	MOV R1,R3
	NEG R0
	NEG R1
	ADD PLX,R0
	ADD PLY,R1
	CALL CHECK
	BNE 1$
	CALL SETPL
	BR 3$
1$:	ADD R3,R1
	CALL CHECK
	BNE 2$
	CALL SETPL
	BR 3$
2$:	SUB R3,R1
	ADD R2,R0
	CALL CHECK
	BNE 3$
	CALL SETPL
3$:	RET
	; DO UP
DUP:	CALL GETDIR
	MOV MOVV,R2
	CALL SHIFT
DUP2:	MOV R0,R2
	MOV R1,R3
	ADD PLX,R0
	ADD PLY,R1
	CALL CHECK
	BNE 1$
	CALL SETPL
	BR 3$
1$:	SUB R3,R1
	CALL CHECK
	BNE 2$
	CALL SETPL
	BR 3$
2$:	ADD R3,R1
	SUB R2,R0
	CALL CHECK
	BNE 3$
	CALL SETPL
3$:	RET
	; DO SHIFT LEFT
DSL:	CALL GETDIR
	MOV SLDV,R2
	CALL SHIFT
	XOR R0,R1
	XOR R1,R0
	XOR R0,R1
	NEG R1
	JMP DUP2
	; DO SHIFT RIGHT
DSR:	CALL GETDIR
	MOV SLDV,R2
	CALL SHIFT
	XOR R0,R1
	XOR R1,R0
	XOR R0,R1
	NEG R1
	JMP DDWN2
	; DO LEFT
DLFT:	MOV ANGV,R0
	BIT R2,#100000
	BEQ 1$
	ASL R0
1$:	ADD R0,PLA
	BIC #177000,PLA
	RET
	; DO RIGHT
DRGHT:	BR DLFT
	; DO 180 ROTATE
DROT:	CALL SCFLG
	BEQ 2$
	ADD #256.,PLA
	BIC #177000,PLA
2$:	RET
	; DO PAUSE
DPAUS:	CALL SCFLG
	BEQ 1$
	CMP GSTATE,#GSGAME
	BNE 2$
	; GAME RUNNING->PAUSE IT
	MOV #GSPAUS,GSTATE	; PAUSE
	CLR R5
	CALL PRNMS
	BR 1$
2$:	CMP GSTATE,#GSPAUS
	BNE 1$
	; GAME PAUSED->RUN IT
	MOV #GSGAME,GSTATE	; RUNNING
	CALL CLMS
1$:	RET
	; RESTART GAME
DREST:	CALL SCFLG
	BEQ 1$
	CMP GSTATE,#GSPLWN
	BEQ 2$
	CMP GSTATE,#GSHTWN
	BEQ 2$
1$:	RET
2$:	BIS #4,BITFLD		; SET FLAG TO RESTART
	RET
DRST2:	CLR SNDBM		; CLEAR	SOUNDS BITMAP
	MOV (PC)+,R0
AMAP:	.WORD 0
	CALL LMAP		; LOAD MAP
	MOV #GSGAME,GSTATE	; RUNNING
	CALL CLMS
	BIT #2,BITFLD
	BEQ 1$
	CALL DRMAP
1$:	RET
	;
	.END

 