; ==========================================================================
; FAIRLY BAD SOLUTION FOR THE 2025 VCCC
; Ken Jennings
;
; Written for Atari 8-bit computers.
; Should work on any model.
; Should work on any memory size capable of running DOS to load an XEX.
;
; Assembly source intended for MADS assembler.
; ==========================================================================
;
; TARGET:
; Display the 19 character wide snowflake:
;
;    -00000000001111111111-
;    -01234567890123456789-
; 00 "         *          "
; 01 "       * * *        "
; 02 "  * *   ***   * *   "
; 03 "   **    *    **    "
; 04 "  ***  * * *  ***   "
; 05 "     *  ***  *      "
; 06 "      *  *  *       "
; 07 " *  *  * * *  *  *  "
; 08 "  *  *  ***  *  *   "
; 09 "******************* "
; 10 "  *  *  ***  *  *   "
; 11 " *  *  * * *  *  *  "
; 12 "      *  *  *       "
; 13 "     *  ***  *      "
; 14 "  ***  * * *  ***   "
; 15 "   **    *    **    "
; 16 "  * *   ***   * *   "
; 17 "       * * *        "
; 18 "         *          "
;
; ==========================================================================
;
; "SOLUTION"
; Use Atari's structured load format to create a custom screen in memory.   
; Only one 6502 instruction is executed. JMP prevents returning to DOS.
;
; ==========================================================================
;
; "Executable" File size is 271 bytes. 
; == 6502 EXECUTABLE:
; == == 3  bytes of 6502 code (only one JMP to prevent returning to DOS)
; == GRAPHICS DATA:
; == == SCREEN DATA:
; == == == 174 bytes graphic memory
; == == ==  60 bytes of display list
; == METADATA:
; == == 11  bytes of miscellaneous data loaded in OS registers.
; == == 22 bytes of Atari load file format overhead.
;
; ==========================================================================

; OS Shadow registers for ANTIC.  
SDMCTL = $022F ; DMACTL - DMA Control of ANTIC
SDLSTL = $0230 ; DLISTL - Address of Display List

PLAYFIELD_WIDTH_NORMAL = %00000010 ; 20 characters/160 color clocks
ENABLE_DL_DMA          = %00100000 ; Enable running the Display List

DL_BLANK_8 = $70       ; 8 Blank Scan lines
DL_LMS     = %01000000 ; Enable Reload Memory Scan address for a graphics line
DL_TEXT_6  = $06       ; 5 Color, 20 Columns X 8 Scan lines, 20 bytes/line
DL_JUMP_VB = $41       ; Display List jump to address and start Vertical Blank

COLOR0 =  $02C4 ; COLPF0 - Playfield 0 color

DOS_RUN_ADDR = $02E0   ; Execute at the address tored here when file loading completes.

; ==========================================================================

	ORG $3800          ; After Atari DOS 2.0s and Dup.  Before 16K.


; If this were a normal, sequential display the memory usage would 
; be 20 bytes * 19 lines == 380 bytes.
; However, most of the lines are duplicates. A custom display list 
; can reuse lines and so have the data in memory represented 
; one time.
; There are only 10 unique lines of data, so the defined size 
; could be 20 bytes * 10 lines == 200 bytes.
; Wait a minute, there's more...
; Since most lines end in blank spaces and the next line begins with 
; blank spaces, a line can borrow some spaces for the end of its line from 
; the spaces at the beginning of the next line.  This eliminates data 
; equivalent to more than one full line of screen data.

; Unique lines...
; LINE_0  "******************* "
; LINE_I  "  *  *  ***  *  *   "
; LINE_H  " *  *  * * *  *  *  "
; LINE_G  "      *  *  *       "
; LINE_F  "     *  ***  *      "
; LINE_E  "  ***  * * *  ***   "
; LINE_D  "   **    *    **    "
; LINE_C  "  * *   ***   * *   "
; LINE_B  "       * * *        "
; LINE_A  "         *          "

; If all 200 bytes were used, define like this....
; LINE_0 .byte $0A,$4A,$8A,$CA,$0A,$4A,$8A,$CA,$0A,$4A,$8A,$CA,$0A,$4A,$8A,$CA,$0A,$4A,$8A,$00
; LINE_1 .byte $00,$00,$CA,$00,$00,$8A,$00,$00,$4A,$8A,$CA,$00,$00,$8A,$00,$00,$4A,$00,$00,$00
; LINE_2 .byte $00,$CA,$00,$00,$8A,$00,$00,$4A,$00,$CA,$00,$4A,$00,$00,$0A,$00,$00,$CA,$00,$00
; LINE_3 .byte $00,$00,$00,$00,$00,$00,$4A,$00,$00,$0A,$00,$00,$CA,$00,$00,$00,$00,$00,$00,$00
; LINE_4 .byte $00,$00,$00,$00,$00,$4A,$00,$00,$0A,$4A,$8A,$00,$00,$4A,$00,$00,$00,$00,$00,$00
; LINE_5 .byte $00,$00,$CA,$0A,$4A,$00,$00,$0A,$00,$8A,$00,$0A,$00,$00,$CA,$0A,$4A,$00,$00,$00
; LINE_6 .byte $00,$00,$00,$4A,$8A,$00,$00,$00,$00,$CA,$00,$00,$00,$00,$0A,$4A,$00,$00,$00,$00
; LINE_7 .byte $00,$00,$4A,$00,$CA,$00,$00,$00,$CA,$0A,$4A,$00,$00,$00,$4A,$00,$CA,$00,$00,$00
; LINE_8 .byte $00,$00,$00,$00,$00,$00,$00,$CA,$00,$4A,$00,$CA,$00,$00,$00,$00,$00,$00,$00,$00
; LINE_9 .byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$8A,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

; Optimized with blank space reduction at the end of lines.
; 10 * 200 - 26 == 174 bytes of screen RAM used to display as 380 bytes.
LINE_0 .byte $0A,$4A,$8A,$CA,$0A,$4A,$8A,$CA,$0A,$4A,$8A,$CA,$0A,$4A,$8A,$CA,$0A,$4A,$8A,$00
LINE_1 .byte $00,$00,$CA,$00,$00,$8A,$00,$00,$4A,$8A,$CA,$00,$00,$8A,$00,$00,$4A,$00,$00
LINE_2 .byte $00,$CA,$00,$00,$8A,$00,$00,$4A,$00,$CA,$00,$4A,$00,$00,$0A,$00,$00,$CA
LINE_3 .byte $00,$00,$00,$00,$00,$00,$4A,$00,$00,$0A,$00,$00,$CA,$00,$00
LINE_4 .byte $00,$00,$00,$00,$00,$4A,$00,$00,$0A,$4A,$8A,$00,$00,$4A,$00,$00,$00,$00
LINE_5 .byte $00,$00,$CA,$0A,$4A,$00,$00,$0A,$00,$8A,$00,$0A,$00,$00,$CA,$0A,$4A
LINE_6 .byte $00,$00,$00,$4A,$8A,$00,$00,$00,$00,$CA,$00,$00,$00,$00,$0A,$4A,$00,$00
LINE_7 .byte $00,$00,$4A,$00,$CA,$00,$00,$00,$CA,$0A,$4A,$00,$00,$00,$4A,$00,$CA
LINE_8 .byte $00,$00,$00,$00,$00,$00,$00,$CA,$00,$4A,$00,$CA
LINE_9 .byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$8A,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

; ==========================================================================

; DISPLAY LIST
; Total DL size == 3 (blanks) + 19 (Mode 6) + 36 (18 LMS addresses) + 3 (JVB) == 61 bytes

DISPLAY_LIST
	.byte DL_BLANK_8,DL_BLANK_8,DL_BLANK_8     ; 24 blank scan lines. 
	.byte DL_LMS|DL_TEXT_6
	.word LINE_9                               ; Line 1 (Mirrors 19)
	.byte DL_LMS|DL_TEXT_6
	.word LINE_8                               ; Line 2 (18)
	.byte DL_LMS|DL_TEXT_6
	.word LINE_7                               ; Line 3 (17)
	.byte DL_LMS|DL_TEXT_6
	.word LINE_6                               ; Line 4 (16)
	.byte DL_LMS|DL_TEXT_6
	.word LINE_5                               ; Line 5 (15) 
	.byte DL_LMS|DL_TEXT_6
	.word LINE_4                               ; Line 6 (14)
	.byte DL_LMS|DL_TEXT_6
	.word LINE_3                               ; Line 7 (13)
	.byte DL_LMS|DL_TEXT_6
	.word LINE_2                               ; Line 8 (12)
	.byte DL_LMS|DL_TEXT_6
	.word LINE_1                               ; Line 9 (11)
	.byte DL_LMS|DL_TEXT_6
	.word LINE_0                               ; Line 10 Middle.  Everything after is in order
	.byte DL_TEXT_6                            ; Line 11 (9)
	.byte DL_LMS|DL_TEXT_6                     
	.word LINE_2                               ; Line 12 (8)
	.byte DL_LMS|DL_TEXT_6                    
	.word LINE_3                               ; Line 13 (7)
	.byte DL_LMS|DL_TEXT_6                    
	.word LINE_4                               ; Line 14 (6)
	.byte DL_LMS|DL_TEXT_6                     
	.word LINE_5                               ; Line 15 (5)
	.byte DL_LMS|DL_TEXT_6                     
	.word LINE_6                               ; Line 16 (4)
	.byte DL_LMS|DL_TEXT_6                     
	.word LINE_7                               ; Line 17 (3)
	.byte DL_LMS|DL_TEXT_6                     
	.word LINE_8                               ; Line 18 (2)
	.byte DL_LMS|DL_TEXT_6                  
	.word LINE_9                               ; Line 19 (Mirrors 1)
	.byte $41                                  ; JuMP for Vertical Blank
	.word DISPLAY_LIST

; ==========================================================================

; The "program" starts here.  Loop infinitely to prevent immediately returning to DOS.

PROGRAM_START
	JMP PROGRAM_START

; That's it, no more code.

; ==========================================================================

; More gymnastics with the Atari's load file format to have the file 
; loading also update shadow registers to enable the new display....

; These are bytes of data which will be loaded in additional file segments.
; Each segment has Start address and End address; an extra 16 bytes of 
; file structure information added to the actual program data loaded into memory.

; The prgram has 5 segments.
; 2 file header bytes.
; 4 bytes of starting/ending addresses per segment. 
; Plus segment data.
; == 1 (file header byte) + 20 bytes (5 segments * 4 bytes)  == 22 bytes of file structure

	ORG SDMCTL         ; OS Shadow register for DMACTL -  DMA Control of ANTIC
	.byte $00          ; Turn off the display/DMA.
	;                    It just so happens that SDLSTL, the Display List pointer, follows here.
	.word DISPLAY_LIST ; Point ANTIC to the new Display List. 

	ORG SDMCTL
	.byte PLAYFIELD_WIDTH_NORMAL|ENABLE_DL_DMA ; Turn on ANTIC DMA and start the screen.

	ORG COLOR0 ;  Let's make it all look pretty.... ish
	.byte $0c,$8c,$9c,$ac,$72
	
	ORG DOS_RUN_ADDR   ; Tell DOS where this program begins execution after it loads the file.
	.word PROGRAM_START

; ==========================================================================

	END
