;;=======================================================================
;; Vintage Computing Christmas Challenge 2025 (VC3 2025) 
;; Amstrad CPC / Longshot (Logon System)
;; December 2025 
;; 45 bytes 
;; Brute Force Mode! 
;; run from basic : memory &1f00:mode 0:load "vcc2025.bin":call #abe
;; or type : run "STUB" with the same content
;;=======================================================================
_size_code 	equ _end_code-_start_code

org_code	equ #2100-47		; Raw_Pattern end at #20fe (bc=20ff)
hirom_display	equ #c38b		; Rom string display (input hl=ptr string)
firm_display	equ #bb5a		; Firmware Display Char (input acc=ascii char)
					; Register de=#0abe / bc=#20ff / hl=00xx / Zf=1 Cf=0
		org org_code
		run $
_start_code				; adr of call=>>DE >> #0abe (#0a=calc char "*", #be>>end of buffer)  
		ld h,b			; h=#20xx (xx=b for up ptr, de=down ptr)
byte_roll
		dec c			; #20fe start of pattern table
		scf			; Cf=1 injected in pattern rolled byte to test reload condition
bit_roll
		ld l,c			; hl=ptr on Raw pattern corrected
		rl (hl)			; Get Cf from pattern (1=star;0=space)
		jr z,byte_roll		; if (hl)==0 last bit was treated, reload
		sbc a,a			; if Cf=1, acc=#ff , else acc=0
		and d			; acc=#0a if #ff, else 0
		add a,h			; acc=#2a ("*") if Cf was 1, else #20 (" ")
		dec e			; Ptrbuf--
		ld l,e			; 
		ld (hl),a		; store char
		call nz,#bb5a		; Don't display the last char
		jr nz,bit_roll		; 
		rst #10			; Try to display (but fail a lot..)
		defw hirom_display	; Display the "reverse" buffer
Raw_Pattern				; start at x=10 >> pattern byte #ff became #e0=ret po
		db #ff,#8f		; Pattern 20 bits / line
		db #e4,#24
		db #24,#95
		db #04,#48
		db #02,#40
		db #4e,#80
		db #53,#39
		db #30,#84
		db #81,#e2
		db #28,0
		db #15,0
		db #40
_end_code

	
