; Vintage Computing Christmas Challenge 2025 - v2b
; Jose Moreno Prieto 'Xeleh' - 03/12/2025

main:
            org     100h
            mov     bl,-9           ; initial row
.row        mov     dl,-9           ; initial column
.col        cmp     dl,9            ; right side overflow?
            jg      .space          ; yes -> print space
            mov     al,bl           ; al = row
            imul    dl              ; al = row * col
            xor     al,ah           ; 
            sub     al,ah           ; al = abs (row * col)
            cmp     al,64           ; diagonal excedent?
            jge     .space          ; yes -> print space
            mov     di,data-3       ; set data pointer
            mov     cl,3+5+1        ; set data length (+3 for offset, +1 for free 0 byte)
            repne   scasb           ; find al in data
            je      .star           ; found? -> print * char
            mov     al,bl           ; al = row
            xor     al,ah           ; 
            sub     al,ah           ; al = abs (row)
            cmp     al,dl           ; diagonal?
            je      .star           ; yes -> print * char
.space      mov     al,' '          ; space char
            jmp     .print          ; print
.star       mov     al,'*'          ; '*' char
.print      int     29h             ; print char in al
            inc     dx              ; next column
            cmp     dl,80-9         ; end column?
            jne     .col            ; no -> loop
            inc     bx              ; next row
            cmp     bl,9+1          ; end row?
            jne     .row            ; no -> loop

; real table: 0,4,7,10,16,30,35
; as the order of the bytes is not important here
; and any value greater than 81 does not affect the result,
; we can get value 10 from [data-3] and value 0 for free
; assuming the code segment is empty

data        db      4,7,16,30,35

%ifdef      debug
            db      0
            waitkey
            ret
%endif
