org 	60000

start:	LD E, 10; line counter
loop1:	LD D, 0
	LD HL, pattern-1
	ADD HL, DE; HL=pattern+E
	LD D, 8; bit counter
	LD A, (HL)
loop2:	RLC A; check bit
	JR NC, nostar
	PUSH AF
	PUSH DE
	CALL print8; print 8 stars (on every snowflake's arm)
	POP DE
	POP AF
nostar:	DEC D
	JR NZ, loop2
	DEC E
	JR NZ, loop1
	RET

print8:	DEC D
	DEC E
	LD A, D; DE = coordinates,  B:=-D, C=-E
	NEG
	LD B, A;
	LD A, E
	NEG
	LD C, A;

	; at x+e, y+d
	LD H, E
	LD L, D
	CALL print1

	; at x+d, y+e
	LD H, D
	LD L, E
	CALL print1

	; at x-d, y+e
	LD H, B
	LD L, E
	CALL print1

	; at x-e, y+d
	LD H, C
	LD L, D
	CALL print1

	; at x-e, y-d
	LD H, C
	LD L, B
	CALL print1

	; at x-d, y-e
	LD H, B
	LD L, C
	CALL print1

	; at x+d, y-e
	LD H, D
	LD L, C
	CALL print1

	; at x+e, y-d
	LD H, E
	LD L, B
	CALL print1

	RET

; print one star, HL = coordinates
print1:	PUSH BC
	LD A, 16; centerx
	ADD A, H
	LD B, A
	LD A, 11; centery
	ADD A, L
	LD C, A
	CALL $200A; set coordinates (coordinates in bc)
	POP BC
	LD A, "*"
	RST 16
	RET

pattern: DB 1, 3, 5, 9, 19, 37, 97, 163, 5, 1

;reverse pattern: DB 1, 5, 163, 97, 37, 19, 9, 5, 3, 1
;1/8 of snowflake
;       1	1
;     101	5
;10100011	163
; 1100001	97
;  100101	37
;   10011	19
;    1001	9
;     101	5
;      11	3
;       1	1