pattern={
    0b0000000001,
    0b0000000101,
    0b0010100011,
    0b0001100001,
    0b0011100101,
    0b0000010011,
    0b0000001001,
    0b0100100101,
    0b0010010011,
    0b1111111111
}

function gb(row, col)
    return (pattern[row+1] >> (9 - col)) & 1
end

function _init()
    t = 0
    angle = 0
    scale = 0
    colors = {8,9,10,11,12,13,14,15,7}
    color_index = 1
end

function _update()
    t += 1/60
    
    if t % 1.5 < 1/60 then
        color_index = (color_index % #colors) + 1
    end
    
    angle = sin(t*0.1) * 0.5

    if scale < 6 then
    	scale += t*0.1
    end
    
end

function _draw()
    cls()
    
    local center_x = 64
    local center_y = 64
	
    for row = 0, 18 do
        for col = 0, 18 do
            local pattern_row, pattern_col
            if row <= 9 then pattern_row = row
            else pattern_row = 18 - row end
            if col <= 9 then pattern_col = col
            else pattern_col = 18 - col end
			
            if gb(pattern_row, pattern_col) == 1 then
                local x = col - 9
                local y = row - 9
                local cos_a = cos(angle)
                local sin_a = sin(angle)
                local rx = x*cos_a - y*sin_a
                local ry = x*sin_a + y*cos_a
                local screen_x = center_x + rx * scale
                local screen_y = center_y + ry * scale
                local color = colors[color_index]
                if ((row * 17 + col + flr(t*30)) % 50) < 2 then
                    color = 7
                    circfill(screen_x, screen_y, 1, 2)
                end
                print("*", screen_x-1, screen_y-1, color)
            end
        end
    end

end