Program Article_Scroller_;

Uses
  Crt, Articles, de;

{$I head.pas}

Const
  speed      = 25;
  x1         = 1;
  y1         = 12;
  x2         = 80;
  y2         = 25;
  YLen       = y2 - y1;
  P_Filled   = '';
  P_Unfilled = '';

Var
  x,y,pos,q         : Integer;
  Bt,Percent,DivNum : Byte;
  Quit,Point        : Boolean;

{----------------------------------------------------------------------}

Procedure Flush_Buffer; Assembler;

Asm
  mov ah,12;
  int 21h;
End;

{----------------------------------------------------------------------}

Procedure OffCursor; Assembler;

Asm
  mov  ax,0100h
  mov  cx,2707h
  int  10h
End;

{----------------------------------------------------------------------}

Procedure OnCursor; Assembler;

Asm
  mov  ax,0100h
  mov  cx,0506h
  int  10h
End;

{----------------------------------------------------------------------}

Procedure Char_Write(a: Char; b: Integer);

Var
  z: Integer;

Begin
  For z := 1 to b Do Write(a);
End;

{----------------------------------------------------------------------}

Procedure Initialize_Article;

Begin
  ClrScr;
  GotoXY(1,1);
  Pos := 1;
  Move(dd_head,Mem[$b800:0000],SizeOf(dd_head));
  Load_Article;
  Window(x1,y1,x2,y2);
  For x := 1 to YLen do
    Begin
      GotoXY(1,x);
      Pipe(a[x]);
    End;
  DivNum := Trunc(Length / YLen);
  Window(1,1,80,25);
End;

{----------------------------------------------------------------------}

Procedure Update_Percent;

Var
  z: Integer;

Begin
  Window(1,1,80,25);
  GotoXY(1,1);
  Point := False;
  Percent := Trunc(((Pos)+(Y2-Y1)) / Length * 100);
  If Pos Mod DivNum = 0 Then Point := True;
  z := Trunc(Percent / 5);
  Write('[');
  Char_Write(P_Filled,z);
  Char_Write(P_Unfilled,20 - z);
  Write(']');
  GotoXY(25,1);
  Write(Percent:3);
  Write('%');
  GotoXY(30,1);
  Write(Pos+Y2-Y1-1:3);
  GotoXY(33,1);
  Write('/',Length);
  Window(x1,y1,x2,y2);
End;

{----------------------------------------------------------------------}

Procedure Up;

Begin
  While (Port[$60] = 72) and (Pos > 1) Do
   Begin
     Delay(speed);
     Flush_Buffer;
     Dec(Pos);
     Update_Percent;
     GotoXY(1,1);
     InsLine;
     GotoXY(1,1);
     Pipe(a[Pos]);
   End;
End;

{----------------------------------------------------------------------}

Procedure Down;

var x : integer;

Begin
  While ((Port[$60] = 80) and (Pos + YLen - 1 < Length)) Do
    Begin
      Delay(speed);
      Flush_Buffer;
      Inc(Pos);
      Update_Percent;
      GotoXY(1,1);
      DelLine;
      GotoXY(1,YLen);
      Pipe(a[Pos + YLen - 1]);
    End;
End;

{----------------------------------------------------------------------}

Procedure PageUp;

Begin
  While (Port[$60] = 73) Do
   For q := 1 to YLen Do
    If (Pos > 1) Then
     Begin
       Flush_Buffer;
       Dec(Pos);
       Update_Percent;
       GotoXY(1,1);
       InsLine;
       GotoXY(1,1);
       Pipe(a[Pos]);
       Delay(5);
     End;
End;

{----------------------------------------------------------------------}

Procedure PageDown;

Begin
  While (Port[$60] = 81) Do
   For q := 1 to YLen Do
    If (Pos + YLen - 1 < Length) Then
     Begin
       Flush_Buffer;
       Inc(Pos);
       Update_Percent;
       GotoXY(1,1);
       DelLine;
       GotoXY(1,YLen);
       Pipe(a[Pos + YLen - 1]);
       Delay(5);
     End;
End;

{----------------------------------------------------------------------}

Procedure HomeKey;

Begin
  While (Pos > 1) Do
   Begin
     Flush_Buffer;
     Dec(Pos);
     Update_Percent;
     GotoXY(1,1);
     InsLine;
     GotoXY(1,1);
     Pipe(a[Pos]);
   End;
End;

{----------------------------------------------------------------------}

Procedure EndKey;

Begin
  While (Pos + YLen - 1 < Length) Do
   Begin
     Flush_Buffer;
     Inc(Pos);
     Update_Percent;
     GotoXY(1,1);
     DelLine;
     GotoXY(1,YLen);
     Pipe(a[Pos + YLen - 1]);
   End;
End;

{----------------------------------------------------------------------}

Procedure Read_Article;

Var
  Quit: Boolean;

Begin
  Quit := False;
  Window(x1,y1,x2,y2);
  Repeat
    Flush_Buffer;
    Update_Percent;
    Port[$60] := 0;
    Repeat Until KeyPressed;
    Case Port[$60] of
       1: Quit := True;
      72: Up;
      80: Down;
      73: PageUp;
      81: PageDown;
      79: EndKey;
      71: HomeKey;
    End;
  Until Quit;
  Window(1,1,80,25);
End;

{----------------------------------------------------------------------}

Begin
  OffCursor;
  Initialize_Article;
  Read_Article;
  OnCursor;
End.