Unit de;

Interface

Uses Dos, Crt;

Procedure HideCsr;
Procedure ShowCsr;
Procedure fg(I: Integer);
Procedure bg(I: Integer);
Procedure Pipe(s: String);
Procedure Pipeln(s: String);
Function I2S(s:string); String;
Function LowCase(a: char): Char;
Function LowString(a: string): String;
Function UpString(a: string): String;
Procedure Flush_Buffer;
Procedure wrt;
Procedure gp(ColorNo : byte; Var R,G,B : byte);
Procedure ResetTextMode;
Procedure sp(ColorNo : byte; R,G,B : byte);
Procedure FadeOut;
Procedure GrabPal;
Procedure Blackout;
Procedure FadeIn;

Implementation

{-----[ Hides the cursor ]------------------------------------------------}

Procedure HideCsr; Assembler;


Asm
  mov  ax,0100h
  mov  cx,2707h
  int  10h
End;

{-----[ endOf HideCsr ]---------------------------------------------------}

{-----[ Shows the cursor ]------------------------------------------------}

Procedure ShowCsr; Assembler;

Asm
  mov  ax,0100h
  mov  cx,0506h
  int  10h
End;

{-----[ endOf ShowCsr ]---------------------------------------------------}

{-----[ shortcut for textcolor ]------------------------------------------}

Procedure fg(I: Integer);

Begin
  TextColor(I);
End;

{-----[ endOf fg ]--------------------------------------------------------}

{-----[ shortcut for textbackground ]-------------------------------------}

Procedure bg(I: Integer);

Begin
  TextBackground(I);
End;


{-----[ endOf bg ]--------------------------------------------------------}

{-----[ Writes string with | color codes ]--------------------------------}

Procedure Pipe(s: String);

Var
  b    : byte;
  c,i  : integer;
  temp : string;

Begin
  b := 1;
  While b <= Length(s) Do
   Begin
     If s[b] = '|' Then
      Begin
        Inc(b);
        temp := Copy(s,b,2);
        Val(temp,c,i);
        If b <= Length(s) Then
         Case c of
           0 : fg(0);
           1 : fg(1);
           2 : fg(2);
           3 : fg(3);
           4 : fg(4);
           5 : fg(5);
           6 : fg(6);
           7 : fg(7);
           8 : fg(8);
           9 : fg(9);
           10: fg(10);
           11: fg(11);
           12: fg(12);
           13: fg(13);
           14: fg(14);
           15: fg(15);
           16: bg(0);
           17: bg(1);
           18: bg(2);
           19: bg(3);
           20: bg(4);
           21: bg(5);
           22: bg(6);
           23: bg(7);
         End;
        Inc(b,2);
      End Else
      Begin
        Write(s[b]);
        Inc(b);
      End;
     End;
   End;

{-----[ endOf Pipe ]------------------------------------------------------}

{-----[ add writeln to pipe ]---------------------------------------------}

Procedure Pipeln(s: String);

Begin
  Pipe(s);
  Writeln;
End;

{-----[ endOf Pipeln ]----------------------------------------------------}

{-----[ Lowercases a character ]------------------------------------------}

Function LowCase(a: char): Char;

Begin
  If (a >= 'A') and (a <= 'Z') Then a := Chr(Ord(a)+32);
  LowCase := a;
End;

{-----[ endOf LowCase ]----------------------------------------------------}

{-----[ Lowcases an entire string ]---------------------------------------}

Function LowString(a: string): String;

Var
  X : integer;
  b : string;
Begin
  b:='';
  For x :=1 to length(a) do
    b:=concat(b,lowcase(a[x]));
  lowstring:=b;
End;

{-----[ endOf LowString ]-------------------------------------------------}

{-----[ turns an integer into a string ]----------------------------------}

Function i2s(I: Longint): String;

Var
  s: String[11];

Begin
  Str(i, s);
  i2s := s;
End;

{-----[ endOf i2s ]-------------------------------------------------------}

{-----[ Upcases an entire string ]----------------------------------------}
Function UpString(a: string): String;

Var
  X : integer;
  b : string;
Begin
  b:='';
  For x :=1 to length(a) do
    b:=concat(b,upcase(a[x]));
  upstring:=b;
End;

{-----[ endOf UpString ]--------------------------------------------------}

{-----[ Clears the keyboard buffer ]--------------------------------------}

Procedure Flush_Buffer; Assembler;

Asm
  mov ah,12;
  int 21h;
End;


{-----[ Start of groovy fade routines ]-----------------------------------}

{---[ taken from fade2.pas,  I changed the code to my style though =) ]---}

Var
  Pall,Pall2 : Array[0..255,1..3] of byte;

Procedure wrt; assembler;

label
  l1, l2;

asm
  mov dx,3DAh
  l1:
    in al,dx
    and al,08h
    jnz l1
  l2:
    in al,dx
    and al,08h
    jz  l2
end;

Procedure gp(ColorNo : byte; Var R,G,B : byte);

Begin
  Port[$3c7] := ColorNo;
  R := Port[$3c9];
  G := Port[$3c9];
  B := Port[$3c9];
End;

Procedure ResetTextMode; Assembler;

asm
  mov        ax,03h
  int        10h
end;

Procedure sp(ColorNo : byte; R,G,B : byte);

Begin
  Port[$3c8] := ColorNo;
  Port[$3c9] := R;
  Port[$3c9] := G;
  Port[$3c9] := B;
End;


Procedure FadeOut;

Var
  lxpy1,lxpy2:integer;
  tmp : Array [1..3] of byte;

Begin
  For lxpy1:=1 to 64 do Begin
    wrt;
    For lxpy2:=1 to 255 do Begin
      gp(lxpy2,tmp[1],tmp[2],tmp[3]);
      If tmp[1]>0 then dec(tmp[1]);
      If tmp[2]>0 then dec(tmp[2]);
      If tmp[3]>0 then dec(tmp[3]);
      sp(lxpy2,tmp[1],tmp[2],tmp[3]);
    End;
  End;
End;

Procedure GrabPal;

Var loop1:integer;

Begin
  For loop1 := 0 to 255 do
    gp(loop1,pall2[loop1,1],pall2[loop1,2],pall2[loop1,3]);
End;


Procedure Blackout;
  { This procedure blackens the screen by setting the pallette values of
    all the colors to zero. }
Var
  loop1 : integer;

Begin
  wrt;
  For loop1 := 0 to 255 do
    sp(loop1,0,0,0);
End;

Procedure FadeIn;

Var loop1,loop2:integer;
    tmp : Array [1..3] of byte;

Begin
  For loop1:=1 to 64 do
    Begin
      wrt;
      For loop2:=0 to 255 do
        Begin
          Gp (loop2,tmp[1],tmp[2],tmp[3]);
          If tmp[1]<Pall2[loop2,1] then inc(tmp[1]);
          If tmp[2]<Pall2[loop2,2] then inc(tmp[2]);
          If tmp[3]<Pall2[loop2,3] then inc(tmp[3]);
          sp (loop2,tmp[1],tmp[2],tmp[3]);
        End;
    End;
End;

{-----[ End of groovy fade routines ]-------------------------------------}
Begin
  GrabPal;
End.
