#!/usr/bin/python3

#                                                              /\
#                                                           ___/  \___
# _______________________  >> dEMONIC pRODUCTIONZ // 2023  /___ o0 ___\__________
# \_______         _____/_______________        _____________/__/\__\   /_______/
#   /    /    /   ___/__\______        /________\________    /____\    /     /jp
#  /    /    /   /            /  /    /   _________/   /    /     /   '     /
# /_________/___________/    /  /    /    /     /     /    /_____/_________/
#                      /____/__/_____    /     ______/____/
#                                   \_________/

#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
   
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
   
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
#  MA 02110-1301, USA.
   
#  READ THE INCLUDED GPL3 LICENSE FILE FOR MORE INFORMATION

import sys, os
from datetime import datetime
import time, socket, imaplib, traceback
import struct
import smtplib, ssl
import textwrap
import json
from imap_tools import A, MailBox, MailboxLoginError, MailboxLogoutError
from email.message import EmailMessage
import subprocess

import logging
from logging.handlers import RotatingFileHandler

#============== CONFIGURE THESE TO YOUR SETTINGS ======================
bbsname = 'Your BBS Name plz!'
#email server settings
imap_server = 'imap.gmx.com'  #imap server
check_email = 'user@gmx.com'  #email login for imap server
check_email_password = 'password' #password for imap server
reconnect = True
reconnect_time = 60
#smtp settings for outgoing mail. account information
smtp_server = "mail.gmx.com"  #smtp server for outgoing emails
smtp_port = 587
sender_email = "user@gmx.com"  #login for smtp
send_password = 'password'   #password for smtp server
#email address that will receive responses
#response_email = 'xqtr@gmx.com'
#bbs settings
bbspath = '/home/pi/mystic'  #do not add a slash at the end
bbsupload = '/home/pi/mystic/files/upload'  #do not add a slash at the end
datadir = bbspath+os.sep+'data'+os.sep
#echoarea list file, full path/name
echofile=''
#chose your bbs software
bbs_software = 'mystic'
#access restrictions
#process mails only with the following subject. leave empty to process all
subjectid = 'bbs'
#process emails only from these email accounts. leave empty to process all
accessmail = []
#max emails per user/account/email address
maxmails = 10
#origin/footer text.
footer='\n---------------------------------------------------\n...send with bBS mAIL dEMON'
#time interval to clear some logging info, in seconds
time_interval = 6*60*60

#============== DO NOT CHANGE BELOW THIS POINT ========================
#program variables
appdir = os.path.dirname(sys.argv[0])
msgprocess = None
#time the server started
start_time = datetime.now()
#dictionary to keep which users sent emails and how many. if they reach 
#the max email limit, new emails from them will be rejected
received = {}


# general functions
def byte2str(v):
    s=''.join(str(v))
    return s[2:-1]
    
def unpackdt(t):
    year = 1980 + (t >> 25)
    month = (t & 0b00000001111000000000000000000000) >> 21
    day = (t & 0b00000000000111110000000000000000) >> 16
    hour = (t & 0b00000000000000001111100000000000) >> 11
    minute = (t & 0b00000000000000000000011111100000) >> 5
    second = (t & 0b00000000000000000000000000011111) * 2
    return datetime(year, month, day, hour, minute, second)

def sendmail(user,subject,text):
    global smtp_server
    global sender_email
    global send_password
    global smtp_port
    receiver_email = user
    
    msg = EmailMessage()
    msg.set_content(text)
    msg["Subject"] = subject
    msg["From"] = sender_email
    msg["To"] = user
    context=ssl.create_default_context()
    with smtplib.SMTP(smtp_server, smtp_port) as server:
        #server.set_debuglevel(1)
        #server.ehlo()  # Can be omitted
        server.starttls(context=context)
        #server.ehlo()  # Can be omitted
        server.login(sender_email, send_password)
        server.send_message(msg)
        #server.sendmail(sender_email, receiver_email, message)
        server.quit    

# ---------------------------------------------------------------------    
# mystic bbs functions
# ---------------------------------------------------------------------

def mystic_oneliners():
    f = open(datadir+"oneliner.dat","rb") # open the file
    sf = '@b79sb30s'
    s = struct.calcsize (sf)
    size = struct.calcsize(sf)
    i = 0
    d = 0
    out = ""
    while True:
        line = f.read(s) # read n bytes as the record size
        if len(line) < s:
            break
        i,onel,d,name = struct.unpack(sf,line)  # assign values to variables
        out +=byte2str(name[0:d]).ljust(20)+byte2str(onel[0:i]).ljust(20)+'\n'
    return out

def mystic_lastcallers():
    f = open(datadir+"callers.dat","rb")
    sf = '<L?b15sb50sBIb30sb25sb30scb35sb30s663c'
    s = struct.calcsize (sf)
    size = struct.calcsize(sf)
    i = 0
    d = 0
    out = ""
    while True:
        line = f.read(s)
        if len(line) < s:
            break
        res = struct.unpack(sf,line)
        date = str(unpackdt(res[0])) #date
        name = ''.join(str(res[9][0:res[8]])).strip("b'") #username
        city = ''.join(str(res[11][0:res[10]])).strip("b'") #city
        address = ''.join(str(res[13][0:res[12]])).strip("b'") #address
        gender = ''.join(str(res[14]).strip("b'"))  # gender
        email =''.join(str(res[16][0:res[15]])).strip("b'") #email
        out += name.ljust(20)+date+' '+gender+' '+city.ljust(20)+address.ljust(30)+email+'\n'
    #out = 'Subject: Last Callers\n'+out
    return out
    
def mystic_help():
  global bbs_software
  text = 'This BBS is based on '+bbs_software.upper()+' BBS software.\n\nSupported Commands:\n'
  text +='=list, =echo, =areas :\n'
  text +='   Get a list of all ECHOAREAS in the BBS\n'
  text +='=count :\n'
  text +='   See how many commands you can send until next server reset.\n'
  text +='=oneliners, =oneliner , =1l :\n'
  text +='   Sends the list of Oneliners from the BBS\n'
  text +='=lastcallers, =lastcall , =1last :\n'
  text +='   Sends the list of last users called the BBS\n'
  text +='=post :\n'
  text +='   Write a post to one or more echoareas. See below.\n'
  text +='   Syntax:\n'
  text +='   =post\n'
  text +='   +<echoarea_tag>\n'
  text +='   <from>\n'
  text +='   <to>\n'
  text +='   <subject>\n'
  text +='   <text of message>\n'
  text +='   Example:\n'
  text +='   =post\n'
  text +='   +fsx_gen\n'
  text +='   xqtr\n'
  text +='   All\n'
  text +='   New Mod!\n'
  text +='   A new mod has been released! Check Another Droid to get it!\n\n\n'
  return text  
    
def mystic_readmsgbase(i,filename):
  if os.path.exists(filename) == False:
    return [-1,None]
  size = os.path.getsize(filename)
  fbaserec = "<Hx60sx13sx60sx40sx80sBBBx30sx30sx30sx30sx30sx30sBBBBBBx50sBBIHx20sx20sx20sIIx40sIH136B"
  sf = struct.calcsize(fbaserec)
  items = size // sf
  if i > items:
    return [-3,None]
  f = open(filename, 'rb')
  try:
    f.seek((i-1)*sf,1)
  except:
    return [-2,None]
  fbaseb = f.read(sf)
  s = struct.unpack(fbaserec,fbaseb)
  f.close()
  res = {}
  res['index'] = s[0]
  res['name'] = byte2str(s[1]).replace('\\x00','')
  res['filename'] = byte2str(s[4]).replace('\\x00','')
  res['listacs']  = byte2str(s[9]).replace('\\x00','')
  res['readacs']  = byte2str(s[10]).replace('\\x00','')
  res['echotag']  = byte2str(s[31]).replace('\\x00','')
  return [0,res]

def mystic_msgbases():
    mbases=[]
    i = 1
    r = mystic_readmsgbase(i,bbspath+os.sep+'data'+os.sep+'mbases.dat')
    while r[0] == 0:
        if r[1]['echotag'] != "":
            item = [r[1]['echotag'],r[1]['index'],r[1]['name']]
            mbases.append(item)
        i += 1
        r = mystic_readmsgbase(i,bbspath+os.sep+'data'+os.sep+'mbases.dat')
    return(sorted(mbases, key=lambda x: x[0]))
        
def mystic_findbasebyname(name,mbases):
    for i in range(len(mbases)):
        if name.lower().strip()==mbases[i][0].lower():
            return mbases[i][1]
    return -1  
    
def mystic_bbspost(idlist,afrom,ato,asubject,text):
  for i in range(len(idlist)):
    s = ""
    s += '[General]\n'
    s += 'PostTextFiles = true\n'
    s += 'logfile = mutil.log\n'
    s += 'loglevel = 3\n'
    s += 'logtype = 1\n'
    s += 'maxlogfiles = 31\n'
    s += 'maxlogsize = 1500\n'

    s += '[PostTextFiles]\n'
    s += 'totalfiles = 1\n'
    s += 'file1_name    = '+bbspath+os.sep+'mbbspost.tmp\n'
    s += 'file1_baseidx = '+str(idlist[i])+'\n'
    s += 'file1_from    = '+afrom+'\n'
    s += 'file1_to      = '+ato+'\n'
    s += 'file1_subj    = '+asubject+'\n'
    s += 'file1_addr    = 21:1/111\n'
    s += 'file1_delfile = false\n'
    with open(bbspath+os.sep+'mbbspost.ini', 'w', encoding='ascii') as f:
      f.write(s)
    with open(bbspath+os.sep+'mbbspost.tmp', 'w', encoding='ascii') as f:
      #text = textwrap.fill(text, width=75)
      text = "\n".join("\n".join(textwrap.wrap(x,width=75)) for x in text.splitlines())
      f.write(text)
    log.info('Sending post to BBS with info: Echo:'+str(idlist[i])+' From:'+afrom+' To:'+ato+' Subj:'+asubject)
    cmd = 'cd '+bbspath+';./mutil mbbspost.ini'
    ret = subprocess.run(cmd,shell=True)    
    log.info('subprocess returned: '+str(ret))
    os.remove(bbspath+os.sep+'mbbspost.ini')
    os.remove(bbspath+os.sep+'mbbspost.tmp')
    time.sleep(5)


def mystic_process_email(msg, log):
  global bbsname
  cmdfound = False
  txt = msg.text.splitlines()
  body = ''
  index = 0
  while index<len(txt):
    line = txt[index].upper().strip()
    if line.startswith('#'): pass
    elif line == '': pass
    elif line == '=LIST' or line == '=ECHO' or line == '=AREAS':
      log.info('Sending Msg.Bases list to: '+msg.from_)
      cmdfound = True
      body += 'List of Echo Areas\n'
      body += '------------------\n'
      if os.path.isfile(echofile):
        with file(echofile,'r') as ef:
          body=ef.readlines()
      else:
        mbases = mystic_msgbases()
        for d in range(len(mbases)):
            body += mbases[d][0]+' - '+mbases[d][2]+'\n'
    elif line == '=COUNT':
      cmdfound = True
      log.info('COUNT command from address: '+msg.from_)
      body += '\n\nYou have sent '+str(received[msg.from_.upper()])+' emails. The maximum number you can send is '+str(maxmails)+'. You can send '+str(maxmails - received[msg.from_.upper()])+' more email commands.\n\n'
    elif line == '=ONELINERS' or line == '=ONELINER' or line == '=1L':
      cmdfound = True
      log.info('Sending Oneliners to: '+msg.from_)
      body += '    OneLiners     \n'
      body += '------------------\n'
      body += mystic_oneliners()
    elif line == '=LASTCALLERS' or line == '=LASTCALL' or line == '=LAST':
      cmdfound = True
      body += '    LastCallers    \n'
      body += '-------------------\n'
      log.info('Sending Lastcallers to: '+msg.from_)
      body += mystic_lastcallers()
    elif line == '=HELP':
      cmdfound = True
      log.info('Sending Help to: '+msg.from_)
      body += mystic_help()
    elif line == '=POST': 
      areas = []
      index+=1
      line = txt[index].upper().strip()
      #get echoareas to post message
      mbases = mystic_msgbases()
      while line[0]=='+':
        areas.append(mystic_findbasebyname(line[1:],mbases))
        index+=1
        line = txt[index].upper().strip()
      if len(areas)<=0: pass
      post_from = txt[index]; index+=1
      post_to = txt[index]; index+=1
      post_subj = txt[index]; index+=1
      post_body = ''
      while index < len(txt):
        post_body += txt[index]+'\n'
        index += 1
      post_body += footer
      mystic_bbspost(areas,post_from,post_to,post_subj,post_body)
      cmdfound = True
      body += 'Post uploaded to BBS.'
      break
    
    index += 1
      
  if cmdfound:
    body=body+footer
    sendmail(msg.from_,bbsname+' - REPLY',body)
  else:
    body=body+'No command processed. Did you mispell something?'
    sendmail(msg.from_,bbsname+' - REPLY',body)
    
# ---------------------------------------------------------------------    
# Enigma bbs functions
# ---------------------------------------------------------------------    

def enigma_help():
  global bbs_software
  text = 'This BBS is based on '+bbs_software.upper()+' BBS software.\n\nSupported Commands:\n'
  text +='=list, =echo, =areas :\n'
  text +='   Get a list of all ECHOAREAS in the BBS\n'
  text +='=count :\n'
  text +='   See how many commands you can send until next server reset.\n'
  text +='=post :\n'
  text +='   Write a post to one or more echoareas. See below.\n'
  text +='   Syntax:\n'
  text +='   =post\n'
  text +='   +<echoarea_tag>\n'
  text +='   <from>\n'
  text +='   <to>\n'
  text +='   <subject>\n'
  text +='   <text of message>\n'
  text +='   Example:\n'
  text +='   =post\n'
  text +='   +fsx_gen\n'
  text +='   xqtr\n'
  text +='   All\n'
  text +='   New Mod!\n'
  text +='   A new mod has been released! Check Another Droid to get it!\n\n\n'
  return text

def enigma_bbspost(idlist,afrom,ato,asubject,text):
  for i in range(len(idlist)):
    s = {}
    s['from']=afrom
    s['to']=ato
    s['subject']=asubject
    s['areatag']=str(idlist[i])
    s['body']="\n".join("\n".join(textwrap.wrap(x,width=75)) for x in text.splitlines())
    
    with open(bbspath+os.sep+"mbbspost.tmp", "w", encoding='ascii') as outfile:
      json.dump(s, outfile)
    
    log.info('Sending post to BBS with info: Echo:'+str(idlist[i])+' From:'+afrom+' To:'+ato+' Subj:'+asubject)
    cmd = 'cd '+bbspath+';./oputil post mbbspost.tmp'
    ret = subprocess.run(cmd,shell=True)    
    log.info('subprocess returned: '+str(ret))
    os.remove(bbspath+os.sep+'mbbspost.tmp')
    time.sleep(5)

def enigma_process_email(msg, log):
  global bbsname
  cmdfound = False
  txt = msg.text.splitlines()
  body = ''
  index = 0
  while index<len(txt):
    line = txt[index].upper().strip()
    if line.startswith('#'): pass
    elif line == '': pass
    elif line == '=COUNT':
      cmdfound = True
      log.info('COUNT command from address: '+msg.from_)
      body += '\n\nYou have sent '+str(received[msg.from_.upper()])+' emails. The maximum number you can send is '+str(maxmails)+'. You can send '+str(maxmails - received[msg.from_.upper()])+' more email commands.\n\n'
    elif line == '=HELP':
      cmdfound = True
      log.info('Sending Help to: '+msg.from_)
      body += enigma_help()
    elif line == '=POST': 
      areas = []
      index+=1
      line = txt[index].upper().strip()
      #get echoareas to post message
      mbases = mystic_msgbases()
      while line[0]=='+':
        areas.append(mystic_findbasebyname(line[1:],mbases))
        index+=1
        line = txt[index].upper().strip()
      if len(areas)<=0: pass
      post_from = txt[index]; index+=1
      post_to = txt[index]; index+=1
      post_subj = txt[index]; index+=1
      post_body = ''
      while index < len(txt):
        post_body += txt[index]+'\n'
        index += 1
      post_body += footer
      mystic_bbspost(areas,post_from,post_to,post_subj,post_body)
      break
    
    index += 1
      
  if cmdfound:
    body=body+footer
    sendmail(msg.from_,bbsname+' - REPLY',body)
  else:
    body=body+'No command processed. Did you mispell something?'
    sendmail(msg.from_,bbsname+' - REPLY',body)

# Setup the log handlers to stdout and file.
log = logging.getLogger('bbsmaild')
log.setLevel(logging.DEBUG)
formatter = logging.Formatter('%(asctime)s | %(levelname)s | %(message)s')
handler_stdout = logging.StreamHandler(sys.stdout)
handler_stdout.setLevel(logging.DEBUG)
handler_stdout.setFormatter(formatter)
log.addHandler(handler_stdout)
handler_file = RotatingFileHandler(
	'bbsmaild.log',
	mode='a',
	maxBytes=1000000,
	backupCount=9,
	encoding='UTF-8',
	delay=True
	)
handler_file.setLevel(logging.DEBUG)
handler_file.setFormatter(formatter)
log.addHandler(handler_file)

if bbs_software == 'mystic':
  msgprocess = mystic_process_email
elif bbs_software == 'enigma':
  msgprocess = enigma_process_email
  
log.info('BBS software is: '+bbs_software)  

log.info('Connecting...')
cntresp = 0
while True:
  try:
    with MailBox(imap_server).login(check_email, check_email_password) as mailbox:
      log.info('Connected!')
      while True:
        mailbox.idle.start()
        responses = mailbox.idle.poll(timeout=60) # IDLE for 60 seconds
        mailbox.idle.stop()
        #check if we reach the time interval to clear receivers buffer
        delta = datetime.now() - start_time
        if delta.total_seconds() >= time_interval:
          received.clear()
          log.info('Cleared receivers buffer. Reseting time.')
          start_time = datetime.now()
        log.info('Checking server response...')
        if responses or cntresp>5:
          if cntresp>5: cntresp=0
          for msg in mailbox.fetch(A(seen=False)):
            log.info('Found BBS mail command. Processing...')
            if msg.subject.upper()==subjectid.upper() or subjectid=='':
              log.info('Subject matched or no subject restriction.')
              if accessmail==[] or (msg.from_.upper() in [x. upper() for x in accessmail]):
                log.info('eMail matched or no email restriction.')
                if msg.from_.upper() in received:
                  received[msg.from_.upper()]+=1
                  if received[msg.from_.upper()]<=maxmails:
                    msgprocess(msg,log)
                  else:
                    log.error('Maximum mail limit for address: '+msg.from_+'. Msg discarded')
                else:
                  received[msg.from_.upper()]=1
                  msgprocess(msg,log)
              else:
                log.error('New mail discarded, email address did not match.')
            else:
              log.error('New email discarded, subject did not match.')
        else:
          log.info('No new emails.')
          cntresp+=1
  except:
    #log.error(f'{e} - {traceback.format_exc()} - Reconnecting in a minute. . .')
    log.error(f'{traceback.format_exc()} - Reconnecting in a minute. . .')
    if reconnect:
      time.sleep(reconnect_time)
    else:
      break
log.info('Closed connection.')

#         _____         _   _              ____          _   _ 
#        |  _  |___ ___| |_| |_ ___ ___   |    \ ___ ___|_|_| |        8888
#        |     |   | . |  _|   | -_|  _|  |  |  |  _| . | | . |     8 888888 8
#        |__|__|_|_|___|_| |_|_|___|_|    |____/|_| |___|_|___|     8888888888
#                                                                   8888888888
#                DoNt Be aNoTHeR DrOiD fOR tHe SySteM               88 8888 88
#                                                                   8888888888
# /: HaM RaDiO   /: ANSi ARt!     /: MySTiC MoDS   /: DooRS         '88||||88'
# /: NeWS        /: WeATheR       /: FiLEs         /: zer0net        ''8888"'
# /: GaMeS       /: TeXtFiLeS     /: PrEPardNeSS   /: FsxNet            88
# /: TuTors      /: bOOkS/PdFs    /: SuRVaViLiSM   /:            8 8 88888888888
#                                                              888 8888][][][888
#   TeLNeT : andr01d.zapto.org:9999 / ssh: 8888                  8 888888##88888
#   SySoP  : xqtr                   eMAiL: xqtr@gmx.com          8 8888.####.888
#   DoNaTe : https://paypal.me/xqtr                              8 8888##88##888

