#!/bin/bash

#                                                              /\
#                                                           ___/  \___
# _______________________  >> dEMONIC pRODUCTIONZ // 2023  /___ o0 ___\__________
# \_______         _____/_______________        _____________/__/\__\   /_______/
#   /    /    /   ___/__\______        /________\________    /____\    /     /jp
#  /    /    /   /            /  /    /   _________/   /    /     /   '     /
# /_________/___________/    /  /    /    /     /     /    /_____/_________/
#                      /____/__/_____    /     ______/____/
#                                   \_________/

#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
   
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
   
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
#  MA 02110-1301, USA.
   
#  READ THE INCLUDED GPL3 LICENSE FILE FOR MORE INFORMATION

bbsmail='adbbs@gmx.com'
subjectid="bbs"
fromuser='You'
touser='All'

stype="$(dialog \
--stdout \
--output-separator "~" \
--radiolist "Choose from following" 0 0 0 \
"LASTCALL" "List of Last BBS Callers" off \
"ONELINE" "List of Oneliners" off \
"COUNT" "Get how many commands you can give" off \
"POST" "Make an EchoArea Post" off \
"AREAS" "Get all BBS echo areas" off \
"HELP" "Get list with commands" off)"

if [ $? -ne 0 ];
then
  exit
fi

case $stype in
  '~LASTCALL') body="=LAST";;
  '~ONELINE') body="=1L";;
  '~AREAS') body="=AREAS";;
  '~COUNT') body="=COUNT";;
  '~HELP') body="=HELP";;
  '~POST')

email="$(dialog --ok-label "Submit" \
--stdout \
--backtitle "eMail Form" \
--title " Send... " \
--output-separator "~" \
--form "Fill the fields..." \
10 50 0 \
"Subject:" 1 1 "" 1 10 30 50 \
"  From:" 2 1 $fromuser 2 10 30 50 \
"    To:" 3 1 "All" 3 10 30 80)"

if [ $? -ne 0 ];
then
  exit
fi

ss=$(echo "$email" | cut -f 1 -d'~')
ff=$(echo "$email" | cut -f 2 -d'~')
tt=$(echo "$email" | cut -f 3 -d'~')
#bb=$(echo "$email" |sed 's/,/ /g' | cut -f 4 -d'~')

#bb=$(echo "$bb" | sed ':a;N;$!ba;s/\\\n/,/g')
#echo "$bb"

if [ -z "$ff" ] || [ -z "$tt" ] || [ -z "$ss" ]
then
   echo "All fields should be filled. Try again."
   exit
fi

touch $HOME/output.tmp
dialog --stdout --title " Edit Text " --editbox $HOME/output.tmp 20 78 > $HOME/output.tmp

if [ $? -ne 0 ];
then
  exit
fi

bb="$(cat $HOME/output.tmp)"
rm $HOME/output.tmp

areas="$(dialog --backtitle "Test" \
--stdout \
--output-separator "~" \
--title "Checkbox test " \
--checklist "Choose from following"  0 0 0 \
"XGENCHAT" "General Chat Areas of FSX,Dore and 0N" off \
"XCODEBBS" "BBS Coding areas for FSX,Dore and 0N" off \
"0N-ANARC" "anarchy/chaos/drug" off \
"0N-BBS" "bbs/art scene" off \
"0N-CHAT" "general chat" off \
"0N-CODE" "coding/demos" off \
"0N-DPRI" "INVISIBLE" off \
"0N-DPUB" "Demonic Group Public" off \
"0N-ENTRT" "entertainment" off \
"0N-HACKN" "hacking/security" off \
"0N-INFO" "zer0net info" off \
"0N-NEWS" "scene/world news" off \
"0N-PHRKN" "phreaking/telephony" off \
"0N-SYSOP" "Sysops Only" off \
"0N-WAREZ" "warez/crack scene" off \
"AGN_ADSS" "Base and Network Adsg" off \
"AGN_ARTS" "Art/Demo Scene" off \
"AGN_BBSS" "BBS Discussion" off \
"AGN_DEVS" "Soft. Development" off \
"AGN_GENS" "General Chaton" off \
"AGN_HUBS" "Hub Statstedon" off \
"AGN_NETMAIL" "AGR:Netmail" off \
"AGN_NIXS" "Unix Relate" off \
"AGN_SYSS" "Sysopselatedon" off \
"AGN_TSTS" "Testing" off \
"DN-ADDS" "BBS Adds" off \
"DN-ADMI" "Admin" off \
"DN-ART" "ANSI/ASCII Art" off \
"DN-BBS" "BBS Software" off \
"DN-CHAT" "General Discussion" off \
"DN-CODE" "Programming" off \
"DN-DOORS" "DOORs" off \
"DN-FILE" "File Announcements" off \
"DN-HTML" "Web Design" off \
"DN-INET" "BBSes And Internet" off \
"DN-MODD" "Software MODs" off \
"DN-MPL" "Mystic Progr. Lang. (MPL)" off \
"DN-MYSTIC" "Mystic BBS (Software)" off \
"DN-NIXPI" "Linux & RaspberryPi" off \
"DN-OS" "Operating Systems" off \
"FSX_ADS" "BBS Ads" off \
"FSX_ARTS" "ArtsARTS" off \
"FSX_BBS" "BBS Support and Develop." off \
"FSX_BOT" "BOTs And Advertisements" off \
"FSX_CRY" "Cryptography" off \
"FSX_DAT" "FsxNet DAT" off \
"FSX_DIY" "Do It Yourself (DIY)" off \
"FSX_ENG" "Enigma BBS Software" off \
"FSX_ESP" "Spanish General Chat" off \
"FSX_FIL" "File Announcements" off \
"FSX_FOOD" "Food and Drinks" off \
"FSX_GAMING" "Gaming" off \
"FSX_GARDENING" "Gardening" off \
"FSX_GEN" "General Chat" off \
"FSX_HAM" "HAM Radio" off \
"FSX_MAG" "Magica BBS (Software)" off \
"FSX_MUSIC" "MusicUSIC" off \
"FSX_MYS" "Mystic BBS (Software)" off \
"FSX_NET" "FSX Network Troubleshooting" off \
"FSX_PKT" "Packet Radio / Read Only!" off \
"FSX_RETRO" "Retro Computing/Gaming" off \
"FSX_SPACE" "Space and Science" off \
"FSX_SPORTS" "Sports" off \
"FSX_STA" "Net Statistics" off \
"FSX_TRANSPORT" "Cars, Bikes and Planes..." off \
"FSX_TST" "Test Area" off \
"FSX_VIDEO" "Movies, TV Series, Shows" off)"

if [ $? -ne 0 ];
then
  exit
fi

if [ -z "$areas" ] 
then
   echo "You have to select an area to post the message! Try again."
   exit
fi

echo $areas

case $areas in
  '~XGENCHAT') postareas="+0N-CHAT
+FSX_GEN
+DN-CHAT";;
  '~XCODEBBS') postareas="+0N-CODE
+FSX_BBS
+DN-CODE";;
  *)  old_ifs="$IFS"
      IFS="~"
      postareas=$(for i in $areas; do
      #xx=$(echo $i|cut -f2 -d"~")
      echo +$i
      #echo +$xx
      IFS="$old_ifs"
      done)
      postareas=$(echo $postareas | sed 1d);;
esac


body="=post
$postareas
$ff
$tt
$ss
$bb";;

  *) exit;;
esac

# use for GMAIL app
#am start --user 0 -a android.intent.action.SEND -t "text/plain" \
    #-n com.google.android.gm/.ComposeActivityGmail
    
am start --user 0 -a android.intent.action.SEND -t "text/plain" \
    -n com.fsck.k9/.activity.MessageCompose \
    --esa android.intent.extra.EMAIL "$bbsmail" \
    --es android.intent.extra.TEXT "$body" \
    --es android.intent.extra.SUBJECT "$subjectid"

