(*
 ==========================================================================
   File: RCSPAUSE.MPS
   Desc: Animated pause engine for Mystic BBS v1.12A46+
 Author: Black Panther(RCS)

   Based on the work of:

   File: G-PAUSE.MPS
   Desc: Animated pause engine for Mystic BBS v2.0
 Author: g00r00
 ==========================================================================

 INSTALLATION:

   1) Copy RCSPAUSE.MPS and the included RCSPAUSE.TX? and RCSPAUSE.AN? files 
      into a directory or the BBS scripts directory and compile it using MPLC
      or MIDE.
   2) Copy of prompt files into a subdirectory of your scripts directory, it
      defaults to scripts/anipause
   3) Set your system pause prompt to execute this program, this is done
      by loading MCFG -> Theme Editor -> Edit Prompts and changing prompt
      #022 to look like this:

        !rcspause              (if rcspause is in your scripts directory)
        !c:\mybbs\rcspause     (if rcspause is in its own directory)

 PROMPT FILE NAMES:

   The engine allows for unlimited different animated prompts, which will
   be selected at random for each pause prompt. The engine excepts any file
   names currently in the scripts/anipause directory.

 MAKING YOUR OWN PROMPTS:

   Each prompt file can either be a text file or an ANSI file.  The first
   line is the delay time, which is the amount of time the engine will delay
   after displaying each frame of animation.  It is not recommended that you
   go much over 200 on this value as it will make your prompt seem sluggish.

   The following lines are each one frame of animation.  Use the included
   prompts as a guideline if you still need help and you should be good to
   go.  There is a maximum of 200 frames of animation, and I think that
   will easily be enough.

 LICENSE:

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
   MA 02110-1301, USA.
   
 HISTORY:

   - 12/20/02: Version 1 released (initial release by g00r00)
   - 04/29/20: Version 2 released (Ported to Mystic BBS v1.12 by g00r00)
   - 11/09/20: Version 3 released for testing (Updated by RCS)
   - 11/11/20: Version 3.1 released
   - 11/15/20: Version 3.2 released
   - 11/17/20: Version 3.3 released
   - 12/08/20: Version 3.5 released

 ==========================================================================

   * Version 3.0: Black Panther(RCS) <dan@castlerockbbs.com>
   - Updated prompt number in instructions
   - Updated prompt number for timeout
   - Added key-press function to pass key back to Mystic
   - Added ability to specify prompt to be displayed on command line (optional)
   - Moved prompts to separate directory
   - Removed file name restrictions
   - Changed Max-frames to 200
   - Now reads ANSI files and TXT files. Extension doesn't matter
   - Number of prompts is theoretically unlimited
   - Added logging to indicate inability to find prompt files
   - Added Debug logging via boolean
   
   * Version 3.1: Black Panther(RCS) <dan@castlerockbbs.com>
   - Set subdirectory as const variable
   - Removed the cursor from being visible during execution of MPL
       (This will depend on which terminal is used)
   - Removed inactivity timeout if Mystic is set for 0
   - Included putting visible prompt back on screen if user times out
   - Added check to not read sauce info from ANSI files
       (Don't use PabloDraw to create ANSI files)
   - Removed separate variable for file extension as it's unneeded
   - Change cursor colors when exiting
                       
   * Version 3.2: Black Panther(RCS) <dan@castlerockbbs.com>
   - Added const for X,Y axis starting point
   
   * Version 3.3: Black Panther(RCS) <dan@castlerockbbs.com>
   - Added option for setting the X,Y starting point
   - Forced a writeln to hopefully not start in middle of screen

   * Version 3.4: Zip (Star Collision BBS) <rcs@castlerockbbs.com>
   - Perform newline before prompt if not at leftmost column (line contains something)
   - Allow X and Y axis to be set to 0 to skip that particular positioning

   * Version 3.4: Zip (Star Collision BBS) <rcs@castlerockbbs.com>
   - Newline before prompt moved so it works with ASCII, too

   * Version 3.4: Zip (Star Collision BBS) <rcs@castlerockbbs.com>
   - Simplified positioning code
   - Ensuring 2-position |[X##/|[Y## codes for X/Y positioning
   - Using WhereY for Y positioning in loop

   * Version 3.5: RCS Development Team <rcs@castlerockbbs.com>
   - Updated copyright information to reflect the entire team working on these
     mods, as opposed to an individual.
   - Cleaned up code for each of the 50+ prompts. This should help eliminate any
     issues with the prompts trying to wrap to the next line.
   - Renamed all of the prompts so there is some continuity. They are now
     text files named rcspause.tx# and ansi files are rcspause.an#, where
     # is either a letter or number.
*)

Uses CFG

Const
  PROG_NAME        = 'RCS Animated Prompts'
  PROG_VER         = '3.5(RCS)';                   // VERSION INFO

  PromptAsciiPause = '-<:[Press any key]:>-';      // FOR PEOPLE WITH NO ANSI

  MaxFrames        = 200;                          // MAX FRAMES PER FILE
  SubDirectory     = 'anipause'                    // Sub-Directory for prompt files
  X_AXIS           = 1                             // Starting X axis (0 to disable X positioning)
  Y_AXIS           = 37                            // Starting Y axis (0 to disable Y positioning)

Var
  Set_POS        : Boolean=false   // Set to true to assign position on screen
  Debug          : Boolean=false   // Debug logging on screen and into node#.log file
  Count          : Byte;
  FileCount      : Integer;
  FileCount1     : Integer;
  FileName       : String;
  SavedX         : Byte;
  SavedY         : Byte;
  TimeStart      : LongInt
  DelayTime      : Integer
  Data           : Array[1..MaxFrames] of String;
  DataTmp        : String;
  DataSize       : Byte;
  InFile         : File;
  PromptFilePath : String=AddSlash(JustPath(ProgName)+SubDirectory);     // SUB DIRECTORY
  
Procedure CheckTimeOut;
Begin
  If CfgTimeOut>0 Then
  Begin
    If Timer-TimeStart>CfgTimeOut Then 
    Begin
      WriteLn(GetPrompt(136));
      SysopLog(PROG_NAME+': Inactivity timeout');
      write('|[1')
      HangUp;
    End
  End;
End;

Begin
  TimeStart:=Timer;

  // if not at leftmost column, assume line contains something, so switch to next line
  If WhereX>1 Then
    write('|CR')

  If Graphics=0 Then 
  Begin
    Write(PromptAsciiPause);
    Repeat
      CheckTimeOut;
      Delay(100);
    Until KeyPressed;
    StuffKey(ReadKey);
    Halt;
  End;

  If Set_POS Then
    If X_AXIS>0 and Y_AXIS>0 Then
      Begin
        // X and Y positioning
        gotoxy(X_AXIS,Y_AXIS)
      End
    Else If X_AXIS>0 Then
      Begin
        // only X positioning
        If X_AXIS<10 Then
          write('|[X0'+Int2Str(X_AXIS))
        Else
          write('|[X'+Int2Str(X_AXIS))
      End
    Else
      Begin  
        // only Y positioning
        If Y_AXIS<10 Then
          write('|[Y0'+Int2Str(Y_AXIS))
        Else
          write('|[Y'+Int2Str(Y_AXIS))
      End

  SavedX:=WhereX;
  SavedY:=WhereY;

  write('|00|[0')
  FindFirst(PromptFilePath+'*.*',66)
  While DosError=0 Do
  Begin
    filecount:=filecount+1
    FindNext
  End
  FindClose
  If (filecount>0) and (ParamCount<1) Then
    Begin
      FileCount1:=(Random(FileCount)+1);
      if Debug then
      Begin
        SysopLog(PROG_NAME+': Count: '+Int2Str(FileCount))
        SysopLog(PROG_NAME+': Random: '+Int2Str(FileCount1))
        WriteLn(PROG_NAME+': Count: '+Int2Str(FileCount))
        WriteLn(PROG_NAME+': Random: '+Int2Str(FileCount1))
      End
      FileCount:=0
      FindFirst(PromptFilePath+'*.*',66)
      While (DosError=0) and (FileCount<FileCount1) Do
      Begin
        FileCount:=FileCount+1
        FindNext
      End
      FileName:=PromptFilePath+DirName
    End
  If (ParamStr(1)<>'') Then
    FileName:=PromptFilePath+ParamStr(1);
  if Debug then 
  Begin
    SysopLog(PROG_NAME+': '+FileName) 
    WriteLn(PROG_NAME+': '+FileName)
  End
  fAssign(InFile,FileName,2);
  fReset(InFile);
  if IOResult<>0 then
  Begin
    WriteLn('|15|[1|CR|15ERROR: |07Animated pause data not found!|PN')
    SysopLog(PROG_NAME+': is unable to find prompt files!')
    Halt
  End
  fReadLn(InFile,Data[1]);
  DelayTime:=str2Int(Data[1]);
  Count:=1;
  While Not fEof(InFile) And Count<MaxFrames Do 
  Begin
    fReadLn(InFile,DataTmp);
    If pos('SAUCE',DataTmp)=0 Then
    Begin
      Data[Count]:=DataTmp;
      Count:=Count+1;
    End
  End;
  fClose (InFile);
  DataSize:=Count-1;
  Count:=1;
  PurgeInput;
  Repeat
    CheckTimeOut;
    GotoXY(SavedX, SavedY);
    Write(Data[Count]);
    If Count=DataSize Then
      Count:=1
    Else
      Count:=Count+1;
    Delay(DelayTime);
  Until KeyPressed;
  write('|16|15|[1')
  StuffKey(ReadKey);
End.
