// (c) 1994-1997 Niklas Beisert, this file is part of "Indoor Music System".
// you must not read, modify, print, compile or copy this file or parts of
// it unless you have accepted the license in the accompanying file IMS.TXT.

//#include <string.h>
#include <stdlib.h>
#include "mcp.h"

#define SAMPEND 6

static sampleinfo *samples;
static unsigned long *redpars;
static unsigned long memmax;
static unsigned int samplenum;
static unsigned short abstab[0x200];
static unsigned char always16bit;
static unsigned char nopingpongloops;
static unsigned char cardgus;

static void sampto8(sampleinfo &s)
{
  unsigned long c;
  unsigned char *pd=(unsigned char *)s.ptr;
  unsigned char *ps=(unsigned char *)pd+1;
  for (c=0; c<(s.length+SAMPEND); c++, pd++, ps+=2)
    *pd=*ps;
  s.ptr=realloc(s.ptr,s.length+SAMPEND);
  s.type&=~mcpSamp16Bit;
  s.type|=mcpSampRedBits;
}

static void repairloop(sampleinfo &s)
{
  if (s.type&mcpSampLoop)
  {
    if (s.loopend<=s.loopstart)
      s.type&=~mcpSampLoop;
    if (s.loopstart<0)
      s.loopstart=0;
    if (s.loopend>s.length)
      s.loopend=s.length;
    if (s.loopend==s.loopstart)
      s.type&=~mcpSampLoop;
  }
  if (s.type&mcpSampSLoop)
  {
    if (s.sloopend<=s.sloopstart)
      s.type&=~mcpSampSLoop;
    if (s.sloopstart<0)
      s.sloopstart=0;
    if (s.sloopend>s.length)
      s.sloopend=s.length;
    if (s.sloopend==s.sloopstart)
      s.type&=~mcpSampSLoop;
  }
  if ((s.type&mcpSampLoop)&&(s.type&mcpSampSLoop)&&((!(s.type&mcpSampBiDi))==(!(s.type&mcpSampSBiDi)))&&(s.loopstart==s.sloopstart)&&(s.loopend==s.sloopend))
    s.type&=~mcpSampSLoop;
}

static int expandsmp(sampleinfo &s)
{
  int newlen=s.length;
  int replen=s.loopend-s.loopstart;
  int sreplen=s.sloopend-s.sloopstart;
  char restricted=0;
  char toforward=0;
  char stoforward=0;
  int expandloop=0;
  int sexpandloop=0;
  int c;

  if ((s.type&mcpSampLoop)&&(s.type&mcpSampSLoop)&&(s.loopend>s.sloopstart)&&(s.sloopend>s.loopstart))
    restricted=1;

  if ((s.type&mcpSampLoop)&&(s.type&mcpSampBiDi)&&nopingpongloops&&!restricted)
  {
    toforward=1;
    expandloop=replen*toforward;
    replen+=replen*toforward;
  }
  if ((s.type&mcpSampLoop)&&(replen<256)&&!restricted)
  {
    int ln=255/replen;
    if ((s.type&mcpSampBiDi)&&!toforward)
      ln=(ln+1)&~1;
    expandloop+=ln*replen;
  }

  if ((s.type&mcpSampSLoop)&&(s.type&mcpSampSBiDi)&&nopingpongloops&&!restricted)
  {
    stoforward=1;
    sexpandloop=sreplen*stoforward;
    sreplen+=sreplen*stoforward;
  }
  if ((s.type&mcpSampSLoop)&&(sreplen<256)&&!restricted)
  {
    int ln=sexpandloop=255/sreplen;
    if ((s.type&mcpSampSBiDi)&&!stoforward)
      ln=(ln+1)&~1;
    sexpandloop+=ln*sreplen;
  }


  replen=s.loopend-s.loopstart;
  sreplen=s.sloopend-s.sloopstart;

  newlen+=expandloop+sexpandloop;
  if (newlen<2)
    newlen=2;

  s.ptr=realloc(s.ptr, (newlen+SAMPEND)<<(!!(s.type&mcpSamp16Bit)));
  if (!s.ptr)
    return 0;
  if (expandloop)
  {
    if (s.type&mcpSamp16Bit)
    {
      short *p=(short *)s.ptr+s.loopend;
      for (c=s.length-s.loopend-1; c>=0; c--)
        p[c+expandloop]=p[c];
      if (!(s.type&mcpSampBiDi))
        for (c=0; c<replen; c++)
          p[c]=p[c-replen];
      else
        for (c=0; c<replen; c++)
          p[c]=p[-1-c];
      for (c=replen; c<expandloop; c++)
        p[c]=p[c-(replen<<1)];
    }
    else
    {
      char *p=(char *)s.ptr+s.loopend;
      for (c=s.length-s.loopend-1; c>=0; c--)
        p[c+expandloop]=p[c];
      if (!(s.type&mcpSampBiDi))
        for (c=0; c<replen; c++)
          p[c]=p[c-replen];
      else
        for (c=0; c<replen; c++)
          p[c]=p[-1-c];
      for (c=replen; c<expandloop; c++)
        p[c]=p[c-(replen<<1)];
    }

    if (s.sloopstart>=s.loopend)
      s.sloopstart+=expandloop;
    if (s.sloopend>=s.loopend)
      s.sloopend+=expandloop;
    s.length+=expandloop;
    s.loopend+=expandloop;
    if (toforward)
      s.type&=~mcpSampBiDi;
    if (toforward==2)
      s.loopstart+=replen;
  }

  if (sexpandloop)
  {
    if (s.type&mcpSamp16Bit)
    {
      short *p=(short *)s.ptr+s.sloopend;
      for (c=0; c<(s.length-s.sloopend); c++)
        p[c+sexpandloop]=p[c];
      if (!(s.type&mcpSampSBiDi))
        for (c=0; c<sreplen; c++)
          p[c]=p[c-sreplen];
      else
        for (c=0; c<sreplen; c++)
          p[c]=p[-1-c];
      for (c=sreplen; c<sexpandloop; c++)
        p[c]=p[c-(sreplen<<1)];
    }
    else
    {
      char *p=(char *)s.ptr+s.sloopend;
      for (c=0; c<(s.length-s.sloopend); c++)
        p[c+sexpandloop]=p[c];
      if (!(s.type&mcpSampSBiDi))
        for (c=0; c<sreplen; c++)
          p[c]=p[c-sreplen];
      else
        for (c=0; c<sreplen; c++)
          p[c]=p[-1-c];
      for (c=sreplen; c<sexpandloop; c++)
        p[c]=p[c-(sreplen<<1)];
    }

    if (s.loopstart>=s.sloopend)
      s.loopstart+=sexpandloop;
    if (s.loopend>=s.sloopend)
      s.loopend+=sexpandloop;
    s.length+=sexpandloop;
    s.sloopend+=sexpandloop;
    if (stoforward)
      s.type&=~mcpSampSBiDi;
    if (stoforward==2)
      s.sloopstart+=sreplen;
  }

  if (s.length<2)
  {
    if (s.type&mcpSamp16Bit)
    {
      short *p=(short *)s.ptr;
      if (!s.length)
        *p=0;
      p[1]=*p;
    }
    else
    {
      char *p=(char *)s.ptr;
      if (!s.length)
        *p=0;
      p[1]=*p;
    }
    s.length=2;
  }

  return 1;
}

static int repairsmp(sampleinfo &s)
{
  s.ptr=realloc(s.ptr, (s.length+SAMPEND)<<(!!(s.type&mcpSamp16Bit)));
  if (!s.ptr)
    return 0;

  repairloop(s);

  if ((s.type&mcpSampLoop)&&!(s.type&mcpSampSLoop))
  {
    s.type&=~mcpSampSBiDi;
    s.type|=mcpSampSLoop;
    if (s.type&mcpSampBiDi)
      s.type|=mcpSampSBiDi;
    s.sloopstart=s.loopstart;
    s.sloopend=s.loopend;
  }

  if (s.type&mcpSamp16Bit)
  {
    int c;
    short *p=(short*)s.ptr;
    for (c=0; c<SAMPEND; c++)
      p[s.length+c]=((short*)s.ptr)[s.length-1];
    if ((s.type&mcpSampSLoop)&&!(s.type&mcpSampSBiDi))
    {
      p[s.sloopend]=p[s.sloopstart];
      p[s.sloopend+1]=p[s.sloopstart+1];
    }
    if ((s.type&mcpSampLoop)&&!(s.type&mcpSampBiDi))
    {
      p[s.loopend]=p[s.loopstart];
      p[s.loopend+1]=p[s.loopstart+1];
    }
  }
  else
  {
    int c;
    char *p=(char*)s.ptr;
    for (c=0; c<SAMPEND; c++)
      p[s.length+c]=p[s.length-1];
    if ((s.type&mcpSampSLoop)&&!(s.type&mcpSampSBiDi))
    {
      p[s.sloopend]=p[s.sloopstart];
      p[s.sloopend+1]=p[s.sloopstart+1];
    }
    if ((s.type&mcpSampLoop)&&!(s.type&mcpSampBiDi))
    {
      p[s.loopend]=p[s.loopstart];
      p[s.loopend+1]=p[s.loopstart+1];
    }
  }

  return 1;
}

static unsigned long devsmplen(unsigned long l)
{
  return l;
}

unsigned long getpitch(const void *ptr, unsigned long len);
#pragma aux getpitch parm [esi] [edi] value [edx] modify [eax ebx] = \
  "xor eax,eax" \
  "xor ebx,ebx" \
  "xor edx,edx" \
  "lp:"\
    "mov al,[esi]" \
    "mov ah,[esi+1]" \
    "xor eax,8080h" \
    "sub al,ah" \
    "sbb ah,ah" \
    "inc ah" \
    "mov bx,abstab[eax+eax]" \
    "add edx,ebx" \
    "inc esi" \
  "dec edi" \
  "jnz lp"

unsigned long getpitch16(const void *ptr, unsigned long len);
#pragma aux getpitch16 parm [esi] [edi] value [edx] modify [eax ebx] = \
  "xor eax,eax" \
  "xor ebx,ebx" \
  "xor edx,edx" \
  "lp:"\
    "mov al,[esi+1]" \
    "mov ah,[esi+3]" \
    "xor eax,8080h" \
    "sub al,ah" \
    "sbb ah,ah" \
    "inc ah" \
    "mov bx,abstab[eax+eax]" \
    "add edx,ebx" \
    "add esi,2" \
  "dec edi" \
  "jnz lp"

static signed char dividefrq(sampleinfo &s)
{
  unsigned long c;
  if (s.type&mcpSamp16Bit)
  {
    unsigned short *pd=(unsigned short *)s.ptr;
    unsigned short *ps=pd;
    for (c=0; c<s.length; c+=2, pd++, ps+=2)
      *pd=*ps;
  }
  else
  {
    unsigned char *pd=(unsigned char *)s.ptr;
    unsigned char *ps=pd;
    for (c=0; c<s.length; c+=2, pd++, ps+=2)
      *pd=*ps;
  }

  s.length>>=1;
  s.loopstart>>=1;
  s.loopend>>=1;
  s.sloopstart>>=1;
  s.sloopend>>=1;
  s.samprate>>=1;
  s.type|=(s.type&mcpSampRedRate2)?mcpSampRedRate4:mcpSampRedRate2;

  s.ptr=realloc(s.ptr, (s.length+SAMPEND)<<(!!(s.type&mcpSamp16Bit)));
  if (!s.ptr)
    return -1;

  return 0;
}

static unsigned char reducesmpsize()
{
  if (!memmax)
    return 0;
  int i;
  signed long curdif=-memmax;
  for (i=0; i<samplenum; i++)
    curdif+=devsmplen((samples[i].length+SAMPEND)<<(!always16bit&&!!(samples[i].type&mcpSamp16Bit)));
  return curdif>0;
}

static int reduce16()
{
  int i;
  signed long curdif=-memmax;
  signed long totdif=0;
  for (i=0; i<samplenum; i++)
  {
    sampleinfo &s=samples[i];
    if (s.type&mcpSamp16Bit)
    {
      redpars[i]=devsmplen((s.length+SAMPEND)<<1)-devsmplen(s.length+SAMPEND);
      totdif+=redpars[i];
      curdif+=devsmplen((s.length+SAMPEND)<<1);
    }
    else
    {
      redpars[i]=0;
      curdif+=devsmplen(s.length+SAMPEND);
    }
  }

  if (curdif>totdif)
  {
    for (i=0; i<samplenum; i++)
      if (samples[i].type&mcpSamp16Bit)
        sampto8(samples[i]);
    return 0;
  }

  while (curdif>0)
  {
    int fit=0;
    int best;
    long bestdif=0;
    for (i=0; i<samplenum; i++)
      if (curdif<=redpars[i])
      {
        if (!fit||(bestdif>redpars[i]))
        {
          fit=1;
          bestdif=redpars[i];
          best=i;
        }
      }
      else
      {
        if (!fit&&(bestdif<redpars[i]))
        {
          bestdif=redpars[i];
          best=i;
        }
      }
    sampto8(samples[best]);
    curdif-=redpars[best];
    redpars[best]=0;
  }
  return 1;
}

static int reducefrq()
{
  int i;

  for (i=-0x100; i<0x100; i++)
    abstab[i+0x100]=i*i/16;

  signed long curdif=-memmax;
  for (i=0; i<samplenum; i++)
  {
    sampleinfo &s=samples[i];
    curdif+=devsmplen(s.length+SAMPEND);
    if (devsmplen(s.length+SAMPEND)<(devsmplen((s.length>>1)+SAMPEND)+512))
      redpars[i]=0xFFFFFFFF;
    else
    if (s.type&mcpSamp16Bit)
      redpars[i]=getpitch16(s.ptr, s.length)/s.length;
    else
      redpars[i]=getpitch(s.ptr, s.length)/s.length;
  }

  while (curdif>0)
  {
    int best=-1;
    unsigned long bestpitch=0xFFFFFFFF;
    for (i=0; i<samplenum; i++)
      if (redpars[i]<bestpitch)
      {
        bestpitch=redpars[i];
        best=i;
      }
    if (best==-1)
      return 0;
    sampleinfo &s=samples[best];
    curdif-=devsmplen(s.length+SAMPEND);
    if (dividefrq(s))
      return 0;
    curdif+=devsmplen(s.length+SAMPEND);

    if ((devsmplen(s.length+SAMPEND)<(devsmplen((s.length>>1)+SAMPEND)+512))||(s.type&mcpSampRedRate4))
      redpars[best]=0xFFFFFFFF;
    else
    if (s.type&mcpSamp16Bit)
      redpars[best]=(getpitch16(s.ptr, s.length)/s.length)<<1;
    else
      redpars[best]=(getpitch(s.ptr, s.length)/s.length)<<1;
  }

  return 1;
}

static int smConvertSample(sampleinfo &s)
{
  if (s.loopstart>=s.loopend)
    s.type&=~mcpSampLoop;

  unsigned long c;

  if ((s.type&(mcpSampBigEndian|mcpSamp16Bit))==(mcpSampBigEndian|mcpSamp16Bit))
  {
    int i;
    for (i=0; i<s.length; i++)
    {
      char tmp=((char*)s.ptr)[2*i];
      ((char*)s.ptr)[2*i]=((char*)s.ptr)[2*i+1];
      ((char*)s.ptr)[2*i+1]=tmp;
    }
  }
  s.type&=~mcpSampBigEndian;

  if (s.type&mcpSampDelta)
  {
    if (s.type&mcpSamp16Bit)
    {
      unsigned short *p=(unsigned short *)s.ptr;
      unsigned short old=0;
      for (c=0; c<s.length; c++)
        old=((*p++)+=old);
    }
    else
    {
      unsigned char *p=(unsigned char*)s.ptr;
      unsigned char old=0;
      for (c=0; c<s.length; c++)
        old=((*p++)+=old);
    }
    s.type&=~(mcpSampDelta|mcpSampUnsigned);
  }
  if (s.type&mcpSampUnsigned)
  {
    if (s.type&mcpSamp16Bit)
    {
      unsigned short *p=(unsigned short *)s.ptr;
      for (c=0; c<s.length; c++)
        *p++^=0x8000;
    }
    else
    {
      unsigned char *p=(unsigned char *)s.ptr;
      for (c=0; c<s.length; c++)
        *p++^=0x80;
    }
    s.type&=~mcpSampUnsigned;
  }

  return 1;
}

int mcpReduceSamples(sampleinfo *si, int n, long mem, int opt)
{
  always16bit=!!(opt&mcpRedAlways16Bit);
  nopingpongloops=!!(opt&mcpRedNoPingPong);
  cardgus=!!(opt&mcpRedGUS);
  memmax=mem;
  samples=si;
  samplenum=n;

  int i;
  for (i=0; i<samplenum; i++)
  {
    if (!smConvertSample(samples[i]))
      return -1;
    repairloop(samples[i]);
    if (!expandsmp(samples[i]))
      return -1;
  }

  if (cardgus)
    for (i=0; i<samplenum; i++)
      if ((samples[i].type&mcpSamp16Bit)&&((samples[i].length+SAMPEND)>(128*1024)))
        sampto8(samples[i]);

  if (reducesmpsize())
  {
    redpars=new unsigned long [samplenum];
    if (!redpars)
      return 0;
    if (always16bit||!reduce16())
      if (!reducefrq())
        return 0;
    delete redpars;
  }

  for (i=0; i<samplenum; i++)
    if (!repairsmp(samples[i]))
      return -1;

  return 1;
}
