{
  Sound System Source Release 4 (pd)1995 by the Frontman of Crew242
  Turbo Pascal Interface (pd)1995/96 by Daniel Ludwig

  This source code is FREEWARE!
}

Unit TPSS4;

Interface

(*****************************************************************************)
(************************ MODULE/SFX PLAYER **********************************)
(*****************************************************************************)
Type
  TConfigParam = Record
    Base       : word;    { Baseport of sound card           }
    dma        : byte;    { DMA Channel (8&16 Bit suported)  }
    irq        : byte;    { IRQ Number                       }
    samplerate : word;    { Samplerate (11-22/44 kHz)        }
    internal   : byte;    { used by SBMOD: SB,Pro or SB16?   }
    inttype    : byte;    { 0=DOS(RTC) 1=Windows(Timer)      }
    startpos   : byte;    { 0-127                            }
    looppos    : byte;    { 0-127,>127=no loop               }
    songmode   : byte;    { 0=Music&SFX 1=Music 2=SFX 3=MUTE }
    mastervol  : byte;    { Master Volume                    }
    musicvol   : byte;    { Music Volume                     }
    sfxvol     : byte;    { Sound FX Volume                  }
  End;

  PConfigParam = ^TConfigParam;

Const
  {interrupt type; 0=RTC 1=Timer; changed by config_init}
  { should EVER be a copy of Configparam.inttype        }
  Inttype     : byte = 0;

  {use for LoadDriver}
  SB          = 1;
  SB16        = 2;
  PAS16       = 3;
  GUS         = 4;

  {use for Set_SongMode}
  Modus_Both  = 0; {play music AND effects}
  Modus_Music = 1; {play music only       }
  Modus_SFX   = 2; {play effects only     }
  Modus_None  = 3; {play nothing          }

  {use for "Typ" in Load_Sample}
  Amiga       = 0; {Amiga type sample (signed)}
  PC        = $80; {PC type sample (unsigned) }

  { Loads choosen MOD player driver into memory }
  Function  LoadDriver(dr:byte):boolean;

  { Inits MOD player using parameterblock }
  Function  Config_Init(ConfigParam:PConfigParam):boolean;

  { Inits MOD player using SS?.CFG }
  Function  Config_Init2:boolean;

  { Loads MOD file into main/EMS memory }
  Function  Load_MOD(MODName:String):boolean;

  { Starts music playback }
  Function  Play_Music:boolean;

  { Stops music playback }
  Procedure Stop_Music;

  { Exists MOD player; should be called at the end of program }
  Procedure End_Music;

  { Loads signed/unsigned sample RAW file into EMS buffer }
  Function  Load_Sample(Var handle:word; SampleFile:string; Typ:byte):boolean;

  { Plays sample; function supports panning effect on stereo cards }
  Procedure Play_Sample(handle,freq:word; panning:byte);

  { Frees ALL samples by clearing EMS buffer / onboard memory of card }
  Procedure End_Sample;

  { Sets playback frequency }
  Procedure Set_SampleRate(freq:word);

  { Gets/Sets Volume routines }
  Function  Get_MasterVolume:byte;
  Procedure Set_MasterVolume(vol:byte);
  Function  Get_MusicVolume:byte;
  Procedure Set_MusicVolume(vol:byte);
  Function  Get_SfxVolume:byte;
  Procedure Set_SfxVolume(vol:byte);

  { Sets module restart position; >127 = no loop }
  Procedure Set_SongLoop(pattern:byte);

  { Get/Set actual pattern position }
  Function  Get_SongPosition:byte;
  Procedure Set_SongPosition(pattern:byte);

  { Gets/Sets playing mode; have a look at above constants }
  Function  Get_SongMode:byte;
  Procedure Set_SongMode(Mode:byte);

  { removes MOD player from memory }
  Procedure FreeDriver;

(*****************************************************************************)
(************************** CD AUDIO PLAYER **********************************)
(*****************************************************************************)

  { Loads CD player into memory }
  Function  CD_LoadDriver:boolean;

  { Tries to detect CDROM drive }
  Function  CD_Init:boolean;

  { Loads table of contents; called by CD_Init; call it after changing CD }
  Procedure CD_TOC;

  { Starts playing CD audio track }
  Procedure CD_Play(tracknr:byte; repeating,chaining:boolean);

  { Stops playing track }
  Procedure CD_Stop;

  { Pauses playing track }
  Procedure CD_Pause;

  { Resumes paused track }
  Procedure CD_Resume;

  { Seeks track forward/backward }
  Procedure CD_Seek(time:shortint);

  { Returns TRUE if track is playing }
  Function  CD_Playing:boolean;

  { Removes CD audio player from memory }
  Procedure CD_FreeDriver;

(*****************************************************************************)
(************************ FLI/FLC ANIMPLAYER *********************************)
(*****************************************************************************)

  { Loads anim player into memory }
  Function FLC_LoadDriver:boolean;

  { Inits animation; sound fx support
    fxlistPtr = pointer on list:  WORD   Frame Nr.; -1=End Of List
                                  WORD   Sample handle returned by Load_Sample
                                  WORD   Playback frequency                   }
  Procedure FLC_Init(fxlistPtr:pointer; videochange:boolean);

  { Plays FLI/FLC file }
  Procedure FLC_Play(fname:string; speed,loops:byte; chaining,usefx:boolean);

  { Ends animation; must be called after FLC_Play }
  Procedure FLC_End(videoback:boolean);

  { Removes anim player from memory }
  Procedure FLC_FreeDriver;


Implementation

{internal; do not change}
Const
  Driver      : byte = 0;                   {default=NOSOUND}
  DrvPtr      : pointer = NIL;              {Music/SFX Driver Pointer}
  DrvPtrCD    : pointer = NIL;              {CDAudio Driver Pointer}
  DrvPtrFLC   : pointer = NIL;              {FLC Player Driver Ptr}

  DriverFile  : Array[1..9]Of String[12] = ( 'sbmod.com','sb16mod.com',
                                             'pasmod.com','usmod.com',
                                             '','','',
                                             'cdaudio.com','flcplay.com' );


  procedure string2asciiz(var s : string); assembler;
  asm
    push  ds
    lds   si, s
    les   di, s
    lodsb
    mov   cl, al
    xor   ch, ch
    cld
    rep   movsb
    xor   al, al
    stosb
    pop   ds
  end; {string2asciiz}

(*****************************************************************************)

  Function LoadDriver(dr:byte):boolean;
  var ok:boolean;
      f:file;
      result:word;
      drvsize,drvseg:word;
  Begin
    driver:=dr;
    ok:=(driver>0) And (driver<5);
    if ok then begin                              { Soundcard choosen? }
      assign(f,driverfile[driver]);
      {$I-}
      reset(f,1);
      {$I+}
      ok:=(ioresult=0);
      if ok then begin                            { Driver found? }
        drvsize:=filesize(f);
        asm
          mov  ah,48h
          mov  bx,drvsize
          shr  bx,4
          inc  bx
          int  21h
          jnc  @noerr
          mov  ok,0
         @noerr:
          sub  ax,10h
          mov  drvseg,ax
          mov  word ptr drvptr+2,ax
        end;
        if ok then begin                          { Mem allocation failed? }
          reset(f,1);
          blockread(f,mem[drvseg+$10:0],filesize(f),result);
        end;
        close(f);
      end;
    end;
    loaddriver:=ok;
  End; {LoadDriver}

  Function Config_Init(ConfigParam:PConfigParam):boolean; Assembler;
  Asm
    push ds
    pop  es
    push ds
    pusha
    mov  word ptr drvptr,104h
    mov  cx,0C242h
    lds  bx,configparam
    call dword ptr es:[drvptr]
    popa
    pop ds
    cmc
    mov  al,0
    adc  al,0
    mov  cl,configparam.inttype {copy from paramblock..}
    mov  inttype,cl             { ..to global constant }
  End; {Config_Init}

  Function Config_Init2:boolean; Assembler;
  Asm
    push ds
    pusha
    mov  word ptr drvptr,104h
    xor  cx,cx
    call dword ptr [drvptr]
    popa
    pop ds
    cmc
    mov  al,0
    adc  al,0
  End; {Config_Init}

  Function Load_MOD(MODName:String):boolean;
  Var ModPtr:Pointer;
      ral:boolean;
  Begin
    string2asciiz(modname);
    modptr:=@modname;
    Asm
      mov  word ptr drvptr,108h
      push ds
      pop  es
      push ds
      pusha
      mov  dx,word ptr modptr
      mov  ax,word ptr modptr+2
      mov  ds,ax
      call dword ptr es:[drvptr]
      popa
      pop  ds
      cmc
      mov  al,0
      adc  al,0
      mov  ral,al
    End;
    Load_Mod:=ral;
  End; {Load_MOD}

  Function Play_Music:boolean; Assembler;
  Asm
    push ds
    pusha
    mov  word ptr drvptr,10Ch
    call dword ptr [drvptr]
    popa
    pop  ds
    cmc
    mov  al,0
    adc  al,0
  End; {Play_Music}

  Procedure Stop_Music; Assembler;
  Asm
    push ds
    pusha
    mov  word ptr drvptr,110h
    call dword ptr [drvptr]
    popa
    pop  ds
  End; {Stop_Music}

  Procedure End_Music; Assembler;
  Asm
    push ds
    pusha
    mov  word ptr drvptr,114h
    call dword ptr [drvptr]
    popa
    pop  ds
  End; {End_Music}

  Function Load_Sample(Var handle:word; SampleFile:string; Typ:byte):boolean;
  Var SmpPtr:pointer;
      rbl:boolean;
      rh:word;
  Begin
    if typ<>0 then typ:=$80; {correct if invalid}
    string2asciiz(samplefile);
    SmpPtr:=@samplefile;
    Asm
      pusha
      push ds
      pop  es
      push ds
      mov  word ptr drvptr,118h
      mov  cl,typ
      mov  dx,word ptr smpptr
      mov  ax,word ptr smpptr+2
      mov  ds,ax
      call dword ptr es:[drvptr]
      pop  ds
      cmc
      mov  bl,0
      adc  bl,0
      mov  rbl,bl
      mov  rh,ax
      popa {destroys all returned values in registers!}
    End;
    handle:=rh;
    Load_Sample:=rbl;
  End; {Load_Sample}

  Procedure Play_Sample(handle,freq:word; panning:byte); Assembler;
  Asm
    push ds
    pusha
    mov  word ptr drvptr,11Ch
    mov  al,panning
    mov  bx,handle
    mov  cx,freq
    call dword ptr [drvptr]
    popa
    pop  ds
  End; {Play_Sample}

  Procedure End_Sample; Assembler;
  Asm
    push ds
    pusha
    mov  word ptr drvptr,120h
    call dword ptr [drvptr]
    popa
    pop  ds
  End; {End_Sample}

  Procedure Set_SampleRate(freq:word);
  Begin
    If freq<10000 Then freq:=10000
    Else If freq>44100 Then freq:=44100;
    Asm
      mov  word ptr drvptr,124h
      mov  ax,freq
      call dword ptr [drvptr]
    End;
  End; {Set_SampleRate}

  Function Get_MasterVolume:byte; Assembler;
  Asm
    mov  word ptr drvptr,128h
    call dword ptr [drvptr]
  End; {Get_MasterVolume}

  Procedure Set_MasterVolume(vol:byte); Assembler;
  Asm
    mov  word ptr drvptr,128h {get old volumes}
    call dword ptr [drvptr]
    mov  word ptr drvptr,12Ch {set new volumes}
    mov  al,vol
    call dword ptr [drvptr]
  End; {Set_MasterVolume}

  Function Get_MusicVolume:byte; Assembler;
  Asm
    mov  word ptr drvptr,128h
    call dword ptr [drvptr]
    mov  al,bl
  End; {Get_MusicVolume}

  Procedure Set_MusicVolume(vol:byte); Assembler;
  Asm
    mov  word ptr drvptr,128h {get old volumes}
    call dword ptr [drvptr]
    mov  word ptr drvptr,12Ch {set new volumes}
    mov  bl,vol
    call dword ptr [drvptr]
  End; {Set_MusicVolume}

  Function Get_SfxVolume:byte; Assembler;
  Asm
    mov  word ptr drvptr,128h
    call dword ptr [drvptr]
    mov  al,bh
  End; {Get_SfxVolume}

  Procedure Set_SfxVolume(vol:byte); Assembler;
  Asm
    mov  word ptr drvptr,128h {get old volumes}
    call dword ptr [drvptr]
    mov  word ptr drvptr,12Ch {set new volumes}
    mov  bh,vol
    call dword ptr [drvptr]
  End; {Set_SfxVolume}

  Procedure Set_SongLoop(pattern:byte); Assembler;
  Asm
    mov  word ptr drvptr,130h
    mov  al,pattern
    call dword ptr [drvptr]
  End; {Set_SongLoop}

  Function Get_SongPosition:byte; Assembler;
  Asm
    mov  word ptr drvptr,134h
    call dword ptr [drvptr]
  End; {Get_SongPosition}

  Procedure Set_SongPosition(pattern:byte); Assembler;
  Asm
    mov  word ptr drvptr,138h
    mov  al,pattern
    call dword ptr [drvptr]
  End; {Set_SongPosition}

  Function Get_SongMode:byte; Assembler;
  Asm
    mov  word ptr drvptr,13Ch
    call dword ptr [drvptr]
  End; {Get_SongMode}

  Procedure Set_SongMode(Mode:byte); Assembler;
  Asm
    mov  al,mode
    mov  word ptr drvptr,140h
    call dword ptr [drvptr]
  End; {Set_SongMode}

  Procedure FreeDriver; Assembler;
  Asm
    mov  ax,word ptr drvptr+2
    mov  es,ax
    mov  ah,49h
    int  21h                                        { no error checking }
    xor  al,al
    mov  driver,al                                  { back to NOSOUND }
  End; {FreeDriver}

(*****************************************************************************)

  Function CD_LoadDriver:boolean;
  var ok:boolean;
      f:file;
      result:word;
      drvsize,drvseg:word;
  Begin
    if ok then begin
      assign(f,driverfile[8]);
      {$I-}
      reset(f,1);
      {$I+}
      ok:=(ioresult=0);
      if ok then begin
        drvsize:=filesize(f);
        asm
          mov  ah,48h
          mov  bx,drvsize
          shr  bx,4
          inc  bx
          int  21h
          jnc  @noerr
          mov  ok,0
         @noerr:
          sub  ax,10h
          mov  drvseg,ax
          mov  word ptr drvptrCD+2,ax
        end;
        if ok then begin
          reset(f,1);
          blockread(f,mem[drvseg+$10:0],filesize(f),result);
        end;
        close(f);
      end;
    end;
    CD_Loaddriver:=ok;
  End; {CD_LoadDriver}

  Function CD_Init:boolean; Assembler;
  Asm
    push bp                             {-BP und ..                     }
    push ds                             { .. DS sichern; SEHR WICHTIG   }
    push ds                             {-DS auf ..      }
    pop  es                             { .. ES kopieren }
    push word ptr drvptrCD+2            {-!!! DS so einstellen, dass es nach }
    pop  ds                             { CALL mit CS identisch !!WICHTIG!!! }
    mov  word ptr es:drvptrCD,104h      {-Funktionsoffset einstellen }
    call dword ptr es:[drvptrCD]        {-Aufruf }
    pop  ds                             {-DS und ..           }
    pop  bp                             { BP wiederherstellen }
    cmc                                 {-Fehlerbehanlung }
    mov  al,0
    adc  al,0
  End; {CD_Init}

  Procedure CD_TOC; Assembler;
  Asm
    push bp
    push ds
    push ds
    pop  es
    push word ptr drvptrCD+2
    pop  ds
    mov  word ptr es:drvptrCD,108h
    call dword ptr es:[drvptrCD]
    pop  ds
    pop  bp
  End; {CD_TOC}

  Procedure CD_Play(tracknr:byte; repeating,chaining:boolean);
  Var rah:byte;
      rcx:word;
  Begin
    If repeating Then rah:=1 Else rah:=0;
    If chaining Then rcx:=1 Else rcx:=0;
    rcx:=(inttype SHL 1)+rcx;
    Asm
      push bp
      push ds
      push ds
      pop  es
      mov  al,tracknr
      mov  ah,rah
      mov  cx,rcx
      push word ptr drvptrCD+2
      pop  ds
      mov  word ptr es:drvptrCD,10Ch
      call dword ptr es:[drvptrCD]
      pop  ds
      pop  bp
    End;
  End; {CD_Play}

  Procedure CD_Stop; Assembler;
  Asm
    push bp
    push ds
    push ds
    pop  es
    push word ptr drvptrCD+2
    pop  ds
    mov  word ptr es:drvptrCD,110h
    call dword ptr es:[drvptrCD]
    pop  ds
    pop  bp
  End; {CD_Stop}

  Procedure CD_Pause; Assembler;
  Asm
    push bp
    push ds
    push ds
    pop  es
    push word ptr drvptrCD+2
    pop  ds
    mov  word ptr es:drvptrCD,114h
    call dword ptr es:[drvptrCD]
    pop  ds
    pop  bp
  End; {CD_Pause}

  Procedure CD_Resume; Assembler;
  Asm
    push bp
    push ds
    push ds
    pop  es
    push word ptr drvptrCD+2
    pop  ds
    mov  word ptr es:drvptrCD,118h
    call dword ptr es:[drvptrCD]
    pop  ds
    pop  bp
  End; {CD_Resume}

  Procedure CD_Seek(time:shortint); Assembler;
  Asm
    push bp
    push ds
    push ds
    pop  es
    mov  al,time
    push word ptr drvptrCD+2
    pop  ds
    mov  word ptr es:drvptrCD,11Ch
    call dword ptr es:[drvptrCD]
    pop  ds
    pop  bp
  End; {CD_Seek}

  Function CD_Playing:boolean; Assembler;
  Asm
    push bp
    push ds
    push ds
    pop  es
    push word ptr drvptrCD+2
    pop  ds
    mov  word ptr es:drvptrCD,120h
    call dword ptr es:[drvptrCD]
    pop  ds
    pop  bp
    cmc
    mov  al,0
    adc  al,0
  End; {CD_Playing}

  Procedure CD_FreeDriver; Assembler;
  Asm
    mov  ax,word ptr drvptrCD+2
    mov  es,ax
    mov  ah,49h
    int  21h
  End; {CD_FreeDriver}

(*****************************************************************************)

  Function FLC_LoadDriver:boolean;
  var ok:boolean;
      f:file;
      result:word;
      drvsize,drvseg:word;
  Begin
    if ok then begin
      assign(f,driverfile[9]);
      {$I-}
      reset(f,1);
      {$I+}
      ok:=(ioresult=0);
      if ok then begin
        drvsize:=filesize(f);
        asm
          mov  ah,48h
          mov  bx,drvsize
          shr  bx,4
          inc  bx
          int  21h
          jnc  @noerr
          mov  ok,0
         @noerr:
          sub  ax,10h
          mov  drvseg,ax
          mov  word ptr drvptrFLC+2,ax
        end;
        if ok then begin
          reset(f,1);
          blockread(f,mem[drvseg+$10:0],filesize(f),result);
        end;
        close(f);
      end;
    end;
    FLC_loaddriver:=ok;
  End; {FLC_LoadDriver}

  Procedure FLC_Init(fxlistPtr:pointer; videochange:boolean); Assembler;
  Asm
    push bp
    push ds
    push ds
    pop  es
    mov  cl,videochange
    xor  ch,ch
    mov  ax,word ptr drvptr+2           { AX:BX  Play_Sample .. }
    mov  bx,11Ch                        { .. if driver loaded    }
    mov  dx,word ptr fxlistptr
    push word ptr fxlistptr+2
    pop  ds                             { DS:DX  FX List }
    mov  word ptr es:drvptrFLC,104h
    call dword ptr es:[drvptrFLC]
    pop  ds
    pop  bp
  End; {FLC_Init}

  Procedure FLC_Play(fname:string; speed,loops:byte; chaining,usefx:boolean);
  {a little bit "normal" TP Code; its easier :) }
  Var ral:byte;
      FLCPtr:Pointer;
  Begin
    string2asciiz(fname);
    flcptr:=@fname;
    ral:=0;
    If chaining Then ral:=1; ral:=ral+2*inttype; If usefx Then ral:=4+ral;
    Asm
      push bp
      push ds
      push ds
      pop  es
      mov  al,ral
      mov  cl,speed
      mov  ch,loops
      mov  dx,word ptr flcptr
      push word ptr flcptr+2
      pop  ds
      mov  word ptr es:drvptrFLC,10Ch
      call dword ptr es:[drvptrFLC]
      pop  ds
      pop  bp
    End;
  End; {FLC_Play}

  Procedure FLC_End(videoback:boolean); Assembler;
  Asm
    push bp
    push ds
    mov  cl,videoback
    xor  ch,ch
    mov  word ptr drvptrFLC,108h
    call dword ptr [drvptrFLC]
    pop  ds
    pop  bp
  End; {FLC_End}

  Procedure FLC_FreeDriver; Assembler;
  Asm
    mov  ax,word ptr drvptrFLC+2
    mov  es,ax
    mov  ah,49h
    int  21h
  End; {FLC_FreeDriver}



Begin
End.
