
// --- MXMPlay/Win32 v0.9 (based on MXMPlay 1.6)
// (C) 1999 The Artist Formerly Known As Doctor Roole in 1999
// VC++ 6.0 Support by Remage / Fresh!mindworkz.

#ifndef __MXMPLAY_H
#define __MXMPLAY_H

#ifdef __cplusplus
extern "C" }
#endif

// --- Initialize MXMPlay
// mxmmem  : pointer to MXM data
// mxmheap : ptr to player workspace (alloc 64K, should work)

int xmp_Init( void *mxmmem, void *mxmheap )
  { int tmp;
     _asm
      { mov esi, [mxmmem]
         mov ebx, [mxmheap]
         call xmpInit
         mov [tmp], eax
       }
     return tmp;
   }

// --- Start playing
// startord : order to play from

void xmp_Play( unsigned int startord )
  { _asm
      { mov eax, [startord]
         call xmpPlay
       }
   }

void xmpPlay(unsigned int startord);
  #pragma aux xmpPlay "*" parm [eax] modify [eax ebx ecx edx esi edi]



// Render sample stream into buffer
// dest : ptr to 32bit (!!!) stereo output buffer (not clipped, u suckerz)
// n    : number of samples (that means: 2*dword) to render

void xmpRender (signed long *dest, int n);
  #pragma aux xmpRender "*" parm[edi][eax] modify exact []



// Stop playing

void xmpStop();
  #pragma aux xmpStop "*" modify [eax ebx ecx edx esi edi]



// Set main volume
// vol: main volume (0-64)

void xmpSetVolume(unsigned char vol);
  #pragma aux xmpSetVolume "*" parm [eax]



// Get sync value (set it with Zxx effects in the XM)

unsigned char xmpGetSync();
  #pragma aux xmpGetSync "*" value [al]


// Get position
// returns: position as 0xOORR, O is order, R is row

unsigned short xmpGetPos();
  #pragma aux xmpGetPos "*" value [ax]



#ifdef __cplusplus
};
#endif

#endif
