;   

           ORG PgnAdr      ;   
Aerosol    jp BAerosol
DithCanOvb    ;      L
.IoddTB   DB   128,32,128,32,64,16,64,16,16,64,16,64,32,128,128,32
.InodTB   DB   8,2,8,2,4,1,4,1,1,4,1,4,2,8,8,2

.S_CAN    DB  1,2,3,4,5,6,7,8  ;    
.dBuff     DB 0,0,0,0,0,0,0,0  ;   

.CAN0      DB %10000000,0
.CAN1      DB %11000000,%11000000,0
.CAN2      DB %11100000,%11100000,%11100000,0
.CAN3      DB %01100000,%11110000,%11110000,%01100000,0
.CAN4      DB %01110000,%11111000,%11111000,%11111000,%01110000,0
.CAN5      DB %01111000,%11111100,%11111100,%11111100,%11111100,%01111000,0
.CAN6      DB %00111000,%01111100,%11111110,%11111110,%11111110,%01111100,%00111000,0
.CAN7      DB %00111100,%01111110,%11111111,%11111111,%11111111,%11111111,%01111110,%00111100,0


Aerosol.titl    MSG_Aerosol_title : DB 13      ;   
                DB #17,1 : MSG_Aerosol_DithCan
                DB #17,10 : MSG_Aerosol_PixelSp
                DB 13,15,#00

BAerosol     ld (BDithCan.sp),sp
             ld (BSpray.sp),sp
             call SV_UNDO
              call InitLUndo
.re          ld hl,(VAerosol.xy)
             ld (WDithCan),hl
             ld (WSpray),hl
             ld hl,VAerosol.s_i
             ld a,(hl)
             ld (BSpray.size),a
             inc hl
             ld a,(hl)
             ld (BSpray.inte),a
             inc hl
             ld a,(hl)
             ld (WDithCan.Mode),a
             inc hl
             ld a,(hl)
             ld (WDithCan.Slow),a
             ld a,(VAerosol.type)
             or a
            jp nz,BSpray

BDithCan
.ln_         call ReWin  ; ReWin.i
1            ld a,%1111
.l1          ld ix,WDithCan
             ld (ix+6),a
             ld sp,0
.sp    EQU $-2
             ld a,(REALRGB)
             ld (WDithCan.dtCOL),a
             call Win_
             cp #FF
            jr z, .exit
             or a
            jr z,.next   ;  
             dec a
            jr z,.reselect  ;  
             dec a
             ld c,a
             sub 8
            jr nc,.opex

             ld hl, .CanDat+2  ;  
             push hl
             ld b,8
             ld de,5
1            ld (hl),0
             add hl,de
            djnz 1B
             pop hl
             ld a,c
             add a,a
             add a,a
             add a,c
             ld e,a
             add hl,de
             ld (hl),1

.next        ld a,%1101
            jr .l1

.reselect    ld a,1
             ld (VAerosol.type),a
             ld hl,BAerosol.re
            push hl
.exit        ld hl,(WDithCan)
             ld (VAerosol.xy),hl
             ld hl,VAerosol.mods
             ld a,(WDithCan.Mode)
             ld (hl),a
             inc hl
             ld a,(WDithCan.Slow)
             ld (hl),a

            jp CLOSE


.opex
               ld hl,.ln_                ; for ret to .ln_
               push hl

               ld a,c

               cp 12                  ; increase
              jp z, .increase
               cp 13                  ; decrease
              jp z, .decrease
               cp 18
              jp z,QviewScreen              ; Q view (     )

               ld hl,.next               ; for ret to .next
               ex (sp),hl

              sub WDithCan.lastSW-1
             ret c
       ;       or a
             jr nz,1F
.no_RGB       ld a,(WDithCan.NoRGBcol)     ; no RGB
              xor 2
              ld (WDithCan.NoRGBcol),a
             ret

1             dec a
             jp z, PRGB2                   ; RGB

             ret

.Drgb
              call .svLayer
             call PRGB2
              call .retLayer
            jp .Can_Mode




.Cr
            ld de,#0103
            ld bc,#0801    ;      ; [IX] -   
            ld a,7*8
            call SetAtrW   ; in  a= color, e = y , d = x , b = sx , c = sy

            ld hl,.CanDat
            call .outCan

          ret


.outCan    ld a,(hl)
           cp #FF
          ret z
           ld d,(hl)   ; hl -   .CanDat
           inc hl
           ld e,(hl)
           inc hl
           call RealWin   ; d -x e -y
           ld bc,CTB+(8*4)       ; chunk
           ld a,(hl)
           inc hl
           or a
          jr z,1F
           ld bc,CTB+(15*4)       ; chunk
1          ld (.otCch),bc
           ld c,(hl)
           inc hl
           ld b,(hl)
           inc hl         ; bc - address of .CAN*
           push hl
           call RASCH     ; hl - address
           ld d,b
           ld e,c         ; de - address of .CAN*
           call .outCan_
           pop hl
          jr .outCan

.outCan_
           ld a,(de)
           inc de
           or a
          ret z
           push hl
           push de
.l_otC     ld de,CTB+(8*4)
.otCch   EQU $-2
           or a
          jr z, .otC_e
           rla
          jr c, 1F
           ld de,CTB
1          ex af,af'   ;  
           push hl
            ld b,4
2          ld a,(de)
           and #F0
           ld (hl),a
           inc de
           inc h
          djnz 2B
           pop hl
           ex af,af'
           ld de,(.otCch)
           or a
           rla
          jr c,1F
           ld de,CTB
1          ex af,af'   ;  
           push hl
            ld b,4
2          ld a,(de)
           and #0F
           or (hl)
           ld (hl),a
           inc de
           inc h
          djnz 2B
           pop hl
           inc l
           ex af,af'
          jr .l_otC
.otC_e     pop de
           pop hl
           ld a,3
           add a,h
           ld h,a
           call INC_Y
          jr .outCan_

.copyLayer    ld a,SuxPage|#10   ;     (layer)
              call Ram
              ld hl,#4000
              ld de,#E000
              ld bc,6912
              ldir
             ret
.svLayer
              ld a,(SaveLUndo+1)
              and 1
             jr z,1F
              call SwapSuxSCRS
              ld a,ScrPage|#10
              ld (SaveLUndo+1),a
1             call .suxRam
              ld hl,#E000
              ld de,#C000
2             ld bc,6912
              ldir
             ret
.Col          call .svLayer
              call Col
.retLayer     call .suxRam
              ld hl,#C000
              ld de,#E000
             jr 2B

.suxRam       ld a,SuxPage|#10
             jp Ram

.increase
             call .I_mod
            jr 1F
.decrease
             call .D_mod

1
.Run
           ;  call ERASE_ALLW  ; EraseAllw
           ;  call LOADSCR
             call LoadScr_CLW  ; v3.12
             call .copyLayer
             ld hl,.CanDat+2    ;  
             ld bc,5
             xor a
1             bit 0,(hl)        ;     ))
             jr nz, 2F
              inc a
              add hl,bc
             jr 1B
2
              inc hl
              ld e,(hl)
              inc hl
              ld d,(hl)
              ld (.DrCodADR),de
              ld hl,DithCanOvb.S_CAN
              add a,l
              ld l,a
              ld a,(hl)
              ld (.C_size),a
              or a
              rra      ; /2
              ld (.StX),a
              ld (.StY),a


              call .Slow_Mode
              call .NoRGB_Mode
              call .Can_Mode
;              call .saveSCR_
;             jr .RunW0
;.RunW_        ld a,(.fl_undo)
;              or a
;              call nz,.saveSCR_
.RunW0       ; ld a,%1000
              ld (.RunW0_SP+1),sp
              xor a
              ld (BRK),a
              ld (MWHEEL),a

              ld a,%1000
              ld ix,.WDraw
              ld (ix+6),a
           ;    ld a,(MBut2toFire2)    ; (WDithCan.MButt_2)
           ;    or a
           ;    ld a,ArrCancel_Y
           ;   jr z,1F
;               ld a,Fire2Cancel_N ;ArrCancel_N
;1              call GUI
               call Fire2Cancel_N_
              call Win_
.RunW0_SP     ld sp,#0000
              cp #FF
             jr z, 1F
              ld hl,.RunW0
              push hl
              ld bc,.TabRun
             jp TAB_JP

         ;     pop hl
1
          ;    call .saveSCR_
               call SuxLUndo
               call SAVESCR
           ;   ld a,Fire2Cancel_Y ; ArrCancel_Y   ;  cancel
           ;   call GUI
               call Fire2Cancel_Y_
              ld a,ARW_DEFAULT
            jp GUI

.TabRun        DW .Drgb           ; 0 Color
               DW .NoRGB_         ; 1 NO RGB
               DW .Col            ; 2 K Color
               DW LastUndo        ; 3  last cancel
               DW .I_mod          ; 4  Increase mode
               DW .D_mod          ; 5  Decrease mode
               DW .Mode_set       ; 6  Mode -
               DW .Slowly_ex      ; 7  Slowly +-
               DW .copyLayer      ; 8  next layer
               DW LOADUNDO_       ; 9  load Undo
               DW SWP_Undo        ; 10 swap Undo
               DW SV_UNDO_        ; 11 save Undo
               DW SWAP_SCR2       ; 12 swap screens
               DW .Mode_setmin    ; 13 Mode +
               DW SWP_But2toFIRE2 ; 14 swap 2rd mouse button use fo fire2


.I_mod        xor a     ; a=[ nop ]      ; Increase
             jr 1F
.D_mod        ld a,#EB  ; a=[ ex de,hl ] ; Decrease
1            ld (.fl_EXmod ),a
            ret

.I_mod_       ld hl,.I_out
             xor a            ; nop
            jr 1F

.D_mod_      ld hl,.D_out
             ld a,#AE          ; xor (hl)
1            ld (.DrawPRC),hl
             ld (.Dr_MOD),a
            ret

.Mode_setmin  ld a,(WDithCan.Mode)
              or a
             jr nz,1F
              ld a,(WDithCan.Mode-1)   ; 
1             dec a
             jr 1F
.Mode_set
              ld a,(WDithCan.Mode-1)   ; 
              ld c,a
              ld a,(WDithCan.Mode)
              inc a
              cp c
             jr c,1F
              xor a
1             ld (WDithCan.Mode),a
.Can_Mode     xor a             ; nop for layer mode
              ld (.or_b),a
              ld (.xor_b),a
              ld a,(WDithCan.Mode)
              or a
              ld c,a
              ld hl,DithCUR.s0   ; Layer mode select
              ld b,#01           ; ld b,nn
              ld a,#C8           ; ret z
            ;  ld e,#FA           ; (#CB,#FA = set 7,d )
              ld e,#A0           ; for layer mode
             jr z,1F
              ld a,#B0           ; or b for any modes
              ld (.or_b),a
              ld a,#A8           ; xor b for any modes
              ld (.xor_b),a
              ld a,#C8           ; ret z
              ld hl,DithCUR.s1   ; Tube mode select
            ;  ld e,#BA           ; (#CB,#BA = res 7,d )
              ld e,0              ; for not layer mode
              dec c
             jr z,1F

              ld hl,DithCUR.s2   ; Spraying mode select
              ld b,#CD           ; call nn
              dec c
             jr z,1F

              ld hl,DithCUR.s3   ; Aerosol mode select
              xor a              ; nop

1
              ld (.DretZ),a
              ld a,b
              ld (.Lmod_b),a
              ld a,e
            ;  ld (.set7D+1),a
              ld (.addForD),a

              ld (ARW_ADR),hl
              ld hl,#0100
              ld (ARW_XDISP),hl

           ret

.Slowly_ex   ld a, (WDithCan.Slow)
             cpl
             ld (WDithCan.Slow),a
.Slow_Mode   ld a,(WDithCan.Slow)
             or a
             ld a,6
            jr z,1F
             ld a,12
1            ld (.MaxCount),a
            ret


.NoRGB_      call .no_RGB
.NoRGB_Mode  ld a,(WDithCan.NoRGBcol)
             bit 1,a
             ld a,#12  ; ld (de),a    for RGB mode
            jr nz,1F
             xor a     ; nop for No RGB mode
1            ld (.MixCol_),a
            ret


.DrawINT
              ld a,(MWHEEL)
              or a
             jr z,2F
              push af
              xor a
              ld (MWHEEL),a
              ld a,STOP_ARW
              call GUI_
              pop af
              cp 8
              ld a,13 ; mode +
             jr c,1F
              ld a,6  ; mode -
1            jp .RunW0_SP

2            push ix
             push iy

             ld ix,DithCanOvb.CAN0
.DrCodADR  EQU $-2
             ld hl,.I_mod_
             ld de,.D_mod_
.fl_EXmod     ex de,hl        ; nop / ex de,hl
             ld a,(DIRECT)
              ld c,a
           ;   ld a,(BRK)
           ;   cp 6              ; %110
           ;  jr nz,1F
              ld a,(Fire2)
              or a
             jr z,1F
              ex de,hl
              set 4,c
1             call JP_HL    ;  
              ld a,c
              and #10
            jr  nz, 1F
              ld a,1
.firenew    EQU $-1
              or a
             jr z,9F
              xor a
              ld (.firenew),a   ; =0  
              call SaveLUndo

9            ld hl,#FFFF
             ld (.LastXY),hl
             ld a,1
             ld (.int_Count),a
            jr 3F
1            ld (.firenew),a   ; !=0
             ld a,5
.int_Count  EQU $-1
             dec a
             ld (.int_Count),a
            jr nz,2F
             ld a,6
.MaxCount EQU $-1               ; Max Int. counter   
             ld (.int_Count),a
.Lmod_b      call .cleanBF      ; call / ld bc,nn   
2            ld a,SuxPage|#10   ; ld a,ScrPage|#10
             call Ram
             call .Draw
3            call guiRAM

             pop iy
             pop ix
            ret

.Draw      ;  ld a,1            ;     .
           ;  ld (.fl_undo),a
             ld hl,(ARW_X)
             ld a,l
             rrca
             rrca
             and #3F
             ld e,a
             ld a,h
             rrca
             rrca
             and #3F
             ld d,a           ; de -    

             ld hl,0
.LastXY    EQU $-2            ;    #FFFF
             ld bc,#7F7F      ;     
             bit 7,h          ;   
            jr nz,.newLast    ;   
             ld a,d
             sub h
             ld b,a           ;   Y
             ld a,e
             sub l
             ld c,a           ;   X
             or b
.DretZ       ret z             ; ret z / nop :       nop


.newLast    push de
             ld (.LastXY),de
             ld a,(.C_size)
             ld e,a
             ld a,b
             call .modA
             cp e
            jr nc,3F
              or a
             jr z, 1F
              bit 7,b
              call .rotYbf   ;    Y  z - , nz -  , a -  ,

1            ld a,c
             call .modA
             cp e
            jr nc,3F
              or a
            jr z,4F
              bit 7,c
              call .rotXbf   ;    X  z - , nz -  , a -  
            jr 4F
3            call .cleanBF     ;  

4           pop de

             ld iy,DithCanOvb.dBuff

             ld a,d
             sub 0
.StX   EQU $-1        ;      
             ld d,a
             ld a,e
             sub 0
.StY  EQU $-1         ;      
             ld e,a


             ; de -      ,   
             ld a,e
             ex af,af'
             ld a,d
             rlca
             rlca
             rlca
             rlca
             and #E0
             ld e,a
             ld a,d
             rrca
             ld b,a
             xor #40
             and #60
             ld c,a
             bit 7,b
            jr z,1F
             set 2,c  ;  
1            ld a,b
             and #18
             or c
             ld d,a   ; de -     ,   ,  d < #40 => bit 6,d == 0  d >= #58
             ex af,af'
             ld c,a

           ; ix - CAN-adsres ; de   ,  - x
             ld b,1
.C_size  EQU $-1

.Lp_draw     ld a,d
             cp #58
            ret nc

             push bc
              cp #40
            jr c,.e_002

             ld a,(ix)
             ld b,(iy)
.or_b        or b      ; or b / nop ; nop - for layer
             ld (iy),a
.xor_b       xor b     ; xor b /nop ; nop - for layer
             ld b,8
1            or a
            jr z, .e_002           ; end
             rla
             push af
            jr nc,.e_001


             ;    


             ld a,c
             cp 64
            jr nc,.e_001      ;  
             push de
             ld hl,.e_0hl
             push hl         ;  
             srl a
             push af
             add a,e
             ld e,a                 ;  
;.set7D       set 7,d       ; set 7,d / res 7,d   ;   
             ld a,d
             or #A0
.addForD    EQU $-1      ; #A0 for layer OR #00 for all
             ld d,a

             pop af
            jp c, .dr_nod     ;   
            jp .dr_odd        ;   


.e_0hl     ;  res 7,d       ;   
             ld a,#5F       ;  D
             and d
             ld d,a
             ld a,(de)
             or (hl)
.Dr_MOD      xor (hl)    ; nop /xor (hl) for Increase/Decrease
             ld (de),a

             ld a,d
             rrca
             rrca
             rrca
             and 3
             or #58
             ld d,a
             ld a,(de)
             call MIXCOL
.MixCol_     ld (de),a   ; ld a,(de) / nop  ;     No RGB

             pop de

.e_001      inc c
            pop af
           djnz 1B
.e_002
           ld a,4
           add a,d
           ld d,a
           and 7
          jr nz,1F
           ld a,e
           sub #E0
           ld e,a
           sbc a,a
           and #F8
           add a,d
           ld d,a

1
            inc ix
            inc iy
            pop bc
           djnz .Lp_draw
          ret

.cleanBF   push hl
            ld hl,DithCanOvb.dBuff
            xor a
           DUP 8
            ld (hl),a
            inc l
           EDUP
           pop hl
          ret

.rotXbf    push hl         ;    X  z - , nz - , a - 
           push bc
            ld b,a
          jr nz,.rotXbf_
1           ld hl,DithCanOvb.dBuff
             DUP 8
              or a
              rl (hl)
              inc l
             EDUP
            djnz 1B
           pop bc
           pop hl
          ret
.rotXbf_    ld hl,DithCanOvb.dBuff
             DUP 8
              or a
              rr (hl)
              inc l
             EDUP
            djnz .rotXbf_
           pop bc
           pop hl
          ret

.rotYbf    push hl          ;    Y  z - , nz -  , a -  
           push bc
           ld b,a
          jr z,.rotYbf_
1          ld hl,DithCanOvb.dBuff+7
           DUP 7
            dec l
            ld a,(hl)
            inc l
            ld (hl),a
            dec l
           EDUP
            ld (hl),0
           djnz 1B
           pop bc
           pop hl
          ret
.rotYbf_   ld hl,DithCanOvb.dBuff
           DUP 7
            inc l
            ld a,(hl)
            dec l
            ld (hl),a
            inc l
           EDUP
            ld (hl),0
           djnz .rotYbf_
           pop bc
           pop hl
          ret

.modA      bit 7,a        ; a=|a|
          ret z
           neg
          ret

.dr_nod    ; out nodd chunk ; de - addr
            ld hl,DithCanOvb.InodTB
           jr 1F
.dr_odd    ; out odd chunk ; de - addr
            ld hl,DithCanOvb.IoddTB
1         jp .I_out
.DrawPRC  EQU $-2
.I_out                   ;  p0
            inc d        ; 1
            ld a,(de)
            and (hl)
           ret z
            inc l
                          ; p1
            inc d
            inc d        ; 3
            ld a,(de)
            and (hl)
           ret z
            inc l
                          ; p2
            ld a,(de)
            and (hl)
           ret z
            inc l
                          ; p3
            dec d
            dec d        ; 1
            ld a,(de)
            and (hl)
           ret z
            inc l
                          ; p4
            dec d        ; 0
            ld a,(de)
            and (hl)
           ret z
            inc l
                          ;p5
            inc d
            inc d        ;2
            ld a,(de)
            and (hl)
           ret z
            inc l
                          ; p6
            ld a,(de)
            and (hl)
           ret z
            inc l
                          ; p7
            dec d
            dec d        ; 0
            ld a,(de)
            and (hl)
           ret z
            inc l
                          ; p8
            inc d
            inc d
            inc d        ; 3
            ld a,(de)
            and (hl)
           ret z
            inc l
                          ; p9
            dec d
            dec d        ; 1
            ld a,(de)
            and (hl)
           ret z
            inc l
                          ; p10
            ld a,(de)
            and (hl)
           ret z
            inc l
                          ; p11
            inc d
            inc d        ;3
            ld a,(de)
            and (hl)
           ret z
            inc l
                          ; p12
            dec d
            dec d
            dec d         ; 0
            ld a,(de)
            and (hl)
           ret z
            inc l
                          ; p13
            inc d
            inc d        ; 2
            ld a,(de)
            and (hl)
           ret z
            inc l
                          ; p14
            dec d
            dec d       ; 0
            ld a,(de)
            and (hl)
           ret z
            inc l
                          ; p15
            inc d
            inc d       ; 2
           ret



.D_out      ld a,15
            add a,l
            ld l,a        ; hl    
                          ;  p15
            inc d
            inc d        ;2
            ld a,(de)
            and (hl)
           ret nz
            dec l
                          ; p14
            dec d
            dec d        ;0
            ld a,(de)
            and (hl)
           ret nz
            dec l
                          ; p13
            inc d
            inc d         ;2
            ld a,(de)
            and (hl)
           ret nz
            dec l
                          ; p12
            dec d
            dec d        ;0
            ld a,(de)
            and (hl)
           ret nz
            dec l
                          ; p11
            inc d
            inc d
            inc d        ;3
            ld a,(de)
            and (hl)
           ret nz
            dec l
                          ; p10
            dec d
            dec d         ;1
            ld a,(de)
            and (hl)
           ret nz
            dec l
                          ; p9
            ld a,(de)
            and (hl)
           ret nz
            dec l
                          ; p8
            inc d
            inc d        ;3
            ld a,(de)
            and (hl)
           ret nz
            dec l
                          ; p7
            dec d
            dec d
            dec d        ;0
            ld a,(de)
            and (hl)
           ret nz
            dec l
                          ; p6
            inc d
            inc d        ;2
            ld a,(de)
            and (hl)
           ret nz
            dec l
                          ; p5
            ld a,(de)
            and (hl)
           ret nz
            dec l
                          ; p4
            dec d
            dec d        ;0
            ld a,(de)
            and (hl)
           ret nz
            dec l
                          ; p3
            inc d        ;1
            ld a,(de)
            and (hl)
           ret nz
            dec l
                          ; p2
            inc d
            inc d        ;3
            ld a,(de)
            and (hl)
           ret nz
            dec l
                          ; p1
            ld a,(de)
            and (hl)
           ret nz
            dec l
                          ; p0
            dec d
            dec d        ;1
           ret


.CanDat    DB 1,5,0   ; x,y,    / 1 -  , 0 - 
             DW DithCanOvb.CAN0    ; addres of data
           DB 3,5,0
             DW DithCanOvb.CAN1
           DB 5,5,0
             DW DithCanOvb.CAN2
           DB 8,5,0
             DW DithCanOvb.CAN3
           DB 11,5,1
             DW DithCanOvb.CAN4
           DB 1,8,0
             DW DithCanOvb.CAN5
           DB 5,8,0
             DW DithCanOvb.CAN6
           DB 10,8,0
             DW DithCanOvb.CAN7
           DB #FF


.WDraw    DB 0,0,32,24,0,0,%1000
          DB 0
          DW Nil          ; -
          DW Nil          ; - ()
          DW .HDrwBut     ;  
        ;  DW Nil          ; - ()
        ;  DW Nil          ; -
        ;  DW Nil          ; - 
        ;  DW Nil          ; 
        ;  DW Nil          ;   
          DW #0005         ;  
          DW .DrawINT     ;   ""
          DW #FFFF


; -  (hotkeys object)
.HDrwBut
        DB "C",0           ; C - RGB Colour
         DW 0
        DB "N",0           ; N - No RGB
         DW 1
        DB "K",0           ; K - miniRGB
         DW 2

     ;   DB "L",0           ; L - last  (cancel last do)
     ;    DW 3
        DB "Z",0           ; Z - last  (cancel last do)
         DW 3

        DB "1",0           ; 1 - Increase mode
         DW 4
        DB "2",0           ; 2 - Deacrease mode
         DW 5
        DB "3",0           ; 3 - Mode -
         DW 13
        DB "4",0           ; 4 - Mode +
         DW 6
        DB "5",0           ; 5 -Slowly +-
         DW 7
     ;   DB "X",0           ; X to Save to SCR
     ;    DW 8
        DB #0D,0           ; Enter to next layer ; Save to SCR
         DW 8
        DB CS,"U"          ; Cs/U - load Undo
         DW 9
        DB "U",0           ; U - swap at Undo
         DW 10
        DB "Y",0           ; Y - Save to Undo
         DW 11

        DB "L",0            ; L - swap screens
         DW 12

        DB "B",0            ;   - swap 2rd mouse button use to Fire2
         DW 14

        DB #FF


WDithCan   DB 10,2,19,18,5*8,5,%00001111
           DB 0
           DW .Text              ; -
           DW .SW                ; - ()
           DW .HWkeys            ;    
           DW .Butts             ; - ()
           DW .Flag              ; -
           DW .Radi              ; - 
           DW Nil                ; 
           DW BDithCan.Cr          ;   
        ;   DW BDithCan.WinInt      ;   ""
           DW #FFFF

.Text      DB #0A : DW Aerosol.titl
           DB 22,1,13
           MSG_DithCan_layer : DB 13
           MSG_DithCan_tube : DB 13
           MSG_DithCan_spray : DB 13
           MSG_DithCan_aerosol : DB 13
           DB 22,10,13
           MSG_DithCan_slowly : DB 13
       ;    MSG_2Mbut : DB 13
           DB 22,15,15
           DB " _>>",13," _>>",13
           DB 22,10,15
           MSG_DithCan_increase : DB 13
           MSG_DithCan_decrease : DB 13
           DB 0

.SW      DB 1,3,8,1,%11      ; 0
         DB 10,3,8,1,%11     ; 1
                          ; -2
         DB 1,5,1,1,%10     ; 0 2
         DB 3,5,1,1,%10     ; 1 3
         DB 5,5,2,2,%10     ; 2 4
         DB 8,5,2,2,%10     ; 3 5
         DB 11,5,3,3,%10    ; 4 6
         DB 1,8,3,3,%10     ; 5 7
         DB 5,8,4,4,%10     ; 6 8
         DB 10,8,4,4,%10    ; 7 9  ; / cans

         ; DB 1,11,8,1,%11    ;8  10 layer
         ; DB 1,12,8,1,%11    ;9  11 Tube
         ; DB 1,13,8,1,%11    ;10 12 Spray
         ; DB 1,14,8,1,%11    ;11 13 Aerosol
         DB 1,13,8,128+4,%11

         DB 10,15,8,1,%11   ; 12 14 Increase >>
         DB 10,16,8,1,%11   ; 13 15 Deacrease >>
         DB 10,13,8,1,%11   ; 14 16  Slow
     ;    DB 10,14,8,1,%11   ; 15 17  Use mouse button 2
         DB #FF

.lastSW  EQU 16 ; 17

.Radi     DB 8,13,10,4,2
.Mode EQU $-1
           DW Nil
          DB #FF

.Flag     DB 17,13,16,0
.Slow EQU $-1
           DW Nil
          DB #FF

.Butts
          DB 16,5,2,2,7,%11
.NoRGBcol   EQU $-2
           DW NORGBS
          DB 16,8,2,2,7,%11
           DW RGBS
          DB 16,10,2,2,6,%00
.dtCOL  EQU $-2
           DW DTRS
          DB #FF

.HWkeys
        DB "N",0
         DW 18                 ; no rgb
        DB "C",0
         DW 19                 ; rgb
        DB #0D,0
         DW 20                 ; q view

        DB #FF


DithCUR
.s0     DB 193,8,129,28,1,52,1,104   ; Layer ()
        DB 0,244,0,106,128,6,240,0
        DB 255,0,255,0
.s1     DB 143,0,7,80,3,56,1,92      ; Tube ()
        DB 0,46,128,22,192,14,224,4
        DB 193,8,243,0
.s2     DB 3,0,1,120,0,36,0,50       ; Spray ()
        DB 0,104,1,104,3,104,3,120
        DB 3,48,135,0
.s3     DB 7,0,7,112,3,48,3,120      ; Aerosol ()
        DB 3,104,3,72,3,72,3,88
        DB 3,120,3,0







; --------------------------------------------------------------------------

SprayPixTB  EQU #C000-#400    ;     #4000
RNDbuff     EQU SprayPixTB-22 ;      22 
                              ;       #**FF


BSpray
            ; call ERASE_ALLW         ; .eraseallw
            ; call LOADSCR
            ; call .svSundo
             ld hl,SprayPixTB
             ld de,#4000
             call install_plot
             call RNDF

.l0         ; call ERASE_ALLW        ; .eraseallw
            ; call LOADSCR
            ; call ReWin.i
             call ReWin
             call .inPmode
             ld a,#C9   ; ret
             ld (.outplotC),a
             ld a,#FF
             ld (.curX0),a
             ld (.curY0),a
             ld a,%1111
.l1          ld ix,WSpray
             ld (ix+6),a
             ld sp,0
.sp    EQU $-2
             ld a,(REALRGB)
             ld (WSpray.dt_col),a
             call Win_
             cp #FF
            jp z,.exit
.opex        ld bc,WSpray.TAB
            jp TAB_JP

.next        ld a,%1101
            jr .l1


.qview
             call QviewScreen
            jr .l0

.sel_rgb    call PRGB2
            jr .next



.outPxor
             xor a
            jr 1F
.outPor
             ld a,1
            jr 1F
.outPand
             ld a,2
            jr 1F
.outPnop
             ld a,3
1
             call .outPmode
            jr .next

.inPmode     ld a,(.outmode)
.outPmode    ld (.outmode),a
             ld hl,WSpray.setBcol
             ld b,4
            jp SetBCol

.outPnorgb   call .Dnorgb
             jr .next

.Dnorgb      ld a,(WSpray.setNoRGB)
             xor 2
             ld (WSpray.setNoRGB),a
             ret


.reselect      xor a
               ld (VAerosol.type),a
               ld hl,BAerosol.re
              push hl
.exit          ld hl,(WSpray)
               ld (VAerosol.xy),hl
               ld hl,VAerosol.s_i
               ld a,(.size)
               ld (hl),a
               inc hl
               ld a,(.inte)
               ld (hl),a
              jp CLOSE


.run                            ;    
             call LOADSCR
.run0      ;  ld a,(MBut2toFire2)  ;(WSpray.bt2)
           ;  or a
           ;  ld a,ArrCancel_Y
           ; jr z,1F
;             ld a,Fire2Cancel_N   ;ArrCancel_N
;1            call GUI
              call Fire2Cancel_N_
             ld hl, #0100       ;   
             ld (ARW_XDISP),hl
             ld hl,SPRAYCUR
             ld (ARW_ADR),hl    ;   

             ld c,#C9  ;ret
             ld a,(WSpray.setNoRGB)
             cp 5
            jr z,1F
             ld c,#78  ; ld a,b
1            ld a,c
             ld (.outplotC),a
             call ERASE_ALLW         ; .eraseallw
            ld ix,DSpray
             ld a,%1000
             ld (ix+6),a
             call Win_
             cp #FF
            jr z,.runquit
             cp 4
            jr nc,1F
             call .outPmode    ; xor/or/and/nop
            jr .run0
1            sub 4
             ld bc,DSpray.TAB
            call TAB_JP
             jr .run0

.runquit    ; ld a,Fire2Cancel_Y    ;ArrCancel_Y
            ; call GUI
              call Fire2Cancel_Y_
             ld a,ARW_DEFAULT
             call GUI
             call SuxLUndo
             call SAVESCR
            jp .l0

.Cr        ;    
            ld de,#0A03
            ld bc,#0801    ;      ; [IX] -   
            ld a,7*8
            call SetAtrW   ; in  a= color, e = y , d = x , b = sx , c = sy

            ld hl,#00B6    ; or (hl):nop    ; or
            ld (.outplotM),hl
            ld (.outplotcurM),hl

            ld de,GSpray.size             ;   
            ld hl,#0206
            call .spr2
            ld hl,#0209
            call .spr2

.setup                                   ; -  
            ld de,#0506
            ld a,(.size)
            ld b,9
            call .csbar
            ld b,5
            ld de,#0509
            ld a,(.inte)
            call .csbar
            ld de,#0A0C          ;  
            call RealWin
            ld l,d
            ld h,e
            dec l
            dec h
              ex de,hl     ;  
              call RASCH_
              ld c, 6*8+5   ; c -  
1              ld b,7      ; b -  
               push hl
2               ld (hl),0
                inc l
              djnz 2B
               pop hl
               call INC_Y
               dec c
              jr nz, 1B

             ld de,#0C0E        ;   
             call RealWin
             ld l,d
             ld h,e
             add hl,hl
             add hl,hl
             add hl,hl
             ld de,#0404
             add hl,de
             ex de,hl           ; de -  

              ld a,(.size)        ;   
              add a,a           ; *2
              add a,4
              ld (.RAD),a
              inc a
              ld (.rad),a

              xor a          ;   
1             push af
              call .rXY
              call nc,.outplot
              pop af
              add a,1
.tcircl  EQU $-1
             jr nc, 1B

                              ;  
              ld b,12
.l2           push bc

              ld a,(.RAD)
              ld (.rad_),a
              sub 4
             jr nc,1F   ;   
              xor a
1       ;      and #1E  ;  
              ld c,a
              ld b,0
              ld hl,.rdTBadr
              add hl,bc
              ld a,(hl)
              inc hl
              ld h,(hl)
              ld l,a
              ld (.rdtbADR),hl
              ld a,(.size)
              ld c,a
              ld a,(.inte)
              ld b,a
              add a,a
              add a,a
              add a,b
              add a,12
              sub c
             ld (.spray_pls1),a
             ld b,a
             add a,a
             add a,a
             ld (.spray_pls2),a
1             push bc
              call .rndXY
              pop bc
             djnz 1B
              pop bc
             djnz .l2
            ret

.csbar         ;  -  b , a -  , DE - d-x,e-y
               ld c,a
               ld a,b
               push bc
               sub c
               ld c,a
               call RealWin
               ld h,e
               ld l,d
               ld (.spr1_ix),hl
1              ld a,c
               ld de,GSpray.csbar0
               cp b
              jr nz,2F
               ld de,GSpray.csbar1
2              push bc
                call .spr1
               pop bc
              djnz 1B
               pop bc
               ret


.spr1       ;  de -   ,   
              push ix
               ld ix,.spr1_ix
               call LoadWS
               ld a,(.spr1_ix)
               inc a
               ld (.spr1_ix),a
              pop ix
              ret


.spr2       ;  de -  ,  h=x , l=y size 16x16
              ex de,hl
              call RealWin
              push ix
              ld ix,.spr2_ix
              ld (ix+0),d
              ld (ix+1),e
              ex de,hl
              call LoadWS
              pop ix
              ret

.DrawInt
              ld hl,#00AE     ;    
              ld de,#AE00
              ld a,(.outmode)
              or a
             jr z,1F
              ld l,#B6 ; hl=#00B6
              ld e,l   ; de=#AEB6
              dec a
             jr z,1F
              ld h,d   ; hl=#AEB6
              ld d,0   ; de=#00B6
              dec a
             jr z,1F
              ld h,d
              ld l,d
              ld e,d   ; hl=de=0
1        ;     ld a,(MBut2toFire2)  ; (WSpray.bt2)
              ld b,1
.spray_pls1 EQU $-1
         ;     or a
              ld a,(DIRECT)
              ld c,a
         ;    jr z,1F
          ;    ld a,(BRK)
          ;    cp 6           ; %110
          ;   jr nz,1F
              ld a,(Fire2)
              or a
             jr z,1F
              ld b,1
.spray_pls2 EQU $-1
              set 4,c
              ex de,hl
1             ld (.outplotM),hl
              ld (.outplotcurM),hl
              ld a,b
              ld (.spray_pls),a
              bit 4,c
           ;   ret z
             jr nz,1F
              ld a,1   ; v 3.12 for last undo
.firenew    EQU $-1
              or a
             ret z
              xor a
              ld (.firenew),a   ; =0  
              call SaveLUndo
             jp guiRAM

1             ld (.firenew),a   ; !=0
              call PutArw   ;   GUI -  .     .
              ld hl,(ARW_X)
              ld (.DIntArwX),hl
              ld de,(ARW_XDISP)
              ld a,l
              sub e
             jr nc,1F
              xor a
1             and #F8
              ld (.curX0),a
              ld a,h
              sub d
             jr nc,1F
              xor a
1             ld (.curY0),a

              ld b,8
.spray_pls EQU $-1   ;  
1
              ld de,0
.DIntArwX  EQU $-2

2             push bc
              call .rndXY
              pop bc
             djnz 2B
4             call GetArw   ;   GUI -    
              ret


.WinInt          ;     
              ld a,(DIRECT)
              bit 4,a
              ret z
              ld hl,(ARW_XC)
              ld bc,(WSpray)
              ld a,h
              sub b
              ld d,a     ; y .
              ret c
              ld a,l
              sub c
              ld e,a     ; x .
              ret c
                          ;      
              ld a,e
              sub 5
              ld e,a      ;  
             ret c
              cp 9
             ret nc
              ld hl,.size
              ld a,d
              cp 6
             jr z, 1F
              inc hl
              cp 9
             ret nz
              ld a,e
              cp 5
             ret nc
1             ld (hl),e
             jp .setup




.spr1_ix    DB 0,0,1,1
.spr2_ix    DB 0,0,2,2

.size       DB 4
.inte       DB 2
.outmode    DB 1          ; xor/or/and/nop







.rndXY                    ; in de: d=y e=x out draw rnd plot
             ld b,20      ;   
.rad_   EQU $-1
1            call RND   ; X
             sra a
             sra a
    ;         sra a      ;     +/- 32
             ld c,a
             bit 7,a
            jr z, 2F
             neg        ; 
2            cp 20
            jr nc,1B
             cp b
            ret nc

             ld hl,.rdtb20
.rdtbADR  EQU $-2              ;     
             add a,l
             ld l,a
            jr nc, 4F
             inc h
4                          ; hl -   Y
5            call RND
             sra a
             sra a
 ;            sra a
             ld b,a
             bit 7,a
            jr z,6F
             neg
6            cp 20
            jr nc,5B
             cp (hl)
            ret nc

7
             ld a,d   ;y
             add a,b
             bit 7,b
            jr z, 1F   ;+
             ccf
1            ret c          ;    
             cp 192
             ret nc
             ld h,a
             ld a,e   ;x
             add a,c
             bit 7,c
            jr z,1F
             ccf
1            ret c
             ld l,a         ; x
             and #F8        ;   
             sub 0          ;     
.curX0   EQU $-1           ;   X -  
            jr c,.outplot
             cp 16          ;    
            jr nc,.outplot
             ex af,af'
             ld a,h         ; y
             sub 0
.curY0   EQU $-1           ;   Y -  
            jr c,.outplot
             cp ARW_YR      ;  
            jr nc, .outplot
             add a,a
             ex af,af'
             bit 3,a
            jr z,1F
             ex af,af'
             inc a          ;      
             ex af,af'
1
          ;       / in h -y, l-x
              push de,bc
              ex de,hl
              call .pixadr    ;    
              ld de,PLACE
              ex af,af'
              add a,e
              ld e,a
             jr nc,1F
              inc d
1             ld a,(de)  ; de    
.outplotcurM  or (hl)         ;   
              nop
              ld (de),a
              call .outplotC
              pop bc,de
              ret

.outplot                 ; in h -y, l-x
              push de,bc
              ex de,hl
              call .pixadr
              ld a,(bc)
.outplotM     or (hl)         ;   
              nop
              ld (bc),a
              call .outplotC
              pop bc,de
              ret
.outplotC     ld a,b             ; ld a,b / ret
              rrca
              rrca
              rrca
              and 3
              or #58           ; bc - 
              ld b,a
              ld a,(bc)
              call MIXCOL
              ld (bc),a
              ret

.pixadr
             ld h,high SprayPixTB
             ld l,d
             ld a,(hl)   ;   
             inc h
             ld b,(hl)   ;    
             inc h
             ld l,e
             or (hl)     ; + x  
             ld c,a      ;  
             inc h       ; (hl) - 
             ret



.rXY                       ;  a -   Pi/128  [0-255]
             push de
             push af
             and #3F
             ld c,a        ; bc -     
             ld b,0
             ld hl,.sin64_128
             add hl,bc
             call .rXYml
             ex af,af'
             ld hl,.sin64_128+64
             or a
             sbc hl,bc
             call .rXYml
             ld c,a      ;x
             ex af,af'
             ld b,a      ;y
             pop af
             pop de
             rla
             ld h,a
             ld a,c
            jr nc,1F
             neg         ; -X
             add a,e
             ccf
            jr 2F
1            add a,e
2            ret c
             ld l,a
             ld a,h
             rla
             ld a,b
            jr nc,1F
             neg        ; -y
             add a,d
             ccf
            jr 2F
1            add a,d
2            ret c
             cp 192
             ccf
             ret c
             ld h,a
             or a
             ret

.rXYml     ld h,(hl)
             ld a,4
.rad       EQU $-1       ;   (    )
             call MULS
             add hl,hl
             ld a,h
             ret

.RAD      DB  4      ; radius

.sin64_128    ;   65    PI/128   128 ;      
           DB 0,3,6,9,13,16,19,22,25,28,31,34,37,40,43,46
           DB 49,52,54,58,60,63,66,68,71,74,76,79,81,84,86,88
           DB 91,93,95,97,99,101,103,105,106,108,110,111,113,114,116,117
           DB 118,119,121,122,122,123,124,125,126,126,127,127,127,128,128,128,128



         ;   x  y  x= 0 ... 20
.rdTBadr    DW .rdtb4,.rdtb6,.rdtb8,.rdtb10,.rdtb12,.rdtb14,.rdtb16,.rdtb18,.rdtb20
              ;
.rdtb4      DB 4,4,3,2
.rdtb6      DB 6,6,6,5,4,3
.rdtb8      DB 8,8,8,7,7,6,5,4
.rdtb10     DB 10,10,10,10,9,9,8,7,6,4
.rdtb12     DB 12,12,12,12,11,11,10,10,9,8,7,5
.rdtb14     DB 14,14,14,14,13,13,13,12,11,11,10,9,7,5
.rdtb16     DB 16,16,16,16,15,15,15,14,14,13,12,12,11,9,8,6
.rdtb18     DB 18,18,18,18,18,17,17,17,16,16,15,14,13,12,11,10,8,6
.rdtb20     DB 20,20,20,20,20,19,19,19,18,18,17,17,16,15,14,13,12,11,9,6

SPRAYCUR   DB 225,0,192,156,224,10,224,12
           DB 192,18,192,18,192,22,192,22
           DB 225,12,243,0

DSpray     DB 0,0,32,24,0,0,%1000
           DB 0
         ;  DW Nil              ; -
         ;  DW Nil              ; - ()
           DW 2
           DW .HDraw           ;  
      ;     DW Nil              ; - ()
      ;     DW Nil              ; -
      ;     DW Nil              ; - 
      ;     DW Nil              ; 
      ;     DW Nil              ;   
           DW 5
           DW BSpray.DrawInt   ;   ""
           DW #FFFF

.TAB       ; DW BSpray.exSundo        ; 4 - SUndo
            DW SWP_Undo              ; 4 - Undo
            DW BSpray.Dnorgb         ; 5 - no rgb
            DW PRGB2 ; BSpray.Drgb   ; 6 - rgb
            DW Col                   ; 7 - mini rgb
            DW LOADUNDO_             ; 8 - load UNDO
            DW SV_UNDO_              ; 9  - save UNDO
            DW LastUndo              ; 10 - Last Undo
            DW SWAP_SCR2             ; 11 - swap Screens
            DW SWP_But2toFIRE2       ; 12 - swap mouse but2 use to Fire2


.HDraw
        DB "1",0
         DW 0                 ; xor
        DB "2",0
         DW 1                 ; or
        DB "3",0
         DW 2                 ; and
        DB "4",0
         DW 3                 ; nop
        DB "U",0
         DW 4                 ; undo
        DB "N",0
         DW 5                 ; No RGB
        DB "C",0
         DW 6                 ; rgb
        DB "K",0
         DW 7                 ; mini RGB

        DB CS,"U"             ; Cs/U - load Undo
         DW 8
        DB "Y",0              ; Y - Save to Undo
         DW 9
        DB "Z",0              ; Z - Last Undo
         DW 10
        DB "L",0              ; Swap Screens
         DW 11
        DB "B",0              ; swap mouse but2 use to Fire2
         DW 12

        DB #FF




WSpray     DB 10,2,19,18,5*8,5,%00001111
           DB 0
           DW .txt               ; -
           DW .SWspr             ; - ()
           DW .HWkeys            ;    
           DW .Butts             ; - ()
        ;   DW Nil ;.flags             ; -
        ;   DW Nil                ; - 
        ;   DW Nil                ; 
           DW 3
           DW BSpray.Cr          ;   
           DW BSpray.WinInt      ;   ""
           DW #FFFF

.txt       DB #0A : DW Aerosol.titl ; : DB 13,22,1,16
         ;  MSG_2Mbut
           DB 0

.SWspr     DB 10,12,5,5,%11
           DB 1,3,8,1,%11      ; 1
           DB 10,3,8,1,%11     ; 2
      ;     DB 1,16,8,1,%11     ;   3 - flag
           DB #FF

.Butts
           DB 1,13,2,2,7,%11  ; 1 - xor
.setBcol EQU $-2
           DW XORS
           DB 3,13,2,2,5,%11  ; 2 - or
           DW ORS
           DB 5,13,2,2,7,%11  ; 3 - and
           DW ANDS
           DB 7,13,2,2,7,%11  ; 4 - nop
           DW NOPS
           DB 16,5,2,2,7,%11 ; 5 - NO RGB
.setNoRGB EQU $-2
           DW NORGBS
           DB 16,8,2,2,7,%11 ; 6 - RGB
           DW RGBS
           DB 16,10,2,2,7,%00 ; 7 - DTRS
.dt_col  EQU $-2                   ;   
           DW DTRS
           DB 16,15,2,2,6,%11 ; 8 - Spray run
           DW SPRAYS

           DB #FF



.TAB       DW BSpray.run            ; 0  - Run
           DW BSpray.reselect       ; 1  - select dithering
           DW BSpray.next           ; 2  - select pixels ignory
           DW BSpray.outPxor        ; 3  - xor
           DW BSpray.outPor         ; 4  - or
           DW BSpray.outPand        ; 5  - and
           DW BSpray.outPnop        ; 6  - nop
           DW BSpray.outPnorgb      ; 7  - no RGB
           DW BSpray.sel_rgb        ; 8  - RGB
           DW BSpray.sel_rgb        ; 9  - DTRS
           DW BSpray.run            ; 10 - Run
           DW BSpray.qview          ; 11 - q view ; 13 10 - q view


.HWkeys
        DB "1",0
         DW 3                 ; xor
        DB "2",0
         DW 4                 ; or
        DB "3",0
         DW 5                 ; and
        DB "4",0
         DW 6                 ; nop
        DB "N",0
         DW 7                 ; no rgb
        DB "C",0
         DW 8                 ; rgb
        DB #0D,0
         DW 11                ; q view

        DB #FF


QviewScreen   call LOADSCR
             jp NOKEY_

RNDF           ld hl,RNDbuff  ;     RND
1              ld a,r
               and #07
               ld b,a
               ld a,#35
.seed   EQU $-1
2              bit 0,a
              jr z,3F
               xor %01110000
3              rrca
              djnz 2B
               ld (.seed),a
               ld (hl),a
               inc l
              jr nz,1B
               ret


;RND           ;     ,    256   98  . /DA
;             push hl,de,bc
;             ld de,RNDbuff+256-97   ; 97 a
;.ia      EQU $-2
;             ld hl,RNDbuff+256-33   ; 33 b
;.ib      EQU $-2
;             ld bc,RNDbuff          ; 0 i
;.ii      EQU $-2
;             ld a,(de)
;             sub (hl)
;             ld (bc),a           ; X[i]= X[i-a]-X[i-b]
;             inc l
;             inc c
;             inc e
;             ld (.ia),de
;             ld (.ib),hl
;             ld (.ii),bc
;             pop bc,de,hl
;             ret

RND      push hl        ; code based of http://zx-pk.ru/threads/9031-etyudy.html?p=930124&viewfull=1#post930124   at blackmirror
         ld hl,RNDbuff  ;    22 
.bfadr EQU $-2
         ld a,(hl)
         inc l
        jr z,.rnd_2
.rnd_1   sub (hl)
         ld (hl),a
         ld (.bfadr),hl
         pop hl
       ret
.rnd_2   ld l,-22
        jp .rnd_1


GSpray                             ;  
.size   DB 0,4,0,8,0,16,0,36       ;  
        DB 0,78,0,149,57,4,42,4
        DB 69,4,84,149,84,78,84,36
        DB 68,16,68,8,124,4,0,0
.inte   DB 0,4,0,8,0,16,0,36       ; 
        DB 0,64,0,142,57,0,42,31
        DB 69,0,84,142,84,64,84,36
        DB 68,16,68,8,124,4,0,0

.csbar0 DB 0,0,0,126,66,126,0,0       ;   -  
.csbar1 DB 0,24,60,110,126,126,60,24  ;   -  


LAerosol    EQU $-Aerosol

         ASSERT  $ < #C000

       DISPLAY "Aerosol len   :",/a,LAerosol

